/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.intothevoid.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.mcreator.intothevoid.world.features.BasementFeature;
import net.mcreator.intothevoid.world.features.BossFeature;
import net.mcreator.intothevoid.world.features.CampFeature;
import net.mcreator.intothevoid.world.features.TreeFeature;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber
public class IntothevoidModFeatures {
    public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"intothevoid");
    private static final List<FeatureRegistration> FEATURE_REGISTRATIONS = new ArrayList<FeatureRegistration>();
    public static final RegistryObject<Feature<?>> CAMP = IntothevoidModFeatures.register("camp", CampFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, CampFeature.GENERATE_BIOMES, CampFeature::placedFeature));
    public static final RegistryObject<Feature<?>> TREE = IntothevoidModFeatures.register("tree", TreeFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, TreeFeature.GENERATE_BIOMES, TreeFeature::placedFeature));
    public static final RegistryObject<Feature<?>> BASEMENT = IntothevoidModFeatures.register("basement", BasementFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, BasementFeature.GENERATE_BIOMES, BasementFeature::placedFeature));
    public static final RegistryObject<Feature<?>> BOSS = IntothevoidModFeatures.register("boss", BossFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, BossFeature.GENERATE_BIOMES, BossFeature::placedFeature));

    private static RegistryObject<Feature<?>> register(String registryname, Supplier<Feature<?>> feature, FeatureRegistration featureRegistration) {
        FEATURE_REGISTRATIONS.add(featureRegistration);
        return REGISTRY.register(registryname, feature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        for (FeatureRegistration registration : FEATURE_REGISTRATIONS) {
            if (registration.biomes() != null && !registration.biomes().contains(event.getName())) continue;
            event.getGeneration().getFeatures(registration.stage()).add(registration.placedFeature().get());
        }
    }

    private record FeatureRegistration(GenerationStep.Decoration stage, Set<ResourceLocation> biomes, Supplier<Holder<PlacedFeature>> placedFeature) {
    }
}

