/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.morestuff.init;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Map;
import net.mcreator.morestuff.world.biome.CherryBlossomBiome;
import net.mcreator.morestuff.world.biome.EveryStructureBiomeBiome;
import net.mcreator.morestuff.world.biome.ExtremeMountainsBiome;
import net.mcreator.morestuff.world.biome.ObsidianCavesBiome;
import net.mcreator.morestuff.world.biome.OmegaBiomeBiome;
import net.mcreator.morestuff.world.biome.PeacefulOmegaBiomeBiome;
import net.mcreator.morestuff.world.biome.QuartzBiomeBiome;
import net.mcreator.morestuff.world.biome.ShadowForestBiome;
import net.mcreator.morestuff.world.biome.WarmExtremeMountainsBiome;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MoreStuffModBiomes {
    public static final DeferredRegister<Biome> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)"more_stuff");
    public static final RegistryObject<Biome> EXTREME_MOUNTAINS = REGISTRY.register("extreme_mountains", () -> ExtremeMountainsBiome.createBiome());
    public static final RegistryObject<Biome> WARM_EXTREME_MOUNTAINS = REGISTRY.register("warm_extreme_mountains", () -> WarmExtremeMountainsBiome.createBiome());
    public static final RegistryObject<Biome> EVERY_STRUCTURE_BIOME = REGISTRY.register("every_structure_biome", () -> EveryStructureBiomeBiome.createBiome());
    public static final RegistryObject<Biome> SHADOW_FOREST = REGISTRY.register("shadow_forest", () -> ShadowForestBiome.createBiome());
    public static final RegistryObject<Biome> CHERRY_BLOSSOM = REGISTRY.register("cherry_blossom", () -> CherryBlossomBiome.createBiome());
    public static final RegistryObject<Biome> QUARTZ_BIOME = REGISTRY.register("quartz_biome", () -> QuartzBiomeBiome.createBiome());
    public static final RegistryObject<Biome> OMEGA_BIOME = REGISTRY.register("omega_biome", () -> OmegaBiomeBiome.createBiome());
    public static final RegistryObject<Biome> PEACEFUL_OMEGA_BIOME = REGISTRY.register("peaceful_omega_biome", () -> PeacefulOmegaBiomeBiome.createBiome());
    public static final RegistryObject<Biome> OBSIDIAN_CAVES = REGISTRY.register("obsidian_caves", () -> ObsidianCavesBiome.createBiome());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ExtremeMountainsBiome.init();
            WarmExtremeMountainsBiome.init();
            EveryStructureBiomeBiome.init();
            ShadowForestBiome.init();
            CherryBlossomBiome.init();
            QuartzBiomeBiome.init();
            OmegaBiomeBiome.init();
            PeacefulOmegaBiomeBiome.init();
            ObsidianCavesBiome.init();
        });
    }

    @Mod.EventBusSubscriber
    public static class BiomeInjector {
        @SubscribeEvent
        public static void onServerAboutToStart(ServerAboutToStartEvent event) {
            MinecraftServer server = event.getServer();
            Registry dimensionTypeRegistry = server.m_206579_().m_175515_(Registry.f_122818_);
            Registry biomeRegistry = server.m_206579_().m_175515_(Registry.f_122885_);
            WorldGenSettings worldGenSettings = server.m_129910_().m_5961_();
            for (Map.Entry entry : worldGenSettings.m_204655_().m_6579_()) {
                NoiseGeneratorSettings moddedNoiseGeneratorSettings;
                ArrayList<SurfaceRules.RuleSource> surfaceRules;
                SurfaceRules.SequenceRuleSource sequenceRuleSource;
                SurfaceRules.RuleSource currentRuleSource;
                BiomeSource noiseGeneratorSettings;
                NoiseBasedChunkGenerator noiseGenerator;
                MultiNoiseBiomeSource moddedNoiseSource;
                ArrayList<Pair> parameters;
                MultiNoiseBiomeSource noiseSource;
                ChunkGenerator chunkGenerator;
                DimensionType dimensionType = (DimensionType)((LevelStem)entry.getValue()).m_204521_().m_203334_();
                if (dimensionType == dimensionTypeRegistry.m_123013_(DimensionType.f_63845_)) {
                    chunkGenerator = ((LevelStem)entry.getValue()).m_63990_();
                    BiomeSource biomeSource = chunkGenerator.m_62218_();
                    if (biomeSource instanceof MultiNoiseBiomeSource) {
                        noiseSource = (MultiNoiseBiomeSource)biomeSource;
                        parameters = new ArrayList<Pair>(noiseSource.f_48435_.m_186850_());
                        parameters.add(new Pair((Object)ExtremeMountainsBiome.PARAMETER_POINT, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)EXTREME_MOUNTAINS.getId()))));
                        parameters.add(new Pair((Object)WarmExtremeMountainsBiome.PARAMETER_POINT, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)WARM_EXTREME_MOUNTAINS.getId()))));
                        parameters.add(new Pair((Object)EveryStructureBiomeBiome.PARAMETER_POINT, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)EVERY_STRUCTURE_BIOME.getId()))));
                        parameters.add(new Pair((Object)ShadowForestBiome.PARAMETER_POINT, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)SHADOW_FOREST.getId()))));
                        parameters.add(new Pair((Object)CherryBlossomBiome.PARAMETER_POINT, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)CHERRY_BLOSSOM.getId()))));
                        parameters.add(new Pair((Object)ObsidianCavesBiome.PARAMETER_POINT, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)OBSIDIAN_CAVES.getId()))));
                        parameters.add(new Pair((Object)ObsidianCavesBiome.PARAMETER_POINT_UNDERGROUND, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)OBSIDIAN_CAVES.getId()))));
                        moddedNoiseSource = new MultiNoiseBiomeSource(new Climate.ParameterList(parameters), noiseSource.f_48438_);
                        chunkGenerator.f_62137_ = moddedNoiseSource;
                        chunkGenerator.f_62138_ = moddedNoiseSource;
                    }
                    if (chunkGenerator instanceof NoiseBasedChunkGenerator) {
                        noiseGenerator = (NoiseBasedChunkGenerator)chunkGenerator;
                        noiseGeneratorSettings = (NoiseGeneratorSettings)noiseGenerator.f_64318_.m_203334_();
                        currentRuleSource = noiseGeneratorSettings.f_188871_();
                        if (currentRuleSource instanceof SurfaceRules.SequenceRuleSource) {
                            sequenceRuleSource = (SurfaceRules.SequenceRuleSource)currentRuleSource;
                            surfaceRules = new ArrayList<SurfaceRules.RuleSource>(sequenceRuleSource.f_189697_());
                            surfaceRules.add(1, BiomeInjector.anySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)OBSIDIAN_CAVES.getId()), Blocks.f_50080_.m_49966_(), Blocks.f_50080_.m_49966_(), Blocks.f_50069_.m_49966_()));
                            surfaceRules.add(1, BiomeInjector.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)EXTREME_MOUNTAINS.getId()), Blocks.f_50568_.m_49966_(), Blocks.f_50127_.m_49966_(), Blocks.f_50127_.m_49966_()));
                            surfaceRules.add(1, BiomeInjector.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)WARM_EXTREME_MOUNTAINS.getId()), Blocks.f_50440_.m_49966_(), Blocks.f_50493_.m_49966_(), Blocks.f_50493_.m_49966_()));
                            surfaceRules.add(1, BiomeInjector.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)EVERY_STRUCTURE_BIOME.getId()), Blocks.f_50440_.m_49966_(), Blocks.f_50493_.m_49966_(), Blocks.f_50493_.m_49966_()));
                            surfaceRules.add(1, BiomeInjector.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)SHADOW_FOREST.getId()), Blocks.f_50440_.m_49966_(), Blocks.f_50493_.m_49966_(), Blocks.f_50493_.m_49966_()));
                            surfaceRules.add(1, BiomeInjector.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)CHERRY_BLOSSOM.getId()), Blocks.f_50440_.m_49966_(), Blocks.f_50493_.m_49966_(), Blocks.f_50493_.m_49966_()));
                            surfaceRules.add(1, BiomeInjector.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)OBSIDIAN_CAVES.getId()), Blocks.f_50080_.m_49966_(), Blocks.f_50080_.m_49966_(), Blocks.f_50069_.m_49966_()));
                            moddedNoiseGeneratorSettings = new NoiseGeneratorSettings(noiseGeneratorSettings.f_64439_(), noiseGeneratorSettings.f_64440_(), noiseGeneratorSettings.f_64441_(), noiseGeneratorSettings.f_209353_(), SurfaceRules.m_198272_((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])surfaceRules.toArray(SurfaceRules.RuleSource[]::new))), noiseGeneratorSettings.f_64444_(), noiseGeneratorSettings.f_64445_(), noiseGeneratorSettings.f_158533_(), noiseGeneratorSettings.m_209369_(), noiseGeneratorSettings.f_209354_());
                            noiseGenerator.f_64318_ = new Holder.Direct((Object)moddedNoiseGeneratorSettings);
                        }
                    }
                }
                if (dimensionType != dimensionTypeRegistry.m_123013_(DimensionType.f_63846_)) continue;
                chunkGenerator = ((LevelStem)entry.getValue()).m_63990_();
                noiseGeneratorSettings = chunkGenerator.m_62218_();
                if (noiseGeneratorSettings instanceof MultiNoiseBiomeSource) {
                    noiseSource = (MultiNoiseBiomeSource)noiseGeneratorSettings;
                    parameters = new ArrayList(noiseSource.f_48435_.m_186850_());
                    parameters.add(new Pair((Object)QuartzBiomeBiome.PARAMETER_POINT, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)QUARTZ_BIOME.getId()))));
                    moddedNoiseSource = new MultiNoiseBiomeSource(new Climate.ParameterList(parameters), noiseSource.f_48438_);
                    chunkGenerator.f_62137_ = moddedNoiseSource;
                    chunkGenerator.f_62138_ = moddedNoiseSource;
                }
                if (!(chunkGenerator instanceof NoiseBasedChunkGenerator)) continue;
                noiseGenerator = (NoiseBasedChunkGenerator)chunkGenerator;
                noiseGeneratorSettings = (NoiseGeneratorSettings)noiseGenerator.f_64318_.m_203334_();
                currentRuleSource = noiseGeneratorSettings.f_188871_();
                if (!(currentRuleSource instanceof SurfaceRules.SequenceRuleSource)) continue;
                sequenceRuleSource = (SurfaceRules.SequenceRuleSource)currentRuleSource;
                surfaceRules = new ArrayList(sequenceRuleSource.f_189697_());
                surfaceRules.add(1, BiomeInjector.anySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)QUARTZ_BIOME.getId()), Blocks.f_50331_.m_49966_(), Blocks.f_50331_.m_49966_(), Blocks.f_50331_.m_49966_()));
                moddedNoiseGeneratorSettings = new NoiseGeneratorSettings(noiseGeneratorSettings.f_64439_(), noiseGeneratorSettings.f_64440_(), noiseGeneratorSettings.f_64441_(), noiseGeneratorSettings.f_209353_(), SurfaceRules.m_198272_((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])surfaceRules.toArray(SurfaceRules.RuleSource[]::new))), noiseGeneratorSettings.f_64444_(), noiseGeneratorSettings.f_64445_(), noiseGeneratorSettings.f_158533_(), noiseGeneratorSettings.m_209369_(), noiseGeneratorSettings.f_209354_());
                noiseGenerator.f_64318_ = new Holder.Direct((Object)moddedNoiseGeneratorSettings);
            }
        }

        private static SurfaceRules.RuleSource preliminarySurfaceRule(ResourceKey<Biome> biomeKey, BlockState groundBlock, BlockState undergroundBlock, BlockState underwaterBlock) {
            return SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{biomeKey}), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189425_(), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)false, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189382_((int)-1, (int)0), (SurfaceRules.RuleSource)SurfaceRules.m_189390_((BlockState)groundBlock)), SurfaceRules.m_189390_((BlockState)underwaterBlock)})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)true, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.m_189390_((BlockState)undergroundBlock))})));
        }

        private static SurfaceRules.RuleSource anySurfaceRule(ResourceKey<Biome> biomeKey, BlockState groundBlock, BlockState undergroundBlock, BlockState underwaterBlock) {
            return SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{biomeKey}), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)false, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189382_((int)-1, (int)0), (SurfaceRules.RuleSource)SurfaceRules.m_189390_((BlockState)groundBlock)), SurfaceRules.m_189390_((BlockState)underwaterBlock)})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)true, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.m_189390_((BlockState)undergroundBlock))}));
        }
    }
}

