/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.morestuff.init;

import net.mcreator.morestuff.entity.MoobloomEntity;
import net.mcreator.morestuff.entity.OmegaBowEntity;
import net.mcreator.morestuff.entity.OmegaPigEntity;
import net.mcreator.morestuff.entity.OmegaZombieEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MoreStuffModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"more_stuff");
    public static final RegistryObject<EntityType<OmegaZombieEntity>> OMEGA_ZOMBIE = MoreStuffModEntities.register("omega_zombie", EntityType.Builder.m_20704_(OmegaZombieEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(OmegaZombieEntity::new).m_20719_().m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<MoobloomEntity>> MOOBLOOM = MoreStuffModEntities.register("moobloom", EntityType.Builder.m_20704_(MoobloomEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(MoobloomEntity::new).m_20699_(0.9f, 1.4f));
    public static final RegistryObject<EntityType<OmegaBowEntity>> OMEGA_BOW = MoreStuffModEntities.register("projectile_omega_bow", EntityType.Builder.m_20704_(OmegaBowEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(OmegaBowEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<OmegaPigEntity>> OMEGA_PIG = MoreStuffModEntities.register("omega_pig", EntityType.Builder.m_20704_(OmegaPigEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(OmegaPigEntity::new).m_20699_(0.9f, 0.9f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            OmegaZombieEntity.init();
            MoobloomEntity.init();
            OmegaPigEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)OMEGA_ZOMBIE.get(), OmegaZombieEntity.createAttributes().m_22265_());
        event.put((EntityType)MOOBLOOM.get(), MoobloomEntity.createAttributes().m_22265_());
        event.put((EntityType)OMEGA_PIG.get(), OmegaPigEntity.createAttributes().m_22265_());
    }
}

