/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.morestuff.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.mcreator.morestuff.world.features.ores.EnderiteOreFeature;
import net.mcreator.morestuff.world.features.ores.OmegaOreFeature;
import net.mcreator.morestuff.world.features.ores.RubyOreFeature;
import net.mcreator.morestuff.world.features.ores.SapphireOreFeature;
import net.mcreator.morestuff.world.features.ores.TopazOreFeature;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber
public class MoreStuffModFeatures {
    public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"more_stuff");
    private static final List<FeatureRegistration> FEATURE_REGISTRATIONS = new ArrayList<FeatureRegistration>();
    public static final RegistryObject<Feature<?>> OMEGA_ORE = MoreStuffModFeatures.register("omega_ore", OmegaOreFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, OmegaOreFeature.GENERATE_BIOMES, OmegaOreFeature::placedFeature));
    public static final RegistryObject<Feature<?>> RUBY_ORE = MoreStuffModFeatures.register("ruby_ore", RubyOreFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, RubyOreFeature.GENERATE_BIOMES, RubyOreFeature::placedFeature));
    public static final RegistryObject<Feature<?>> SAPPHIRE_ORE = MoreStuffModFeatures.register("sapphire_ore", SapphireOreFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, SapphireOreFeature.GENERATE_BIOMES, SapphireOreFeature::placedFeature));
    public static final RegistryObject<Feature<?>> TOPAZ_ORE = MoreStuffModFeatures.register("topaz_ore", TopazOreFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, TopazOreFeature.GENERATE_BIOMES, TopazOreFeature::placedFeature));
    public static final RegistryObject<Feature<?>> ENDERITE_ORE = MoreStuffModFeatures.register("enderite_ore", EnderiteOreFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, EnderiteOreFeature.GENERATE_BIOMES, EnderiteOreFeature::placedFeature));

    private static RegistryObject<Feature<?>> register(String registryname, Supplier<Feature<?>> feature, FeatureRegistration featureRegistration) {
        FEATURE_REGISTRATIONS.add(featureRegistration);
        return REGISTRY.register(registryname, feature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        for (FeatureRegistration registration : FEATURE_REGISTRATIONS) {
            if (registration.biomes() != null && !registration.biomes().contains(event.getName())) continue;
            event.getGeneration().getFeatures(registration.stage()).add(registration.placedFeature().get());
        }
    }

    private record FeatureRegistration(GenerationStep.Decoration stage, Set<ResourceLocation> biomes, Supplier<Holder<PlacedFeature>> placedFeature) {
    }
}

