/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.evocation.init;

import net.mcreator.evocation.entity.CloneRiddlerEntity;
import net.mcreator.evocation.entity.IllagerEnchanterEntity;
import net.mcreator.evocation.entity.RiddlerEntity;
import net.mcreator.evocation.entity.VexSummonEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class EvocationModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"evocation");
    public static final RegistryObject<EntityType<VexSummonEntity>> VEX_SUMMON = EvocationModEntities.register("vex_summon", EntityType.Builder.m_20704_(VexSummonEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(VexSummonEntity::new).m_20699_(0.4f, 0.4f));
    public static final RegistryObject<EntityType<IllagerEnchanterEntity>> ILLAGER_ENCHANTER = EvocationModEntities.register("illager_enchanter", EntityType.Builder.m_20704_(IllagerEnchanterEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(IllagerEnchanterEntity::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<RiddlerEntity>> RIDDLER = EvocationModEntities.register("riddler", EntityType.Builder.m_20704_(RiddlerEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(RiddlerEntity::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<CloneRiddlerEntity>> CLONE_RIDDLER = EvocationModEntities.register("clone_riddler", EntityType.Builder.m_20704_(CloneRiddlerEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(CloneRiddlerEntity::new).m_20699_(0.6f, 1.8f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            VexSummonEntity.init();
            IllagerEnchanterEntity.init();
            RiddlerEntity.init();
            CloneRiddlerEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)VEX_SUMMON.get(), VexSummonEntity.createAttributes().m_22265_());
        event.put((EntityType)ILLAGER_ENCHANTER.get(), IllagerEnchanterEntity.createAttributes().m_22265_());
        event.put((EntityType)RIDDLER.get(), RiddlerEntity.createAttributes().m_22265_());
        event.put((EntityType)CLONE_RIDDLER.get(), CloneRiddlerEntity.createAttributes().m_22265_());
    }
}

