/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.morebiomes.init;

import java.util.ArrayList;
import java.util.List;
import net.mcreator.morebiomes.world.biome.ExtremeHillsBiome;
import net.mcreator.morebiomes.world.biome.ExtremeTaigaHillsBiome;
import net.mcreator.morebiomes.world.biome.TaigaWoodlandsBiome;
import net.mcreator.morebiomes.world.biome.TreePlainsBiome;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MorebiomesModBiomes {
    private static final List<Biome> REGISTRY = new ArrayList<Biome>();
    public static Biome TAIGA_WOODLANDS = MorebiomesModBiomes.register("taiga_woodlands", TaigaWoodlandsBiome.createBiome());
    public static Biome EXTREME_TAIGA_HILLS = MorebiomesModBiomes.register("extreme_taiga_hills", ExtremeTaigaHillsBiome.createBiome());
    public static Biome EXTREME_HILLS = MorebiomesModBiomes.register("extreme_hills", ExtremeHillsBiome.createBiome());
    public static Biome TREE_PLAINS = MorebiomesModBiomes.register("tree_plains", TreePlainsBiome.createBiome());

    private static Biome register(String registryname, Biome biome) {
        REGISTRY.add((Biome)biome.setRegistryName(new ResourceLocation("morebiomes", registryname)));
        return biome;
    }

    @SubscribeEvent
    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])REGISTRY.toArray(new Biome[0]));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            TaigaWoodlandsBiome.init();
            ExtremeTaigaHillsBiome.init();
            ExtremeHillsBiome.init();
            TreePlainsBiome.init();
        });
    }
}

