/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.runekitbarrowsbrothersmod.network;

import java.util.function.Supplier;
import net.mcreator.runekitbarrowsbrothersmod.BarrowsBrothersModMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class BarrowsBrothersModModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        BarrowsBrothersModMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class PlayerVariablesSyncMessage {
        public PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.ahrim_count = message.data.ahrim_count;
                    variables.dharok_count = message.data.dharok_count;
                    variables.guthan_count = message.data.guthan_count;
                    variables.karil_count = message.data.karil_count;
                    variables.torag_count = message.data.torag_count;
                    variables.verac_count = message.data.verac_count;
                    variables.ahrim_killed = message.data.ahrim_killed;
                    variables.dharok_killed = message.data.dharok_killed;
                    variables.guthan_killed = message.data.guthan_killed;
                    variables.karil_killed = message.data.karil_killed;
                    variables.torag_killed = message.data.torag_killed;
                    variables.verac_killed = message.data.verac_killed;
                    variables.barrows_count = message.data.barrows_count;
                    variables.displayOverlayTrue = message.data.displayOverlayTrue;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double ahrim_count = 0.0;
        public double dharok_count = 0.0;
        public double guthan_count = 0.0;
        public double karil_count = 0.0;
        public double torag_count = 0.0;
        public double verac_count = 0.0;
        public boolean ahrim_killed = false;
        public boolean dharok_killed = false;
        public boolean guthan_killed = false;
        public boolean karil_killed = false;
        public boolean torag_killed = false;
        public boolean verac_killed = false;
        public double barrows_count = 0.0;
        public boolean displayOverlayTrue = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                BarrowsBrothersModMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("ahrim_count", this.ahrim_count);
            nbt.m_128347_("dharok_count", this.dharok_count);
            nbt.m_128347_("guthan_count", this.guthan_count);
            nbt.m_128347_("karil_count", this.karil_count);
            nbt.m_128347_("torag_count", this.torag_count);
            nbt.m_128347_("verac_count", this.verac_count);
            nbt.m_128379_("ahrim_killed", this.ahrim_killed);
            nbt.m_128379_("dharok_killed", this.dharok_killed);
            nbt.m_128379_("guthan_killed", this.guthan_killed);
            nbt.m_128379_("karil_killed", this.karil_killed);
            nbt.m_128379_("torag_killed", this.torag_killed);
            nbt.m_128379_("verac_killed", this.verac_killed);
            nbt.m_128347_("barrows_count", this.barrows_count);
            nbt.m_128379_("displayOverlayTrue", this.displayOverlayTrue);
            return nbt;
        }

        public void readNBT(Tag Tag2) {
            CompoundTag nbt = (CompoundTag)Tag2;
            this.ahrim_count = nbt.m_128459_("ahrim_count");
            this.dharok_count = nbt.m_128459_("dharok_count");
            this.guthan_count = nbt.m_128459_("guthan_count");
            this.karil_count = nbt.m_128459_("karil_count");
            this.torag_count = nbt.m_128459_("torag_count");
            this.verac_count = nbt.m_128459_("verac_count");
            this.ahrim_killed = nbt.m_128471_("ahrim_killed");
            this.dharok_killed = nbt.m_128471_("dharok_killed");
            this.guthan_killed = nbt.m_128471_("guthan_killed");
            this.karil_killed = nbt.m_128471_("karil_killed");
            this.torag_killed = nbt.m_128471_("torag_killed");
            this.verac_killed = nbt.m_128471_("verac_killed");
            this.barrows_count = nbt.m_128459_("barrows_count");
            this.displayOverlayTrue = nbt.m_128471_("displayOverlayTrue");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("barrows_brothers_mod", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getPlayer().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getPlayer().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getPlayer().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.ahrim_count = original.ahrim_count;
            clone.dharok_count = original.dharok_count;
            clone.guthan_count = original.guthan_count;
            clone.karil_count = original.karil_count;
            clone.torag_count = original.torag_count;
            clone.verac_count = original.verac_count;
            clone.ahrim_killed = original.ahrim_killed;
            clone.dharok_killed = original.dharok_killed;
            clone.guthan_killed = original.guthan_killed;
            clone.karil_killed = original.karil_killed;
            clone.torag_killed = original.torag_killed;
            clone.verac_killed = original.verac_killed;
            clone.barrows_count = original.barrows_count;
            clone.displayOverlayTrue = original.displayOverlayTrue;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }
    }
}

