/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.berrycows.entity;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.mcreator.berrycows.BerrycowsModElements;
import net.mcreator.berrycows.entity.renderer.BerryCowRenderer;
import net.mcreator.berrycows.procedures.BerryCowNaturalEntitySpawningConditionProcedure;
import net.mcreator.berrycows.procedures.CheckBerryGrowProcedure;
import net.mcreator.berrycows.procedures.CheckIschildProcedure;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.EatGrassGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.registries.ForgeRegistries;

@BerrycowsModElements.ModElement.Tag
public class BerryCowEntity
extends BerrycowsModElements.ModElement {
    public static EntityType entity = (EntityType)EntityType.Builder.func_220322_a(CustomEntity::new, (EntityClassification)EntityClassification.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(CustomEntity::new).func_220321_a(0.6f, 1.7f).func_206830_a("berry_cow").setRegistryName("berry_cow");

    public BerryCowEntity(BerrycowsModElements instance) {
        super(instance, 3);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new BerryCowRenderer.ModelRegisterHandler());
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new EntityAttributesRegisterHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> entity);
        this.elements.items.add(() -> (Item)new SpawnEggItem(entity, -855329, -13395457, new Item.Properties().func_200916_a(ItemGroup.field_78026_f)).setRegistryName("berry_cow_spawn_egg"));
    }

    @SubscribeEvent
    public void addFeatureToBiomes(BiomeLoadingEvent event) {
        event.getSpawns().getSpawner(EntityClassification.CREATURE).add(new MobSpawnInfo.Spawners(entity, 8, 4, 5));
    }

    @Override
    public void init(FMLCommonSetupEvent event) {
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)entity, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            return BerryCowNaturalEntitySpawningConditionProcedure.executeProcedure(Stream.of(new AbstractMap.SimpleEntry<String, IServerWorld>("world", world), new AbstractMap.SimpleEntry<String, Integer>("x", x), new AbstractMap.SimpleEntry<String, Integer>("y", y), new AbstractMap.SimpleEntry<String, Integer>("z", z)).collect(HashMap::new, (_m, _e) -> _m.put(_e.getKey(), _e.getValue()), Map::putAll));
        });
    }

    public static class CustomEntity
    extends AnimalEntity {
        public static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(CustomEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
        private EatGrassGoal eatGrassGoal;
        public int berryTimer;

        public CustomEntity(FMLPlayMessages.SpawnEntity packet, World world) {
            this((EntityType<CustomEntity>)entity, world);
        }

        public CustomEntity(EntityType<CustomEntity> type, World world) {
            super(type, world);
            this.field_70728_aV = 2;
            this.func_94061_f(false);
        }

        public IPacket<?> func_213297_N() {
            return NetworkHooks.getEntitySpawningPacket((Entity)this);
        }

        protected void func_184651_r() {
            super.func_184651_r();
            this.eatGrassGoal = new EatGrassGoal((MobEntity)this){

                public boolean func_75250_a() {
                    double x = this.func_226277_ct_();
                    double y = this.func_226278_cu_();
                    double z = this.func_226281_cx_();
                    CustomEntity entity = this;
                    return super.func_75250_a() && CheckBerryGrowProcedure.executeProcedure(Stream.of(new AbstractMap.SimpleEntry<String, CustomEntity>("entity", entity)).collect(HashMap::new, (_m, _e) -> _m.put(_e.getKey(), _e.getValue()), Map::putAll));
                }
            };
            this.field_70714_bg.func_75776_a(1, (Goal)new FollowParentGoal(this, 0.8){

                public boolean func_75250_a() {
                    double x = this.func_226277_ct_();
                    double y = this.func_226278_cu_();
                    double z = this.func_226281_cx_();
                    CustomEntity entity = this;
                    return super.func_75250_a() && CheckIschildProcedure.executeProcedure(Stream.of(new AbstractMap.SimpleEntry<String, CustomEntity>("entity", entity)).collect(HashMap::new, (_m, _e) -> _m.put(_e.getKey(), _e.getValue()), Map::putAll));
                }
            });
            this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.15));
            this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
            this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.0, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151015_O}), false));
            this.field_70714_bg.func_75776_a(4, (Goal)this.eatGrassGoal);
            this.field_70714_bg.func_75776_a(3, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
            this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(5, (Goal)new SwimGoal((MobEntity)this));
        }

        public CreatureAttribute func_70668_bt() {
            return CreatureAttribute.field_223222_a_;
        }

        public SoundEvent func_184639_G() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.cow.ambient"));
        }

        public void func_180429_a(BlockPos pos, BlockState blockIn) {
            this.func_184185_a((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.cow.step")), 0.15f, 1.0f);
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.cow.hurt"));
        }

        public SoundEvent func_184615_bR() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.cow.death"));
        }

        public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageable) {
            CustomEntity retval = (CustomEntity)entity.func_200721_a((World)serverWorld);
            retval.func_213386_a((IServerWorld)serverWorld, serverWorld.func_175649_E(new BlockPos((Vector3i)retval.func_233580_cy_())), SpawnReason.BREEDING, null, null);
            return retval;
        }

        public boolean func_70877_b(ItemStack stack) {
            if (stack == null) {
                return false;
            }
            return Items.field_151015_O == stack.func_77973_b();
        }

        public void setVariant(int varIn) {
            this.field_70180_af.func_187227_b(VARIANT, (Object)varIn);
        }

        public int getVariant() {
            return (Integer)this.field_70180_af.func_187225_a(VARIANT);
        }

        protected void func_70088_a() {
            super.func_70088_a();
            this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        }

        public void func_213281_b(CompoundNBT compound) {
            super.func_213281_b(compound);
            compound.func_74768_a("Variant", this.getVariant());
        }

        public void func_70037_a(CompoundNBT compound) {
            super.func_70037_a(compound);
            this.setVariant(compound.func_74762_e("Variant"));
        }

        public PlayerEntity getBreederEntity() {
            String BredUUID = this.getPersistentData().func_74779_i("BredBy");
            if (BredUUID == null || BredUUID.length() == 0) {
                return null;
            }
            List allPlayers = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v();
            for (ServerPlayerEntity player : allPlayers) {
                if (!player.func_110124_au().toString().equals(BredUUID)) continue;
                return player;
            }
            return null;
        }

        public void func_70615_aA() {
            if (this.func_70631_g_()) {
                this.func_110195_a(60);
            }
        }

        protected void func_70619_bc() {
            this.berryTimer = this.eatGrassGoal.func_151499_f();
            super.func_70619_bc();
        }

        public void func_70636_d() {
            if (this.field_70170_p.field_72995_K) {
                this.berryTimer = Math.max(0, this.berryTimer - 1);
            }
            super.func_70636_d();
        }

        @OnlyIn(value=Dist.CLIENT)
        public void func_70103_a(byte id) {
            if (id == 10) {
                this.berryTimer = 20;
            } else {
                super.func_70103_a(id);
            }
        }
    }

    private static class EntityAttributesRegisterHandler {
        private EntityAttributesRegisterHandler() {
        }

        @SubscribeEvent
        public void onEntityAttributeCreation(EntityAttributeCreationEvent event) {
            AttributeModifierMap.MutableAttribute ammma = MobEntity.func_233666_p_();
            ammma = ammma.func_233815_a_(Attributes.field_233821_d_, 0.3);
            ammma = ammma.func_233815_a_(Attributes.field_233818_a_, 10.0);
            ammma = ammma.func_233815_a_(Attributes.field_233826_i_, 0.0);
            ammma = ammma.func_233815_a_(Attributes.field_233823_f_, 0.0);
            event.put(entity, ammma.func_233813_a_());
        }
    }
}

