/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.seila.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.mcreator.seila.world.features.lakes.AguadobrejoFeature;
import net.mcreator.seila.world.features.ores.AmbarBlockFeature;
import net.mcreator.seila.world.features.ores.BlocoDeTatuzinhoFeature;
import net.mcreator.seila.world.features.ores.CactoDaSorteFeature;
import net.mcreator.seila.world.features.ores.HahahaBlockFeature;
import net.mcreator.seila.world.features.ores.HappyFaceFeature;
import net.mcreator.seila.world.features.ores.RainbowlockFeature;
import net.mcreator.seila.world.features.ores.SandPearlFeature;
import net.mcreator.seila.world.features.ores.ShellFeature;
import net.mcreator.seila.world.features.plants.PlantaMoinhoFeature;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber
public class SeilaModFeatures {
    public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"seila");
    private static final List<FeatureRegistration> FEATURE_REGISTRATIONS = new ArrayList<FeatureRegistration>();
    public static final RegistryObject<Feature<?>> HAPPY_FACE = SeilaModFeatures.register("happy_face", HappyFaceFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, HappyFaceFeature.GENERATE_BIOMES, HappyFaceFeature::placedFeature));
    public static final RegistryObject<Feature<?>> SAND_PEARL = SeilaModFeatures.register("sand_pearl", SandPearlFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, SandPearlFeature.GENERATE_BIOMES, SandPearlFeature::placedFeature));
    public static final RegistryObject<Feature<?>> SHELL = SeilaModFeatures.register("shell", ShellFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, ShellFeature.GENERATE_BIOMES, ShellFeature::placedFeature));
    public static final RegistryObject<Feature<?>> RAINBOWLOCK = SeilaModFeatures.register("rainbowlock", RainbowlockFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, RainbowlockFeature.GENERATE_BIOMES, RainbowlockFeature::placedFeature));
    public static final RegistryObject<Feature<?>> HAHAHA_BLOCK = SeilaModFeatures.register("hahaha_block", HahahaBlockFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, HahahaBlockFeature.GENERATE_BIOMES, HahahaBlockFeature::placedFeature));
    public static final RegistryObject<Feature<?>> AMBAR_BLOCK = SeilaModFeatures.register("ambar_block", AmbarBlockFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, AmbarBlockFeature.GENERATE_BIOMES, AmbarBlockFeature::placedFeature));
    public static final RegistryObject<Feature<?>> CACTO_DA_SORTE = SeilaModFeatures.register("cacto_da_sorte", CactoDaSorteFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, CactoDaSorteFeature.GENERATE_BIOMES, CactoDaSorteFeature::placedFeature));
    public static final RegistryObject<Feature<?>> AGUADOBREJO = SeilaModFeatures.register("aguadobrejo", AguadobrejoFeature::feature, new FeatureRegistration(GenerationStep.Decoration.LAKES, AguadobrejoFeature.GENERATE_BIOMES, AguadobrejoFeature::placedFeature));
    public static final RegistryObject<Feature<?>> PLANTA_MOINHO = SeilaModFeatures.register("planta_moinho", PlantaMoinhoFeature::feature, new FeatureRegistration(GenerationStep.Decoration.VEGETAL_DECORATION, PlantaMoinhoFeature.GENERATE_BIOMES, PlantaMoinhoFeature::placedFeature));
    public static final RegistryObject<Feature<?>> BLOCO_DE_TATUZINHO = SeilaModFeatures.register("bloco_de_tatuzinho", BlocoDeTatuzinhoFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, BlocoDeTatuzinhoFeature.GENERATE_BIOMES, BlocoDeTatuzinhoFeature::placedFeature));

    private static RegistryObject<Feature<?>> register(String registryname, Supplier<Feature<?>> feature, FeatureRegistration featureRegistration) {
        FEATURE_REGISTRATIONS.add(featureRegistration);
        return REGISTRY.register(registryname, feature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        for (FeatureRegistration registration : FEATURE_REGISTRATIONS) {
            if (registration.biomes() != null && !registration.biomes().contains(event.getName())) continue;
            event.getGeneration().getFeatures(registration.stage()).add(registration.placedFeature().get());
        }
    }

    private record FeatureRegistration(GenerationStep.Decoration stage, Set<ResourceLocation> biomes, Supplier<Holder<PlacedFeature>> placedFeature) {
    }
}

