/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.recipemanager;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import io.netty.buffer.ByteBuf;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.apache.commons.lang3.mutable.MutableInt;

public class BasicBreedingRecipe
implements class_1860<class_1277> {
    private final class_2960 id;
    private final class_1799 output;
    private final class_2371<class_1856> recipeItems;
    private final Map<class_1856, Integer> inputs;

    public BasicBreedingRecipe(class_2960 id, Map<class_1856, Integer> inputs, class_1799 output, class_2371<class_1856> recipeItems) {
        this.id = id;
        this.output = output;
        this.inputs = inputs;
        this.recipeItems = recipeItems;
    }

    public boolean matches(class_1277 inventory, class_1937 world) {
        if (world.method_8608()) {
            return false;
        }
        return ((class_1856)this.recipeItems.get(0)).method_8093(inventory.method_5438(0)) && ((class_1856)this.recipeItems.get(1)).method_8093(inventory.method_5438(1));
    }

    public class_1799 craft(class_1277 inventory, class_5455 registryManager) {
        return this.output;
    }

    public boolean method_8118() {
        return true;
    }

    public class_2371<class_1856> method_8117() {
        class_2371 ingredients = class_2371.method_10213((int)2, (Object)class_1856.field_9017);
        for (int i = 0; i < this.recipeItems.size(); ++i) {
            ingredients.set(i, (Object)class_1856.method_8101((class_1799[])((class_1856)this.recipeItems.get(i)).method_8105()));
        }
        return ingredients;
    }

    public Map<class_1856, Integer> getIngredientsMap() {
        return this.inputs;
    }

    public boolean method_8113(int width, int height) {
        return width * height >= this.recipeItems.size();
    }

    public class_1799 method_8110(class_5455 registryManager) {
        return this.output.method_7972();
    }

    public class_1799 newOutput() {
        return this.output.method_7972();
    }

    public List<class_1856> getInput() {
        return this.recipeItems;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_1865<?> method_8119() {
        return Serializer.INSTANCE;
    }

    public class_3956<?> method_17716() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements class_1865<BasicBreedingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final String ID = "basic_breeding";

        public BasicBreedingRecipe read(class_2960 id, JsonObject json) {
            LinkedHashMap<IngredientData, MutableInt> ingredientDataToCount = new LinkedHashMap<IngredientData, MutableInt>();
            for (Object entry : class_3518.method_15261((JsonObject)json, (String)"ingredients")) {
                IngredientData inputData;
                JsonObject jsonObject = entry.getAsJsonObject();
                if (jsonObject.has("item")) {
                    inputData = new IngredientData(jsonObject.get("item").getAsString(), false);
                } else if (jsonObject.has("tag")) {
                    inputData = new IngredientData(jsonObject.get("tag").getAsString(), true);
                } else {
                    throw new JsonSyntaxException("An ingredient entry needs either a tag or an item");
                }
                ingredientDataToCount.computeIfAbsent(inputData, stringStringPair -> new MutableInt(0)).add(jsonObject.keySet().contains("count") ? jsonObject.get("count").getAsInt() : 1);
            }
            if (ingredientDataToCount.isEmpty()) {
                throw new JsonSyntaxException("Inputs cannot be empty");
            }
            if (ingredientDataToCount.keySet().size() > 10) {
                throw new JsonSyntaxException("Recipe has more than 10 distinct input ingredients");
            }
            LinkedHashMap<class_1856, Integer> ingredientToCount = new LinkedHashMap<class_1856, Integer>();
            for (Map.Entry entry : ingredientDataToCount.entrySet()) {
                IngredientData ingredientData = (IngredientData)entry.getKey();
                class_2960 identifier = new class_2960(ingredientData.data());
                class_1856 ingredient = ingredientData.isTag() ? class_1856.method_8106((class_6862)class_6862.method_40092((class_5321)class_7923.field_41178.method_30517(), (class_2960)identifier)) : class_1856.method_8091((class_1935[])new class_1935[]{class_3518.method_15256((JsonElement)new JsonPrimitive(ingredientData.data()), (String)identifier.toString())});
                ingredientToCount.put(ingredient, ((MutableInt)entry.getValue()).intValue());
            }
            class_1799 output = class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)json, (String)"output"));
            JsonArray jsonArray = class_3518.method_15261((JsonObject)json, (String)"ingredients");
            class_2371 inputs = class_2371.method_10213((int)2, (Object)class_1856.field_9017);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)class_1856.method_52177((JsonElement)jsonArray.get(i)));
            }
            return new BasicBreedingRecipe(id, ingredientToCount, output, (class_2371<class_1856>)inputs);
        }

        public BasicBreedingRecipe read(class_2960 id, class_2540 buf) {
            class_2540 buf2 = new class_2540((ByteBuf)buf);
            LinkedHashMap newinputs = (LinkedHashMap)buf2.method_34069(value -> new LinkedHashMap(), class_1856::method_8086, class_2540::method_10816);
            class_2371 inputs = class_2371.method_10213((int)buf.readInt(), (Object)class_1856.field_9017);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)class_1856.method_8086((class_2540)buf));
            }
            class_1799 output = buf.method_10819();
            return new BasicBreedingRecipe(id, newinputs, output, (class_2371<class_1856>)inputs);
        }

        public void write(class_2540 buf, BasicBreedingRecipe recipe) {
            buf.method_34063(recipe.getIngredientsMap(), (buf1, ingredient) -> ingredient.method_8088(buf1), class_2540::method_10804);
            buf.writeInt(recipe.method_8117().size());
            for (class_1856 ing : recipe.method_8117()) {
                ing.method_8088(buf);
            }
            buf.method_10793(recipe.output.method_7972());
        }
    }

    public static class Type
    implements class_3956<BasicBreedingRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "basic_breeding";

        private Type() {
        }
    }

    private record IngredientData(String data, boolean isTag) {
    }
}

