/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.unseenworld.entity;

import java.util.EnumSet;
import net.mcreator.unseenworld.init.UnseenWorldModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;

public class GhastOfTealiveValleyEntity
extends FlyingMob
implements Enemy {
    private static final EntityDataAccessor<Boolean> DATA_IS_CHARGING = SynchedEntityData.m_135353_(GhastOfTealiveValleyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int explosionPower = 1;

    public GhastOfTealiveValleyEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<GhastOfTealiveValleyEntity>)((EntityType)UnseenWorldModEntities.GHAST_OF_TEALIVE_VALLEY.get()), world);
    }

    public GhastOfTealiveValleyEntity(EntityType<GhastOfTealiveValleyEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 5;
        this.f_21342_ = new GhastMoveControl(this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new RandomFloatAroundGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new GhastLookGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new GhastShootFireballGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, p_32755_ -> Math.abs(p_32755_.m_20186_() - this.m_20186_()) <= 4.0));
    }

    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_CHARGING);
    }

    public void setCharging(boolean p_32759_) {
        this.f_19804_.m_135381_(DATA_IS_CHARGING, (Object)p_32759_);
    }

    public int getExplosionPower() {
        return this.explosionPower;
    }

    protected boolean m_8028_() {
        return true;
    }

    private static boolean isReflectedFireball(DamageSource p_238408_) {
        return p_238408_.m_7640_() instanceof LargeFireball && p_238408_.m_7639_() instanceof Player;
    }

    public boolean m_6673_(DamageSource p_238289_) {
        return !GhastOfTealiveValleyEntity.isReflectedFireball(p_238289_) && super.m_6673_(p_238289_);
    }

    public boolean m_6469_(DamageSource p_32730_, float p_32731_) {
        if (GhastOfTealiveValleyEntity.isReflectedFireball(p_32730_)) {
            super.m_6469_(p_32730_, 1000.0f);
            return true;
        }
        return this.m_6673_(p_32730_) ? false : super.m_6469_(p_32730_, p_32731_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_CHARGING, (Object)false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 16.0).m_22268_(Attributes.f_22277_, 100.0);
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11919_;
    }

    protected SoundEvent m_7975_(DamageSource p_32750_) {
        return SoundEvents.f_11921_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11920_;
    }

    protected float m_6121_() {
        return 5.0f;
    }

    public void m_7380_(CompoundTag p_32744_) {
        super.m_7380_(p_32744_);
        p_32744_.m_128344_("ExplosionPower", (byte)this.explosionPower);
    }

    public void m_7378_(CompoundTag p_32733_) {
        super.m_7378_(p_32733_);
        if (p_32733_.m_128425_("ExplosionPower", 99)) {
            this.explosionPower = p_32733_.m_128445_("ExplosionPower");
        }
    }

    protected float m_6431_(Pose p_32741_, EntityDimensions p_32742_) {
        return 2.6f;
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)UnseenWorldModEntities.GHAST_OF_TEALIVE_VALLEY.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.m_46791_() != Difficulty.PEACEFUL && Monster.m_219009_((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random) && Mob.m_217057_((EntityType)entityType, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random));
    }

    static class GhastMoveControl
    extends MoveControl {
        private final GhastOfTealiveValleyEntity ghast;
        private int floatDuration;

        public GhastMoveControl(GhastOfTealiveValleyEntity p_32768_) {
            super((Mob)p_32768_);
            this.ghast = p_32768_;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && this.floatDuration-- <= 0) {
                this.floatDuration += this.ghast.m_217043_().m_188503_(5) + 2;
                Vec3 vec3 = new Vec3(this.f_24975_ - this.ghast.m_20185_(), this.f_24976_ - this.ghast.m_20186_(), this.f_24977_ - this.ghast.m_20189_());
                double d0 = vec3.m_82553_();
                if (this.canReach(vec3 = vec3.m_82541_(), Mth.m_14165_((double)d0))) {
                    this.ghast.m_20256_(this.ghast.m_20184_().m_82549_(vec3.m_82490_(0.1)));
                } else {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                }
            }
        }

        private boolean canReach(Vec3 p_32771_, int p_32772_) {
            AABB aabb = this.ghast.m_20191_();
            for (int i = 1; i < p_32772_; ++i) {
                if (this.ghast.f_19853_.m_45756_((Entity)this.ghast, aabb = aabb.m_82383_(p_32771_))) continue;
                return false;
            }
            return true;
        }
    }

    static class RandomFloatAroundGoal
    extends Goal {
        private final GhastOfTealiveValleyEntity ghast;

        public RandomFloatAroundGoal(GhastOfTealiveValleyEntity p_32783_) {
            this.ghast = p_32783_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            double d2;
            double d1;
            MoveControl movecontrol = this.ghast.m_21566_();
            if (!movecontrol.m_24995_()) {
                return true;
            }
            double d0 = movecontrol.m_25000_() - this.ghast.m_20185_();
            double d3 = d0 * d0 + (d1 = movecontrol.m_25001_() - this.ghast.m_20186_()) * d1 + (d2 = movecontrol.m_25002_() - this.ghast.m_20189_()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            RandomSource randomsource = this.ghast.m_217043_();
            double d0 = this.ghast.m_20185_() + (double)((randomsource.m_188501_() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.ghast.m_20186_() + (double)((randomsource.m_188501_() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.ghast.m_20189_() + (double)((randomsource.m_188501_() * 2.0f - 1.0f) * 16.0f);
            this.ghast.m_21566_().m_6849_(d0, d1, d2, 1.0);
        }
    }

    static class GhastLookGoal
    extends Goal {
        private final GhastOfTealiveValleyEntity ghast;

        public GhastLookGoal(GhastOfTealiveValleyEntity p_32762_) {
            this.ghast = p_32762_;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return true;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            if (this.ghast.m_5448_() == null) {
                Vec3 vec3 = this.ghast.m_20184_();
                this.ghast.m_146922_(-((float)Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_)) * 57.295776f);
                this.ghast.f_20883_ = this.ghast.m_146908_();
            } else {
                LivingEntity livingentity = this.ghast.m_5448_();
                double d0 = 64.0;
                if (livingentity.m_20280_((Entity)this.ghast) < 4096.0) {
                    double d1 = livingentity.m_20185_() - this.ghast.m_20185_();
                    double d2 = livingentity.m_20189_() - this.ghast.m_20189_();
                    this.ghast.m_146922_(-((float)Mth.m_14136_((double)d1, (double)d2)) * 57.295776f);
                    this.ghast.f_20883_ = this.ghast.m_146908_();
                }
            }
        }
    }

    static class GhastShootFireballGoal
    extends Goal {
        private final GhastOfTealiveValleyEntity ghast;
        public int chargeTime;

        public GhastShootFireballGoal(GhastOfTealiveValleyEntity p_32776_) {
            this.ghast = p_32776_;
        }

        public boolean m_8036_() {
            return this.ghast.m_5448_() != null;
        }

        public void m_8056_() {
            this.chargeTime = 0;
        }

        public void m_8041_() {
            this.ghast.setCharging(false);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity livingentity = this.ghast.m_5448_();
            if (livingentity != null) {
                double d0 = 64.0;
                if (livingentity.m_20280_((Entity)this.ghast) < 4096.0 && this.ghast.m_142582_((Entity)livingentity)) {
                    Level level = this.ghast.f_19853_;
                    ++this.chargeTime;
                    if (this.chargeTime == 10 && !this.ghast.m_20067_()) {
                        level.m_5898_((Player)null, 1015, this.ghast.m_20183_(), 0);
                    }
                    if (this.chargeTime == 20) {
                        double d1 = 4.0;
                        Vec3 vec3 = this.ghast.m_20252_(1.0f);
                        double d2 = livingentity.m_20185_() - (this.ghast.m_20185_() + vec3.f_82479_ * 4.0);
                        double d3 = livingentity.m_20227_(0.5) - (0.5 + this.ghast.m_20227_(0.5));
                        double d4 = livingentity.m_20189_() - (this.ghast.m_20189_() + vec3.f_82481_ * 4.0);
                        if (!this.ghast.m_20067_()) {
                            level.m_5898_((Player)null, 1016, this.ghast.m_20183_(), 0);
                        }
                        LargeFireball largefireball = new LargeFireball(level, (LivingEntity)this.ghast, d2, d3, d4, this.ghast.getExplosionPower());
                        largefireball.m_6034_(this.ghast.m_20185_() + vec3.f_82479_ * 4.0, this.ghast.m_20227_(0.5) + 0.5, largefireball.m_20189_() + vec3.f_82481_ * 4.0);
                        level.m_7967_((Entity)largefireball);
                        this.chargeTime = -40;
                    }
                } else if (this.chargeTime > 0) {
                    --this.chargeTime;
                }
                this.ghast.setCharging(this.chargeTime > 10);
            }
        }
    }
}

