/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.unseenworld.procedures;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.io.InputStream;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class TheDarknessCustomSkyProcedure {
    private static final String NONE = "NONE";
    private static final String RENDER_FOG = "RENDER_FOG";
    private static final String COMPUTE_FOG_COLOR = "COMPUTE_FOG_COLOR";
    private static final String RENDER_SKY = "RENDER_SKY";
    private static final String RENDER_CLOUDS = "RENDER_CLOUDS";
    private static final String RENDER_WEATHER = "RENDER_WEATHER";
    private static final String SET_WEATHER_PARTICLES = "SET_WEATHER_PARTICLES";
    private static final String RAIN = "RAIN";
    private static final String SNOW = "SNOW";
    private static final String STORM = "STORM";
    private static final String RED = "RED";
    private static final String GREEN = "GREEN";
    private static final String BLUE = "BLUE";
    private static final String HUE = "HUE";
    private static final String SATURATION = "SATURATION";
    private static final String BRIGHTNESS = "BRIGHTNESS";
    private static final String ALPHA = "ALPHA";
    private static final String HSBA = "HSBA";
    private static final String RGBA = "RGBA";
    private static String eventType = "NONE";
    private static ViewportEvent.RenderFog fogEvent = null;
    private static ViewportEvent.ComputeFogColor fogColorEvent = null;
    private static Camera camera = null;
    private static PoseStack poseStack = null;
    private static Matrix4f projectionMatrix = null;
    private static boolean customVanillaSky = false;
    private static CloudStatus defaultCloudStatus = null;
    private static float defaultRainLevel = 0.0f;
    private static float partialTick = 0.0f;
    private static int ticks = 0;

    private static void renderVanillaElements(boolean upSkyFlag, boolean downSkyFlag, boolean starFlag, boolean sunlightFlag, boolean sunFlag, boolean moonFlag, boolean cloudFlag, boolean weatherFlag, boolean endSkyFlag) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel clientLevel = minecraft.f_91073_;
        if (clientLevel.m_104583_().m_108883_() == DimensionSpecialEffects.SkyType.END) {
            if (eventType.equals(RENDER_SKY) && endSkyFlag) {
                TheDarknessCustomSkyProcedure.renderTextureSky(null, "minecraft", "textures/environment/end_sky.png");
            }
        } else if (clientLevel.m_104583_().m_108883_() == DimensionSpecialEffects.SkyType.NORMAL) {
            if (eventType.equals(RENDER_SKY)) {
                double seaLevel;
                double eyeHeight;
                if (upSkyFlag) {
                    double skyRed = TheDarknessCustomSkyProcedure.getSkyColor(RED);
                    double skyGreen = TheDarknessCustomSkyProcedure.getSkyColor(GREEN);
                    double skyBlue = TheDarknessCustomSkyProcedure.getSkyColor(BLUE);
                    double skyAlpha = TheDarknessCustomSkyProcedure.getSkyColor(ALPHA);
                    TheDarknessCustomSkyProcedure.renderSky(Direction.UP, skyRed, skyGreen, skyBlue, skyAlpha, RGBA);
                }
                if (downSkyFlag && (eyeHeight = minecraft.f_91074_.m_20299_(partialTick).m_7098_()) < (seaLevel = clientLevel.m_6106_().m_171687_((LevelHeightAccessor)clientLevel))) {
                    TheDarknessCustomSkyProcedure.renderSky(Direction.DOWN, 0.0, 0.0, 0.0, 255.0, RGBA);
                }
                if (starFlag) {
                    double starRed = TheDarknessCustomSkyProcedure.getStarColor(RED);
                    double starGreen = TheDarknessCustomSkyProcedure.getStarColor(GREEN);
                    double starBlue = TheDarknessCustomSkyProcedure.getStarColor(BLUE);
                    double starAlpha = TheDarknessCustomSkyProcedure.getStarColor(ALPHA);
                    TheDarknessCustomSkyProcedure.renderStar(1500.0, 10842.0, starRed, starGreen, starBlue, starAlpha, RGBA);
                }
                if (sunlightFlag) {
                    double sunlightRed = TheDarknessCustomSkyProcedure.getSunlightColor(RED);
                    double sunlightGreen = TheDarknessCustomSkyProcedure.getSunlightColor(GREEN);
                    double sunlightBlue = TheDarknessCustomSkyProcedure.getSunlightColor(BLUE);
                    double sunlightAlpha = TheDarknessCustomSkyProcedure.getSunlightColor(ALPHA);
                    TheDarknessCustomSkyProcedure.renderSunlight(sunlightRed, sunlightGreen, sunlightBlue, sunlightAlpha, RGBA);
                }
                if (sunFlag || moonFlag) {
                    double dayTime = clientLevel.m_6106_().m_6792_();
                    if (sunFlag) {
                        TheDarknessCustomSkyProcedure.renderTexture("minecraft", "textures/environment/sun.png", -90.0, dayTime * -0.015, 0.0, 30.0, true);
                    }
                    if (moonFlag) {
                        TheDarknessCustomSkyProcedure.renderTexture("minecraft", "textures/environment/moon_phases.png", 90.0, dayTime * 0.015, 0.0, 20.0, true);
                    }
                }
            }
            if (eventType.equals(RENDER_CLOUDS) && cloudFlag) {
                double cloudHeight = TheDarknessCustomSkyProcedure.getCloudHeight();
                TheDarknessCustomSkyProcedure.renderClouds(cloudHeight, -1.0, 0.0, "minecraft", "textures/environment/clouds.png");
            }
            if (eventType.equals(RENDER_WEATHER) && weatherFlag) {
                TheDarknessCustomSkyProcedure.renderWeather(RAIN, "minecraft", "textures/environment/rain.png", true, false);
                TheDarknessCustomSkyProcedure.renderWeather(SNOW, "minecraft", "textures/environment/snow.png", true, false);
            }
            if (eventType.equals(SET_WEATHER_PARTICLES) && weatherFlag) {
                SimpleParticleType normal = ParticleTypes.f_123761_;
                SimpleParticleType vapor = ParticleTypes.f_123762_;
                SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("weather.rain"));
                TheDarknessCustomSkyProcedure.setWeatherParticles((ParticleOptions)normal, (ParticleOptions)vapor, sound, true, false);
            }
        }
    }

    private static void renderSky(Direction direction, double color0, double color1, double color2, double color3, String colorModel) {
        float[] skyColor;
        if (eventType.equals(RENDER_SKY) && (skyColor = TheDarknessCustomSkyProcedure.convertColor(color0, color1, color2, color3, colorModel))[3] > 0.0f) {
            VertexBuffer skyBuffer = new VertexBuffer();
            RenderSystem.m_69472_();
            RenderSystem.m_69458_((boolean)false);
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_157429_((float)skyColor[0], (float)skyColor[1], (float)skyColor[2], (float)skyColor[3]);
            RenderSystem.m_157427_(GameRenderer::m_172808_);
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            float vertex0 = -16.0f;
            float vertex1 = -512.0f;
            bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85814_);
            bufferBuilder.m_5483_(0.0, (double)vertex0, 0.0).m_5752_();
            for (int i = -180; i <= 180; i += 45) {
                bufferBuilder.m_5483_((double)vertex1 * (double)Mth.m_14089_((float)((float)i * ((float)Math.PI / 180))), 0.0, (double)(512.0f * Mth.m_14031_((float)((float)i * ((float)Math.PI / 180))))).m_5752_();
            }
            BufferBuilder.RenderedBuffer renderedBuffer = bufferBuilder.m_231175_();
            poseStack.m_85836_();
            if (direction == Direction.DOWN) {
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
            }
            if (direction == Direction.UP) {
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
            }
            if (direction == Direction.NORTH) {
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            }
            if (direction == Direction.EAST) {
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                poseStack.m_85845_(Vector3f.f_122227_.m_122240_(-90.0f));
            }
            if (direction == Direction.SOUTH) {
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                poseStack.m_85845_(Vector3f.f_122227_.m_122240_(-180.0f));
            }
            if (direction == Direction.WEST) {
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                poseStack.m_85845_(Vector3f.f_122227_.m_122240_(-270.0f));
            }
            skyBuffer.m_85921_();
            skyBuffer.m_231221_(renderedBuffer);
            skyBuffer.m_166867_(poseStack.m_85850_().m_85861_(), projectionMatrix, RenderSystem.m_157196_());
            skyBuffer.close();
            poseStack.m_85849_();
            bufferBuilder.m_85730_();
            RenderSystem.m_69461_();
            RenderSystem.m_69458_((boolean)true);
            RenderSystem.m_69493_();
        }
    }

    private static void renderTextureSky(@Nullable Direction direction, String id, String path) {
        if (eventType.equals(RENDER_SKY)) {
            Minecraft minecraft = Minecraft.m_91087_();
            if (!minecraft.f_91065_.m_93090_().m_93715_()) {
                float skyRed = 1.0f;
                float skyGreen = 1.0f;
                float skyBlue = 1.0f;
                float skyAlpha = 1.0f;
                float uv0 = 0.0f;
                float uv1 = 0.0f;
                float uv2 = 1.0f;
                float uv3 = 1.0f;
                if (id.equals("minecraft") && path.equals("textures/environment/end_sky.png")) {
                    skyRed = 0.15686275f;
                    skyGreen = 0.15686275f;
                    skyBlue = 0.15686275f;
                    skyAlpha = 1.0f;
                    uv0 = 0.0f;
                    uv1 = 0.0f;
                    uv2 = 16.0f;
                    uv3 = 16.0f;
                }
                RenderSystem.m_69458_((boolean)false);
                RenderSystem.m_69478_();
                RenderSystem.m_69453_();
                RenderSystem.m_157427_(GameRenderer::m_172820_);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation(id, path));
                BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
                bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
                if (direction == null) {
                    for (int i = 0; i < 6; ++i) {
                        poseStack.m_85836_();
                        if (i == 0) {
                            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                        }
                        if (i == 1) {
                            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
                            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                        }
                        if (i == 2) {
                            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                        }
                        if (i == 3) {
                            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(-90.0f));
                        }
                        if (i == 4) {
                            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(-180.0f));
                        }
                        if (i == 5) {
                            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(-270.0f));
                        }
                        Matrix4f rotationMatrix = poseStack.m_85850_().m_85861_();
                        bufferBuilder.m_85982_(rotationMatrix, -100.0f, -100.0f, -100.0f).m_7421_(uv0, uv1).m_85950_(skyRed, skyGreen, skyBlue, skyAlpha).m_5752_();
                        bufferBuilder.m_85982_(rotationMatrix, -100.0f, -100.0f, 100.0f).m_7421_(uv1, uv2).m_85950_(skyRed, skyGreen, skyBlue, skyAlpha).m_5752_();
                        bufferBuilder.m_85982_(rotationMatrix, 100.0f, -100.0f, 100.0f).m_7421_(uv2, uv3).m_85950_(skyRed, skyGreen, skyBlue, skyAlpha).m_5752_();
                        bufferBuilder.m_85982_(rotationMatrix, 100.0f, -100.0f, -100.0f).m_7421_(uv3, uv0).m_85950_(skyRed, skyGreen, skyBlue, skyAlpha).m_5752_();
                        poseStack.m_85849_();
                    }
                } else {
                    poseStack.m_85836_();
                    if (direction == Direction.DOWN) {
                        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                    }
                    if (direction == Direction.UP) {
                        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
                        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                    }
                    if (direction == Direction.NORTH) {
                        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                    }
                    if (direction == Direction.EAST) {
                        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(-90.0f));
                    }
                    if (direction == Direction.SOUTH) {
                        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(-180.0f));
                    }
                    if (direction == Direction.WEST) {
                        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(-270.0f));
                    }
                    Matrix4f rotationMatrix = poseStack.m_85850_().m_85861_();
                    bufferBuilder.m_85982_(rotationMatrix, -100.0f, -100.0f, -100.0f).m_7421_(uv0, uv1).m_85950_(skyRed, skyGreen, skyBlue, skyAlpha).m_5752_();
                    bufferBuilder.m_85982_(rotationMatrix, -100.0f, -100.0f, 100.0f).m_7421_(uv1, uv2).m_85950_(skyRed, skyGreen, skyBlue, skyAlpha).m_5752_();
                    bufferBuilder.m_85982_(rotationMatrix, 100.0f, -100.0f, 100.0f).m_7421_(uv2, uv3).m_85950_(skyRed, skyGreen, skyBlue, skyAlpha).m_5752_();
                    bufferBuilder.m_85982_(rotationMatrix, 100.0f, -100.0f, -100.0f).m_7421_(uv3, uv0).m_85950_(skyRed, skyGreen, skyBlue, skyAlpha).m_5752_();
                    poseStack.m_85849_();
                }
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
                bufferBuilder.m_85730_();
                RenderSystem.m_69461_();
                RenderSystem.m_69458_((boolean)true);
            }
        }
    }

    private static void renderClouds(double height, double vx0, double vz0, String id, String path) {
        if (eventType.equals(RENDER_CLOUDS)) {
            Minecraft minecraft = Minecraft.m_91087_();
            ClientLevel clientLevel = minecraft.f_91073_;
            CloudStatus cloudsType = minecraft.f_91066_.m_92174_();
            float cloudHeight = (float)height;
            int[] textureSize = TheDarknessCustomSkyProcedure.getTextureSize(id, path);
            int size = Math.min(textureSize[0], textureSize[1]);
            float[] cloudColor = new float[4];
            Vec3 colorFactor = clientLevel.m_104808_(partialTick);
            cloudColor[0] = (float)colorFactor.m_7096_();
            cloudColor[1] = (float)colorFactor.m_7098_();
            cloudColor[2] = (float)colorFactor.m_7094_();
            cloudColor[3] = id.equals("minecraft") && path.equals("textures/environment/clouds.png") ? 0.8f : 1.0f;
            if (cloudsType != CloudStatus.OFF && !Float.isNaN(cloudHeight) && size > 0 && cloudColor[3] > 0.0f) {
                Vec3 cameraPos = camera.m_90583_();
                double cameraX = cameraPos.m_7096_();
                double cameraY = cameraPos.m_7098_();
                double cameraZ = cameraPos.m_7094_();
                VertexBuffer cloudBuffer = new VertexBuffer();
                RenderSystem.m_69493_();
                RenderSystem.m_69458_((boolean)true);
                RenderSystem.m_69478_();
                RenderSystem.m_69482_();
                RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                RenderSystem.m_157427_(GameRenderer::m_172838_);
                RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation(id, path));
                RenderSystem.m_69464_();
                double vectorFactor = (double)((float)ticks + partialTick) * 0.03;
                double vx1 = (cameraX - vx0 * vectorFactor) / 12.0;
                double vy1 = (double)cloudHeight - cameraY + 0.33;
                double vz1 = (cameraZ - vz0 * vectorFactor) / 12.0 + 0.33;
                vx1 -= (double)Mth.m_14107_((double)(vx1 / 2048.0)) * 2048.0;
                vz1 -= (double)Mth.m_14107_((double)(vz1 / 2048.0)) * 2048.0;
                double vx2 = vx1 - (double)Mth.m_14107_((double)vx1);
                double vy2 = (vy1 / 4.0 - (double)Mth.m_14107_((double)(vy1 / 4.0))) * 4.0;
                double vz2 = vz1 - (double)Mth.m_14107_((double)vz1);
                float factor = 1.0f / (float)size;
                float u = (float)Mth.m_14107_((double)vx1) * factor;
                float v = (float)Mth.m_14107_((double)vz1) * factor;
                float cloudRed0 = cloudColor[0];
                float cloudGreen0 = cloudColor[1];
                float cloudBlue0 = cloudColor[2];
                float cloudAlpha0 = cloudColor[3];
                float cloudRed1 = cloudColor[0] * 0.9f;
                float cloudGreen1 = cloudColor[1] * 0.9f;
                float cloudBlue1 = cloudColor[2] * 0.9f;
                float cloudRed2 = cloudColor[0] * 0.8f;
                float cloudGreen2 = cloudColor[1] * 0.8f;
                float cloudBlue2 = cloudColor[2] * 0.8f;
                float cloudRed3 = cloudColor[0] * 0.7f;
                float cloudGreen3 = cloudColor[1] * 0.7f;
                float cloudBlue3 = cloudColor[2] * 0.7f;
                BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
                bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85822_);
                double vy3 = Math.floor(vy1 / 4.0) * 4.0;
                if (cloudsType == CloudStatus.FANCY) {
                    for (i = -3; i <= 4; ++i) {
                        for (int j = -3; j <= 4; ++j) {
                            int k;
                            double vx3 = (double)i * 8.0;
                            double vz3 = (double)j * 8.0;
                            if (vy3 > -5.0) {
                                bufferBuilder.m_5483_(vx3 + 0.0, vy3, vz3 + 8.0).m_7421_(((float)vx3 + 0.0f) * factor + u, ((float)vz3 + 8.0f) * factor + v).m_85950_(cloudRed3, cloudGreen3, cloudBlue3, cloudAlpha0).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                                bufferBuilder.m_5483_(vx3 + 8.0, vy3, vz3 + 8.0).m_7421_(((float)vx3 + 8.0f) * factor + u, ((float)vz3 + 8.0f) * factor + v).m_85950_(cloudRed3, cloudGreen3, cloudBlue3, cloudAlpha0).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                                bufferBuilder.m_5483_(vx3 + 8.0, vy3, vz3 + 0.0).m_7421_(((float)vx3 + 8.0f) * factor + u, ((float)vz3 + 0.0f) * factor + v).m_85950_(cloudRed3, cloudGreen3, cloudBlue3, cloudAlpha0).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                                bufferBuilder.m_5483_(vx3 + 0.0, vy3, vz3 + 0.0).m_7421_(((float)vx3 + 0.0f) * factor + u, ((float)vz3 + 0.0f) * factor + v).m_85950_(cloudRed3, cloudGreen3, cloudBlue3, cloudAlpha0).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                            }
                            if (vy3 <= 5.0) {
                                bufferBuilder.m_5483_(vx3 + 0.0, vy3 + 4.0 - 9.765625E-4, vz3 + 8.0).m_7421_(((float)vx3 + 0.0f) * factor + u, ((float)vz3 + 8.0f) * factor + v).m_85950_(cloudRed0, cloudGreen0, cloudBlue0, cloudAlpha0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                                bufferBuilder.m_5483_(vx3 + 8.0, vy3 + 4.0 - 9.765625E-4, vz3 + 8.0).m_7421_(((float)vx3 + 8.0f) * factor + u, ((float)vz3 + 8.0f) * factor + v).m_85950_(cloudRed0, cloudGreen0, cloudBlue0, cloudAlpha0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                                bufferBuilder.m_5483_(vx3 + 8.0, vy3 + 4.0 - 9.765625E-4, vz3 + 0.0).m_7421_(((float)vx3 + 8.0f) * factor + u, ((float)vz3 + 0.0f) * factor + v).m_85950_(cloudRed0, cloudGreen0, cloudBlue0, cloudAlpha0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                                bufferBuilder.m_5483_(vx3 + 0.0, vy3 + 4.0 - 9.765625E-4, vz3 + 0.0).m_7421_(((float)vx3 + 0.0f) * factor + u, ((float)vz3 + 0.0f) * factor + v).m_85950_(cloudRed0, cloudGreen0, cloudBlue0, cloudAlpha0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                            }
                            if (i > -1) {
                                for (k = 0; k < 8; ++k) {
                                    bufferBuilder.m_5483_(vx3 + (double)k, vy3 + 0.0, vz3 + 8.0).m_7421_(((float)vx3 + (float)k + 0.5f) * factor + u, ((float)vz3 + 8.0f) * factor + v).m_85950_(cloudRed1, cloudGreen1, cloudBlue1, cloudAlpha0).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                                    bufferBuilder.m_5483_(vx3 + (double)k, vy3 + 4.0, vz3 + 8.0).m_7421_(((float)vx3 + (float)k + 0.5f) * factor + u, ((float)vz3 + 8.0f) * factor + v).m_85950_(cloudRed1, cloudGreen1, cloudBlue1, cloudAlpha0).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                                    bufferBuilder.m_5483_(vx3 + (double)k, vy3 + 4.0, vz3 + 0.0).m_7421_(((float)vx3 + (float)k + 0.5f) * factor + u, ((float)vz3 + 0.0f) * factor + v).m_85950_(cloudRed1, cloudGreen1, cloudBlue1, cloudAlpha0).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                                    bufferBuilder.m_5483_(vx3 + (double)k, vy3 + 0.0, vz3 + 0.0).m_7421_(((float)vx3 + (float)k + 0.5f) * factor + u, ((float)vz3 + 0.0f) * factor + v).m_85950_(cloudRed1, cloudGreen1, cloudBlue1, cloudAlpha0).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                                }
                            }
                            if (i <= 1) {
                                for (k = 0; k < 8; ++k) {
                                    bufferBuilder.m_5483_(vx3 + (double)k + 1.0 - 9.765625E-4, vy3 + 0.0, vz3 + 8.0).m_7421_(((float)vx3 + (float)k + 0.5f) * factor + u, ((float)vz3 + 8.0f) * factor + v).m_85950_(cloudRed1, cloudGreen1, cloudBlue1, cloudAlpha0).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                                    bufferBuilder.m_5483_(vx3 + (double)k + 1.0 - 9.765625E-4, vy3 + 4.0, vz3 + 8.0).m_7421_(((float)vx3 + (float)k + 0.5f) * factor + u, ((float)vz3 + 8.0f) * factor + v).m_85950_(cloudRed1, cloudGreen1, cloudBlue1, cloudAlpha0).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                                    bufferBuilder.m_5483_(vx3 + (double)k + 1.0 - 9.765625E-4, vy3 + 4.0, vz3 + 0.0).m_7421_(((float)vx3 + (float)k + 0.5f) * factor + u, ((float)vz3 + 0.0f) * factor + v).m_85950_(cloudRed1, cloudGreen1, cloudBlue1, cloudAlpha0).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                                    bufferBuilder.m_5483_(vx3 + (double)k + 1.0 - 9.765625E-4, vy3 + 0.0, vz3 + 0.0).m_7421_(((float)vx3 + (float)k + 0.5f) * factor + u, ((float)vz3 + 0.0f) * factor + v).m_85950_(cloudRed1, cloudGreen1, cloudBlue1, cloudAlpha0).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                                }
                            }
                            if (j > -1) {
                                for (k = 0; k < 8; ++k) {
                                    bufferBuilder.m_5483_(vx3 + 0.0, vy3 + 4.0, vz3 + (double)k).m_7421_(((float)vx3 + 0.0f) * factor + u, ((float)vz3 + (float)k + 0.5f) * factor + v).m_85950_(cloudRed2, cloudGreen2, cloudBlue2, cloudAlpha0).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                                    bufferBuilder.m_5483_(vx3 + 8.0, vy3 + 4.0, vz3 + (double)k).m_7421_(((float)vx3 + 8.0f) * factor + u, ((float)vz3 + (float)k + 0.5f) * factor + v).m_85950_(cloudRed2, cloudGreen2, cloudBlue2, cloudAlpha0).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                                    bufferBuilder.m_5483_(vx3 + 8.0, vy3 + 0.0, vz3 + (double)k).m_7421_(((float)vx3 + 8.0f) * factor + u, ((float)vz3 + (float)k + 0.5f) * factor + v).m_85950_(cloudRed2, cloudGreen2, cloudBlue2, cloudAlpha0).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                                    bufferBuilder.m_5483_(vx3 + 0.0, vy3 + 0.0, vz3 + (double)k).m_7421_(((float)vx3 + 0.0f) * factor + u, ((float)vz3 + (float)k + 0.5f) * factor + v).m_85950_(cloudRed2, cloudGreen2, cloudBlue2, cloudAlpha0).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                                }
                            }
                            if (j > 1) continue;
                            for (k = 0; k < 8; ++k) {
                                bufferBuilder.m_5483_(vx3 + 0.0, vy3 + 4.0, vz3 + (double)k + 1.0 - 9.765625E-4).m_7421_(((float)vx3 + 0.0f) * factor + u, ((float)vz3 + (float)k + 0.5f) * factor + v).m_85950_(cloudRed2, cloudGreen2, cloudBlue2, cloudAlpha0).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                                bufferBuilder.m_5483_(vx3 + 8.0, vy3 + 4.0, vz3 + (double)k + 1.0 - 9.765625E-4).m_7421_(((float)vx3 + 8.0f) * factor + u, ((float)vz3 + (float)k + 0.5f) * factor + v).m_85950_(cloudRed2, cloudGreen2, cloudBlue2, cloudAlpha0).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                                bufferBuilder.m_5483_(vx3 + 8.0, vy3 + 0.0, vz3 + (double)k + 1.0 - 9.765625E-4).m_7421_(((float)vx3 + 8.0f) * factor + u, ((float)vz3 + (float)k + 0.5f) * factor + v).m_85950_(cloudRed2, cloudGreen2, cloudBlue2, cloudAlpha0).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                                bufferBuilder.m_5483_(vx3 + 0.0, vy3 + 0.0, vz3 + (double)k + 1.0 - 9.765625E-4).m_7421_(((float)vx3 + 0.0f) * factor + u, ((float)vz3 + (float)k + 0.5f) * factor + v).m_85950_(cloudRed2, cloudGreen2, cloudBlue2, cloudAlpha0).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                            }
                        }
                    }
                } else {
                    for (i = -32; i < 32; i += 32) {
                        for (int j = -32; j < 32; j += 32) {
                            bufferBuilder.m_5483_((double)i + 0.0, vy3, (double)j + 32.0).m_7421_(((float)i + 0.0f) * factor + u, ((float)j + 32.0f) * factor + v).m_85950_(cloudRed0, cloudGreen0, cloudBlue0, cloudAlpha0).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                            bufferBuilder.m_5483_((double)i + 32.0, vy3, (double)j + 32.0).m_7421_(((float)i + 32.0f) * factor + u, ((float)j + 32.0f) * factor + v).m_85950_(cloudRed0, cloudGreen0, cloudBlue0, cloudAlpha0).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                            bufferBuilder.m_5483_((double)i + 32.0, vy3, (double)j + 0.0).m_7421_(((float)i + 32.0f) * factor + u, ((float)j + 0.0f) * factor + v).m_85950_(cloudRed0, cloudGreen0, cloudBlue0, cloudAlpha0).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                            bufferBuilder.m_5483_((double)i + 0.0, vy3, (double)j + 0.0).m_7421_(((float)i + 0.0f) * factor + u, ((float)j + 0.0f) * factor + v).m_85950_(cloudRed0, cloudGreen0, cloudBlue0, cloudAlpha0).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                        }
                    }
                }
                BufferBuilder.RenderedBuffer renderedBuffer = bufferBuilder.m_231175_();
                cloudBuffer.m_85921_();
                cloudBuffer.m_231221_(renderedBuffer);
                FogRenderer.m_109036_();
                poseStack.m_85836_();
                poseStack.m_85841_(12.0f, 1.0f, 12.0f);
                poseStack.m_85837_(-vx2, vy2, -vz2);
                if (cloudsType == CloudStatus.FANCY) {
                    RenderSystem.m_69444_((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                    cloudBuffer.m_166867_(poseStack.m_85850_().m_85861_(), projectionMatrix, RenderSystem.m_157196_());
                    RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                    cloudBuffer.m_166867_(poseStack.m_85850_().m_85861_(), projectionMatrix, RenderSystem.m_157196_());
                } else {
                    RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                    cloudBuffer.m_166867_(poseStack.m_85850_().m_85861_(), projectionMatrix, RenderSystem.m_157196_());
                }
                cloudBuffer.close();
                poseStack.m_85849_();
                bufferBuilder.m_85730_();
                RenderSystem.m_69481_();
                RenderSystem.m_69461_();
                RenderSystem.m_69458_((boolean)false);
                RenderSystem.m_69472_();
            }
        }
    }

    private static void renderWeather(String renderType, String id, String path, boolean biomeEffect, boolean immutability) {
        if (eventType.equals(RENDER_WEATHER)) {
            Minecraft minecraft = Minecraft.m_91087_();
            ClientLevel clientLevel = minecraft.f_91073_;
            float rainLevel = clientLevel.m_46722_(partialTick);
            boolean flag0 = true;
            if (!immutability && rainLevel <= 0.0f) {
                flag0 = false;
            }
            if (flag0) {
                ClientLevel level = clientLevel;
                LightTexture lightTexture = new LightTexture(minecraft.f_91063_, minecraft);
                lightTexture.m_109896_();
                Vec3 cameraPos = camera.m_90583_();
                double camX = cameraPos.m_7096_();
                double camY = cameraPos.m_7098_();
                double camZ = cameraPos.m_7094_();
                int posX = Mth.m_14107_((double)camX);
                int posY = Mth.m_14107_((double)camY);
                int posZ = Mth.m_14107_((double)camZ);
                float[] rainSizeX = new float[1024];
                float[] rainSizeZ = new float[1024];
                int amount = 5;
                int minX = 0;
                int minZ = 0;
                int maxX = 0;
                int maxZ = 0;
                float factor = (float)ticks + partialTick;
                BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
                for (int i = 0; i < 32; ++i) {
                    for (int j = 0; j < 32; ++j) {
                        float float0 = i - 16;
                        float float1 = j - 16;
                        float sqrt = Mth.m_14116_((float)(float0 * float0 + float1 * float1));
                        rainSizeX[i << 5 | j] = float0 / sqrt;
                        rainSizeZ[i << 5 | j] = -float1 / sqrt;
                    }
                }
                if (Minecraft.m_91405_()) {
                    amount = 10;
                }
                Tesselator tesselator = Tesselator.m_85913_();
                BufferBuilder bufferBuilder = tesselator.m_85915_();
                RenderSystem.m_69493_();
                RenderSystem.m_69458_((boolean)false);
                RenderSystem.m_69482_();
                RenderSystem.m_69458_((boolean)Minecraft.m_91085_());
                RenderSystem.m_69478_();
                RenderSystem.m_69453_();
                RenderSystem.m_157427_(GameRenderer::m_172829_);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation(id, path));
                RenderSystem.m_69464_();
                minX = posX - amount;
                minZ = posZ - amount;
                maxX = posX + amount;
                maxZ = posZ + amount;
                bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
                for (int i = minX; i <= maxX; ++i) {
                    for (int j = minZ; j <= maxZ; ++j) {
                        mutableBlockPos.m_122169_((double)i, camY, (double)j);
                        Biome biome = (Biome)level.m_204166_((BlockPos)mutableBlockPos).m_203334_();
                        int index = i - posX + 16 + (j - posZ + 16) * 32;
                        double sizeX = (double)rainSizeX[index] * 0.5;
                        double sizeZ = (double)rainSizeZ[index] * 0.5;
                        int height = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, i, j);
                        int minY = posY - amount;
                        int maxY = posY + amount;
                        if (minY < height) {
                            minY = height;
                        }
                        if (maxY < height) {
                            maxY = height;
                        }
                        int blockPosY = height;
                        if (height < posY) {
                            blockPosY = posY;
                        }
                        if (minY == maxY) continue;
                        RandomSource randomSource = RandomSource.m_216335_((long)(i * i * 3121 + i * 45238971 ^ j * j * 418711 + j * 13761));
                        float speedFactor = 1.0f;
                        float weatherAlpha = 1.0f;
                        boolean flag1 = false;
                        mutableBlockPos.m_122178_(i, minY, j);
                        if (biomeEffect) {
                            if (biome.m_47530_() == Biome.Precipitation.NONE) {
                                flag1 = false;
                            } else {
                                boolean rainnable = biome.m_198906_((BlockPos)mutableBlockPos);
                                flag1 = renderType.equals(RAIN) && rainnable ? true : renderType.equals(SNOW) && !rainnable;
                            }
                        } else if (immutability) {
                            flag1 = true;
                        }
                        if (renderType.equals(STORM)) {
                            flag1 = true;
                            speedFactor = 10.0f;
                        }
                        if (!immutability && flag1) {
                            double dx = (double)i + 0.5 - camX;
                            double dz = (double)j + 0.5 - camZ;
                            float distance = (float)Math.sqrt(dx * dx + dz * dz) / (float)amount;
                            weatherAlpha = ((1.0f - distance * distance) * 0.5f + 0.5f) * rainLevel;
                        }
                        if (renderType.equals(RAIN) && flag1) {
                            int int0 = ticks + i * i * 3121 + i * 45238971 + j * j * 418711 + j * 13761 & 0x1F;
                            float float0 = -((float)int0 + partialTick) / 32.0f * (3.0f + randomSource.m_188501_());
                            mutableBlockPos.m_122178_(i, blockPosY, j);
                            int int1 = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)mutableBlockPos);
                            bufferBuilder.m_5483_((double)i - camX - sizeX + 0.5, (double)maxY - camY, (double)j - camZ - sizeZ + 0.5).m_7421_(0.0f, (float)minY * 0.25f + float0).m_85950_(1.0f, 1.0f, 1.0f, weatherAlpha).m_85969_(int1).m_5752_();
                            bufferBuilder.m_5483_((double)i - camX + sizeX + 0.5, (double)maxY - camY, (double)j - camZ + sizeZ + 0.5).m_7421_(1.0f, (float)minY * 0.25f + float0).m_85950_(1.0f, 1.0f, 1.0f, weatherAlpha).m_85969_(int1).m_5752_();
                            bufferBuilder.m_5483_((double)i - camX + sizeX + 0.5, (double)minY - camY, (double)j - camZ + sizeZ + 0.5).m_7421_(1.0f, (float)maxY * 0.25f + float0).m_85950_(1.0f, 1.0f, 1.0f, weatherAlpha).m_85969_(int1).m_5752_();
                            bufferBuilder.m_5483_((double)i - camX - sizeX + 0.5, (double)minY - camY, (double)j - camZ - sizeZ + 0.5).m_7421_(0.0f, (float)maxY * 0.25f + float0).m_85950_(1.0f, 1.0f, 1.0f, weatherAlpha).m_85969_(int1).m_5752_();
                            continue;
                        }
                        if (!renderType.equals(SNOW) && !renderType.equals(STORM) || !flag1) continue;
                        float float0 = ((float)(ticks & 0x1FF) + partialTick) / -512.0f;
                        float float1 = (float)(randomSource.m_188500_() + (double)(factor * speedFactor) * randomSource.m_188583_() * 0.01);
                        float float2 = (float)(randomSource.m_188500_() + (double)(factor * speedFactor) * randomSource.m_188583_() * 0.001);
                        mutableBlockPos.m_122178_(i, blockPosY, j);
                        int int0 = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)mutableBlockPos);
                        int int1 = int0 & 0xFFFF;
                        int int2 = int0 >> 16 & 0xFFFF;
                        int u = (int1 * 3 + 240) / 4;
                        int v = (int2 * 3 + 240) / 4;
                        bufferBuilder.m_5483_((double)i - camX - sizeX + 0.5, (double)maxY - camY, (double)j - camZ - sizeZ + 0.5).m_7421_(0.0f + float1, (float)minY * 0.25f + float0 + float2).m_85950_(1.0f, 1.0f, 1.0f, weatherAlpha).m_7120_(u, v).m_5752_();
                        bufferBuilder.m_5483_((double)i - camX + sizeX + 0.5, (double)maxY - camY, (double)j - camZ + sizeZ + 0.5).m_7421_(1.0f + float1, (float)minY * 0.25f + float0 + float2).m_85950_(1.0f, 1.0f, 1.0f, weatherAlpha).m_7120_(u, v).m_5752_();
                        bufferBuilder.m_5483_((double)i - camX + sizeX + 0.5, (double)minY - camY, (double)j - camZ + sizeZ + 0.5).m_7421_(1.0f + float1, (float)maxY * 0.25f + float0 + float2).m_85950_(1.0f, 1.0f, 1.0f, weatherAlpha).m_7120_(u, v).m_5752_();
                        bufferBuilder.m_5483_((double)i - camX - sizeX + 0.5, (double)minY - camY, (double)j - camZ - sizeZ + 0.5).m_7421_(0.0f + float1, (float)maxY * 0.25f + float0 + float2).m_85950_(1.0f, 1.0f, 1.0f, weatherAlpha).m_7120_(u, v).m_5752_();
                    }
                }
                tesselator.m_85914_();
                bufferBuilder.m_85730_();
                lightTexture.m_109891_();
                RenderSystem.m_69481_();
                RenderSystem.m_69461_();
                RenderSystem.m_69458_((boolean)true);
                RenderSystem.m_69472_();
            }
        }
    }

    private static void setWeatherParticles(ParticleOptions normal, ParticleOptions vapor, SoundEvent sound, boolean biomeEffect, boolean immutability) {
        if (eventType.equals(SET_WEATHER_PARTICLES)) {
            Minecraft minecraft = Minecraft.m_91087_();
            ClientLevel clientLevel = minecraft.f_91073_;
            float rainLevel = clientLevel.m_46722_(partialTick);
            boolean flag0 = true;
            if (!immutability && rainLevel <= 0.0f) {
                flag0 = false;
            }
            if (flag0) {
                RandomSource randomSource = RandomSource.m_216335_((long)((long)ticks * 312987231L));
                ClientLevel levelReader = clientLevel;
                BlockPos blockPos0 = new BlockPos(camera.m_90583_());
                BlockPos blockPos1 = null;
                float factor = 0.0f;
                int particleStatus = 0;
                int amount = 0;
                particleStatus = minecraft.f_91066_.m_231929_().m_231551_() == ParticleStatus.DECREASED ? 2 : 1;
                factor = immutability ? 1.0f : rainLevel * rainLevel;
                amount = (int)(100.0f * factor) / particleStatus;
                for (int i = 0; i < amount; ++i) {
                    int random0X = randomSource.m_188503_(21) - 10;
                    int random0Z = randomSource.m_188503_(21) - 10;
                    BlockPos blockPos2 = levelReader.m_5452_(Heightmap.Types.MOTION_BLOCKING, blockPos0.m_7918_(random0X, 0, random0Z));
                    Biome biome = (Biome)levelReader.m_204166_(blockPos2).m_203334_();
                    int pos0Y = blockPos0.m_123342_();
                    int pos2Y = blockPos2.m_123342_();
                    if (pos2Y <= levelReader.m_141937_() || pos2Y > pos0Y + 10 || pos2Y < pos0Y - 10) continue;
                    boolean flag1 = false;
                    flag1 = biomeEffect ? biome.m_47530_() == Biome.Precipitation.RAIN && biome.m_198906_(blockPos2) : true;
                    if (!flag1) continue;
                    blockPos1 = blockPos2.m_7495_();
                    if (minecraft.f_91066_.m_231929_().m_231551_() == ParticleStatus.MINIMAL) break;
                    double random1X = randomSource.m_188500_();
                    double random1Z = randomSource.m_188500_();
                    BlockState blockState = levelReader.m_8055_(blockPos1);
                    FluidState fluidState = levelReader.m_6425_(blockPos1);
                    VoxelShape voxelShape = blockState.m_60812_((BlockGetter)levelReader, blockPos1);
                    double double0 = voxelShape.m_83290_(Direction.Axis.Y, random1X, random1Z);
                    double double1 = fluidState.m_76155_((BlockGetter)levelReader, blockPos1);
                    double double2 = Math.max(double0, double1);
                    ParticleOptions particle = normal;
                    if (fluidState.m_205070_(FluidTags.f_13132_) || blockState.m_60713_(Blocks.f_50450_) || CampfireBlock.m_51319_((BlockState)blockState)) {
                        particle = vapor;
                    }
                    clientLevel.m_7106_(particle, (double)blockPos1.m_123341_() + random1X, (double)blockPos1.m_123342_() + double2, (double)blockPos1.m_123343_() + random1Z, 0.0, 0.0, 0.0);
                }
                if (blockPos1 != null && randomSource.m_188503_(3) == 0) {
                    float height = levelReader.m_5452_(Heightmap.Types.MOTION_BLOCKING, blockPos0).m_123342_();
                    if (blockPos1.m_123342_() > blockPos0.m_123342_() + 1 && height > (float)blockPos0.m_123342_()) {
                        if (sound == SoundEvents.f_12541_) {
                            clientLevel.m_104677_(blockPos1, SoundEvents.f_12542_, SoundSource.WEATHER, 0.1f, 0.5f, false);
                        } else {
                            clientLevel.m_104677_(blockPos1, sound, SoundSource.WEATHER, 0.1f, 0.5f, false);
                        }
                    } else {
                        clientLevel.m_104677_(blockPos1, sound, SoundSource.WEATHER, 0.2f, 1.0f, false);
                    }
                }
            }
        }
    }

    private static void renderFog(FogShape shape, double start, double end, double color0, double color1, double color2, double color3, String colorModel) {
        if (eventType.equals(RENDER_FOG)) {
            fogEvent.setFogShape(shape);
            fogEvent.setNearPlaneDistance((float)start);
            fogEvent.setFarPlaneDistance((float)end);
        }
        if (eventType.equals(COMPUTE_FOG_COLOR) || eventType.equals(RENDER_SKY)) {
            float[] fogColor = TheDarknessCustomSkyProcedure.convertColor(color0, color1, color2, color3, colorModel);
            if (eventType.equals(COMPUTE_FOG_COLOR)) {
                fogColorEvent.setRed(fogColor[0]);
                fogColorEvent.setGreen(fogColor[1]);
                fogColorEvent.setBlue(fogColor[2]);
            } else if (eventType.equals(RENDER_SKY)) {
                RenderSystem.m_157438_((float)fogColor[0], (float)fogColor[1], (float)fogColor[2], (float)fogColor[3]);
            }
        }
    }

    private static void renderSunlight(double color0, double color1, double color2, double color3, String colorModel) {
        float[] sunlightColor;
        if (eventType.equals(RENDER_SKY) && (sunlightColor = TheDarknessCustomSkyProcedure.convertColor(color0, color1, color2, color3, colorModel))[3] > 0.0f) {
            Minecraft minecraft = Minecraft.m_91087_();
            ClientLevel clientLevel = minecraft.f_91073_;
            float sunlightRed = sunlightColor[0];
            float sunlightGreen = sunlightColor[1];
            float sunlightBlue = sunlightColor[2];
            float sunlightAlpha = sunlightColor[3];
            float pitch = Mth.m_14031_((float)clientLevel.m_46490_(partialTick)) < 0.0f ? 180.0f : 0.0f;
            RenderSystem.m_69472_();
            RenderSystem.m_69458_((boolean)false);
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            poseStack.m_85836_();
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(pitch));
            Matrix4f rotationMatrix = poseStack.m_85850_().m_85861_();
            bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
            bufferBuilder.m_85982_(rotationMatrix, 0.0f, 100.0f, 0.0f).m_85950_(sunlightRed, sunlightGreen, sunlightBlue, sunlightAlpha).m_5752_();
            for (int i = 0; i <= 16; ++i) {
                float radian = (float)i * ((float)Math.PI * 2) / 16.0f;
                float sin = Mth.m_14031_((float)radian);
                float cos = Mth.m_14089_((float)radian);
                bufferBuilder.m_85982_(rotationMatrix, sin * 120.0f, cos * 120.0f, -cos * 40.0f * sunlightAlpha).m_85950_(sunlightRed, sunlightGreen, sunlightBlue, 0.0f).m_5752_();
            }
            poseStack.m_85849_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
            bufferBuilder.m_85730_();
            RenderSystem.m_69461_();
            RenderSystem.m_69458_((boolean)true);
            RenderSystem.m_69493_();
        }
    }

    private static void renderStar(double amount, double seed, double color0, double color1, double color2, double color3, String colorModel) {
        if (eventType.equals(RENDER_SKY)) {
            int starAmount = (int)amount;
            float[] starColor = TheDarknessCustomSkyProcedure.convertColor(color0, color1, color2, color3, colorModel);
            if (starAmount > 0 && starColor[3] > 0.0f) {
                VertexBuffer starBuffer = new VertexBuffer();
                Random random = new Random((long)seed);
                FogRenderer.m_109017_();
                RenderSystem.m_69472_();
                RenderSystem.m_69458_((boolean)false);
                RenderSystem.m_69478_();
                RenderSystem.m_69453_();
                RenderSystem.m_157429_((float)starColor[0], (float)starColor[1], (float)starColor[2], (float)starColor[3]);
                RenderSystem.m_157427_(GameRenderer::m_172808_);
                BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
                bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
                for (int i = 0; i < starAmount; ++i) {
                    double starZ0;
                    double starY0;
                    double starX0 = random.nextFloat() * 2.0f - 1.0f;
                    double distance = starX0 * starX0 + (starY0 = (double)(random.nextFloat() * 2.0f - 1.0f)) * starY0 + (starZ0 = (double)(random.nextFloat() * 2.0f - 1.0f)) * starZ0;
                    if (!(distance < 1.0) || !(distance > 0.01)) continue;
                    distance = 1.0 / Math.sqrt(distance);
                    double starX1 = (starX0 *= distance) * 100.0;
                    double starY1 = (starY0 *= distance) * 100.0;
                    double starZ1 = (starZ0 *= distance) * 100.0;
                    double radian0 = Math.atan2(starX0, starZ0);
                    double sin0 = Math.sin(radian0);
                    double cos0 = Math.cos(radian0);
                    double radian1 = Math.atan2(Math.sqrt(starX0 * starX0 + starZ0 * starZ0), starY0);
                    double sin1 = Math.sin(radian1);
                    double cos1 = Math.cos(radian1);
                    double radian2 = random.nextDouble() * Math.PI * 2.0;
                    double sin2 = Math.sin(radian2);
                    double cos2 = Math.cos(radian2);
                    double double0 = 0.15f + random.nextFloat() * 0.1f;
                    for (int j = 0; j < 4; ++j) {
                        double double1 = (double)((j & 2) - 1) * double0;
                        double double2 = (double)((j + 1 & 2) - 1) * double0;
                        double double3 = double1 * cos2 - double2 * sin2;
                        double double4 = double2 * cos2 + double1 * sin2;
                        double double5 = double3 * sin1;
                        double double6 = double3 * -cos1;
                        double double7 = double6 * sin0 - double4 * cos0;
                        double double8 = double4 * sin0 + double6 * cos0;
                        bufferBuilder.m_5483_(starX1 + double7, starY1 + double5, starZ1 + double8).m_5752_();
                    }
                }
                BufferBuilder.RenderedBuffer renderedBuffer = bufferBuilder.m_231175_();
                poseStack.m_85836_();
                starBuffer.m_85921_();
                starBuffer.m_231221_(renderedBuffer);
                starBuffer.m_166867_(poseStack.m_85850_().m_85861_(), projectionMatrix, GameRenderer.m_172808_());
                starBuffer.close();
                poseStack.m_85849_();
                bufferBuilder.m_85730_();
                RenderSystem.m_69461_();
                RenderSystem.m_69458_((boolean)true);
                RenderSystem.m_69493_();
            }
        }
    }

    private static void renderTexture(String id, String path, double yaw, double pitch, double roll, double size, boolean weatherEffect) {
        if (eventType.equals(RENDER_SKY)) {
            Minecraft minecraft = Minecraft.m_91087_();
            ClientLevel clientLevel = minecraft.f_91073_;
            float pos = (float)size;
            float uv0 = 1.0f;
            float uv1 = 1.0f;
            float uv2 = 0.0f;
            float uv3 = 0.0f;
            float alpha = 1.0f;
            if (weatherEffect) {
                alpha -= clientLevel.m_46722_(partialTick);
            }
            boolean isVanillaSun = false;
            boolean isVanillaMoon = false;
            if (id.equals("minecraft") && path.equals("textures/environment/sun.png")) {
                isVanillaSun = true;
            } else if (id.equals("minecraft") && path.equals("textures/environment/moon_phases.png")) {
                int phase = clientLevel.m_46941_();
                int int0 = phase % 4;
                int int1 = phase / 4 % 2;
                uv0 = (float)(int0 + 0) / 4.0f;
                uv1 = (float)(int1 + 0) / 2.0f;
                uv2 = (float)(int0 + 1) / 4.0f;
                uv3 = (float)(int1 + 1) / 2.0f;
                isVanillaMoon = true;
            }
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            if (isVanillaSun || isVanillaMoon) {
                RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            }
            RenderSystem.m_69493_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation(id, path));
            poseStack.m_85836_();
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_((float)yaw));
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_((float)pitch));
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_((float)roll));
            Matrix4f rotationMatrix = poseStack.m_85850_().m_85861_();
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferBuilder.m_85982_(rotationMatrix, -pos, 100.0f, -pos).m_7421_(uv2, uv3).m_5752_();
            bufferBuilder.m_85982_(rotationMatrix, pos, 100.0f, -pos).m_7421_(uv0, uv3).m_5752_();
            bufferBuilder.m_85982_(rotationMatrix, pos, 100.0f, pos).m_7421_(uv0, uv1).m_5752_();
            bufferBuilder.m_85982_(rotationMatrix, -pos, 100.0f, pos).m_7421_(uv2, uv1).m_5752_();
            poseStack.m_85849_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
            bufferBuilder.m_85730_();
            RenderSystem.m_69472_();
            RenderSystem.m_69461_();
        }
    }

    private static boolean isRenderable() {
        String modid = Minecraft.m_91087_().f_91073_.m_220362_().m_135782_().m_135827_();
        boolean flag = false;
        if (customVanillaSky && modid.equals("minecraft")) {
            flag = true;
        }
        if (modid.equals("unseen_world")) {
            flag = true;
        }
        return flag;
    }

    private static int[] getTextureSize(String id, String path) {
        ResourceLocation textureLocation = new ResourceLocation(id, path);
        int[] result = new int[2];
        try {
            InputStream stream = Minecraft.m_91087_().m_91098_().m_215595_(textureLocation);
            NativeImage image = NativeImage.m_85058_((InputStream)stream);
            result[0] = image.m_84982_();
            result[1] = image.m_85084_();
            image.close();
        }
        catch (Exception e) {
            result[0] = 0;
            result[1] = 0;
        }
        return result;
    }

    private static double getCloudHeight() {
        double result = 0.0;
        if (!eventType.equals(NONE) && Double.isNaN(result = (double)Minecraft.m_91087_().f_91073_.m_104583_().m_108871_())) {
            result = 0.0;
        }
        return result;
    }

    private static double getFogEndDistance() {
        double result = 0.0;
        if (!eventType.equals(NONE)) {
            result = RenderSystem.m_157199_();
        }
        return result;
    }

    private static double getFogStartDistance() {
        double result = 0.0;
        if (!eventType.equals(NONE)) {
            result = RenderSystem.m_157200_();
        }
        return result;
    }

    private static double getFogColor(String component) {
        double result = 0.0;
        if (!eventType.equals(NONE)) {
            FogRenderer.m_109036_();
            float[] fogColor = RenderSystem.m_157198_();
            if (component.equals(RED) || component.equals(GREEN) || component.equals(BLUE)) {
                if (component.equals(RED)) {
                    result = (double)fogColor[0] * 255.0;
                } else if (component.equals(GREEN)) {
                    result = (double)fogColor[1] * 255.0;
                } else if (component.equals(BLUE)) {
                    result = (double)fogColor[2] * 255.0;
                }
            } else if (component.equals(HUE) || component.equals(SATURATION) || component.equals(BRIGHTNESS)) {
                float[] resultColor = TheDarknessCustomSkyProcedure.RGBAToHSBA(fogColor[0], fogColor[1], fogColor[2], fogColor[3]);
                if (component.equals(HUE)) {
                    result = resultColor[0];
                } else if (component.equals(SATURATION)) {
                    result = resultColor[1];
                } else if (component.equals(BRIGHTNESS)) {
                    result = resultColor[2];
                }
            } else if (component.equals(ALPHA)) {
                result = 100.0;
            }
        }
        return result;
    }

    private static double getSkyColor(String component) {
        double result = 0.0;
        if (!eventType.equals(NONE)) {
            ClientLevel clientLevel = Minecraft.m_91087_().f_91073_;
            Vec3 skyColor = clientLevel.m_171660_(camera.m_90583_(), partialTick);
            if (component.equals(RED) || component.equals(GREEN) || component.equals(BLUE)) {
                if (component.equals(RED)) {
                    result = skyColor.m_7096_() * 255.0;
                } else if (component.equals(GREEN)) {
                    result = skyColor.m_7098_() * 255.0;
                } else if (component.equals(BLUE)) {
                    result = skyColor.m_7094_() * 255.0;
                }
            } else if (component.equals(HUE) || component.equals(SATURATION) || component.equals(BRIGHTNESS)) {
                float[] resultColor = TheDarknessCustomSkyProcedure.RGBAToHSBA(skyColor.m_7096_(), skyColor.m_7098_(), skyColor.m_7094_(), 1.0);
                if (component.equals(HUE)) {
                    result = resultColor[0];
                } else if (component.equals(SATURATION)) {
                    result = resultColor[1];
                } else if (component.equals(BRIGHTNESS)) {
                    result = resultColor[2];
                }
            } else if (component.equals(ALPHA)) {
                result = 100.0;
            }
        }
        return result;
    }

    private static double getStarColor(String component) {
        double result = 0.0;
        if (!eventType.equals(NONE)) {
            ClientLevel clientLevel = Minecraft.m_91087_().f_91073_;
            float rainLevel = 1.0f - clientLevel.m_46722_(partialTick);
            float starColor = clientLevel.m_104811_(partialTick) * rainLevel;
            if (component.equals(RED) || component.equals(GREEN) || component.equals(BLUE)) {
                if (component.equals(RED)) {
                    result = (double)starColor * 255.0;
                } else if (component.equals(GREEN)) {
                    result = (double)starColor * 255.0;
                } else if (component.equals(BLUE)) {
                    result = (double)starColor * 255.0;
                }
            } else if (component.equals(HUE) || component.equals(SATURATION) || component.equals(BRIGHTNESS)) {
                float[] resultColor = TheDarknessCustomSkyProcedure.RGBAToHSBA(starColor, starColor, starColor, starColor);
                if (component.equals(HUE)) {
                    result = resultColor[0];
                } else if (component.equals(SATURATION)) {
                    result = resultColor[1];
                } else if (component.equals(BRIGHTNESS)) {
                    result = resultColor[2];
                }
            } else if (component.equals(ALPHA)) {
                result = (double)starColor * 100.0;
            }
        }
        return result;
    }

    private static double getSunlightColor(String component) {
        ClientLevel clientLevel;
        float[] sunlightColor;
        double result = 0.0;
        if (!eventType.equals(NONE) && (sunlightColor = (clientLevel = Minecraft.m_91087_().f_91073_).m_104583_().m_7518_(clientLevel.m_46942_(partialTick), partialTick)) != null) {
            if (component.equals(RED) || component.equals(GREEN) || component.equals(BLUE)) {
                if (component.equals(RED)) {
                    result = (double)sunlightColor[0] * 255.0;
                } else if (component.equals(GREEN)) {
                    result = (double)sunlightColor[1] * 255.0;
                } else if (component.equals(BLUE)) {
                    result = (double)sunlightColor[2] * 255.0;
                }
            } else if (component.equals(HUE) || component.equals(SATURATION) || component.equals(BRIGHTNESS)) {
                float[] resultColor = TheDarknessCustomSkyProcedure.RGBAToHSBA(sunlightColor[0], sunlightColor[1], sunlightColor[2], sunlightColor[3]);
                if (component.equals(HUE)) {
                    result = resultColor[0];
                } else if (component.equals(SATURATION)) {
                    result = resultColor[1];
                } else if (component.equals(BRIGHTNESS)) {
                    result = resultColor[2];
                }
            } else if (component.equals(ALPHA)) {
                result = (double)sunlightColor[3] * 100.0;
            }
        }
        return result;
    }

    private static float[] convertColor(double color0, double color1, double color2, double color3, String colorModel) {
        float[] result = new float[4];
        if (colorModel.equals(RGBA)) {
            if (color0 < 0.0) {
                color0 = 0.0;
            }
            if (color0 > 255.0) {
                color0 = 255.0;
            }
            if (color1 < 0.0) {
                color1 = 0.0;
            }
            if (color1 > 255.0) {
                color1 = 255.0;
            }
            if (color2 < 0.0) {
                color2 = 0.0;
            }
            if (color2 > 255.0) {
                color2 = 255.0;
            }
            if (color3 < 0.0) {
                color3 = 0.0;
            }
            if (color3 > 100.0) {
                color3 = 100.0;
            }
            result[0] = (float)color0 / 255.0f;
            result[1] = (float)color1 / 255.0f;
            result[2] = (float)color2 / 255.0f;
            result[3] = (float)color3 / 100.0f;
        }
        if (colorModel.equals(HSBA)) {
            float[] color = TheDarknessCustomSkyProcedure.HSBAToRGBA(color0, color1, color2, color3);
            for (int i = 0; i < 4; ++i) {
                result[i] = color[i];
            }
        }
        return result;
    }

    private static float[] HSBAToRGBA(double hue, double saturation, double brightness, double alpha) {
        float float0 = 0.0f;
        float float1 = 0.0f;
        float float2 = 0.0f;
        float[] color = new float[3];
        float[] result = new float[4];
        saturation /= 100.0;
        brightness /= 100.0;
        alpha /= 100.0;
        if (hue < 0.0) {
            hue = hue % 360.0 + 360.0;
        }
        if (hue >= 360.0) {
            hue %= 360.0;
        }
        if (saturation < 0.0) {
            saturation = 0.0;
        }
        if (saturation > 1.0) {
            saturation = 1.0;
        }
        if (brightness < 0.0) {
            brightness = 0.0;
        }
        if (brightness > 1.0) {
            brightness = 1.0;
        }
        if (alpha < 0.0) {
            alpha = 0.0;
        }
        if (alpha > 1.0) {
            alpha = 1.0;
        }
        float0 = (float)(brightness * saturation);
        float1 = float0 * (1.0f - Math.abs((float)hue / 60.0f % 2.0f - 1.0f));
        float2 = (float)brightness - float0;
        if (0.0 <= hue && hue < 60.0) {
            color[0] = float0;
            color[1] = float1;
            color[2] = 0.0f;
        } else if (60.0 <= hue && hue < 120.0) {
            color[0] = float1;
            color[1] = float0;
            color[2] = 0.0f;
        } else if (120.0 <= hue && hue < 180.0) {
            color[0] = 0.0f;
            color[1] = float0;
            color[2] = float1;
        } else if (180.0 <= hue && hue < 240.0) {
            color[0] = 0.0f;
            color[1] = float1;
            color[2] = float0;
        } else if (240.0 <= hue && hue < 300.0) {
            color[0] = float1;
            color[1] = 0.0f;
            color[2] = float0;
        } else if (300.0 <= hue && hue < 360.0) {
            color[0] = float0;
            color[1] = 0.0f;
            color[2] = float1;
        }
        result[0] = color[0] + float2;
        result[1] = color[1] + float2;
        result[2] = color[2] + float2;
        result[3] = (float)alpha;
        return result;
    }

    private static float[] RGBAToHSBA(double red, double green, double blue, double alpha) {
        float max = (float)Math.max(Math.max(red, green), blue);
        float min = (float)Math.min(Math.min(red, green), blue);
        float delta = max - min;
        float[] result = new float[4];
        if (delta == 0.0f) {
            result[0] = 0.0f;
        }
        if ((double)max == red) {
            result[0] = 60.0f * ((float)(green - blue) / delta % 6.0f);
        }
        if ((double)max == green) {
            result[0] = 60.0f * ((float)(blue - red) / delta + 2.0f);
        }
        if ((double)max == blue) {
            result[0] = 60.0f * ((float)(red - green) / delta + 4.0f);
        }
        if (max == 0.0f) {
            result[1] = 0.0f;
        }
        if (max != 0.0f) {
            result[1] = delta / max * 100.0f;
        }
        result[2] = max * 100.0f;
        result[3] = (float)alpha * 100.0f;
        return result;
    }

    @SubscribeEvent
    public static void onRenderFog(ViewportEvent.RenderFog event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (TheDarknessCustomSkyProcedure.isRenderable()) {
            eventType = RENDER_FOG;
            fogEvent = event;
            camera = minecraft.f_91063_.m_109153_();
            partialTick = minecraft.m_91296_();
            event.setCanceled(true);
            TheDarknessCustomSkyProcedure.execute((Event)event, (ResourceKey<Level>)minecraft.m_91288_().f_19853_.m_46472_());
            eventType = NONE;
        } else {
            eventType = NONE;
            TheDarknessCustomSkyProcedure.execute((Event)event, (ResourceKey<Level>)minecraft.m_91288_().f_19853_.m_46472_());
        }
    }

    @SubscribeEvent
    public static void onComputeFogColor(ViewportEvent.ComputeFogColor event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (TheDarknessCustomSkyProcedure.isRenderable()) {
            eventType = COMPUTE_FOG_COLOR;
            fogColorEvent = event;
            camera = minecraft.f_91063_.m_109153_();
            partialTick = minecraft.m_91296_();
            TheDarknessCustomSkyProcedure.execute((Event)event, (ResourceKey<Level>)minecraft.m_91288_().f_19853_.m_46472_());
            eventType = NONE;
        } else {
            eventType = NONE;
            TheDarknessCustomSkyProcedure.execute((Event)event, (ResourceKey<Level>)minecraft.m_91288_().f_19853_.m_46472_());
        }
    }

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        RenderLevelStageEvent.Stage stage = event.getStage();
        if (TheDarknessCustomSkyProcedure.isRenderable()) {
            if (stage == RenderLevelStageEvent.Stage.AFTER_SKY) {
                eventType = RENDER_SKY;
                camera = event.getCamera();
                poseStack = event.getPoseStack();
                projectionMatrix = event.getProjectionMatrix();
                defaultCloudStatus = minecraft.f_91066_.m_92174_();
                partialTick = event.getPartialTick();
                RenderSystem.m_69421_((int)16640, (boolean)Minecraft.f_91002_);
                TheDarknessCustomSkyProcedure.execute((Event)event, (ResourceKey<Level>)minecraft.m_91288_().f_19853_.m_46472_());
                eventType = NONE;
            } else if (stage == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
                eventType = RENDER_CLOUDS;
                camera = event.getCamera();
                poseStack = event.getPoseStack();
                projectionMatrix = event.getProjectionMatrix();
                partialTick = event.getPartialTick();
                defaultCloudStatus = minecraft.f_91066_.m_92174_();
                defaultRainLevel = minecraft.f_91073_.m_46722_(partialTick);
                TheDarknessCustomSkyProcedure.execute((Event)event, (ResourceKey<Level>)minecraft.m_91288_().f_19853_.m_46472_());
                minecraft.f_91066_.m_232050_().m_231514_((Object)CloudStatus.OFF);
                minecraft.f_91073_.m_46734_(0.0f);
                eventType = NONE;
            } else if (stage == RenderLevelStageEvent.Stage.AFTER_WEATHER) {
                eventType = RENDER_WEATHER;
                camera = event.getCamera();
                poseStack = event.getPoseStack();
                projectionMatrix = event.getProjectionMatrix();
                partialTick = event.getPartialTick();
                minecraft.f_91066_.m_232050_().m_231514_((Object)defaultCloudStatus);
                minecraft.f_91073_.m_46734_(defaultRainLevel);
                TheDarknessCustomSkyProcedure.execute((Event)event, (ResourceKey<Level>)minecraft.m_91288_().f_19853_.m_46472_());
                eventType = NONE;
            }
        } else {
            eventType = NONE;
            TheDarknessCustomSkyProcedure.execute((Event)event, (ResourceKey<Level>)minecraft.m_91288_().f_19853_.m_46472_());
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel clientLevel = minecraft.f_91073_;
        if (clientLevel != null && !minecraft.m_91104_()) {
            TickEvent.Phase phase = event.phase;
            if (phase == TickEvent.Phase.START) {
                if (TheDarknessCustomSkyProcedure.isRenderable()) {
                    eventType = SET_WEATHER_PARTICLES;
                    camera = minecraft.f_91063_.m_109153_();
                    partialTick = minecraft.m_91296_();
                    defaultRainLevel = clientLevel.m_46722_(partialTick);
                    TheDarknessCustomSkyProcedure.execute((Event)event, (ResourceKey<Level>)minecraft.m_91288_().f_19853_.m_46472_());
                    clientLevel.m_46734_(0.0f);
                    eventType = NONE;
                }
            } else if (phase == TickEvent.Phase.END) {
                ++ticks;
                if (TheDarknessCustomSkyProcedure.isRenderable()) {
                    clientLevel.m_46734_(defaultRainLevel);
                }
            }
        }
    }

    public static void execute(ResourceKey<Level> dimension) {
        TheDarknessCustomSkyProcedure.execute(null, dimension);
    }

    private static void execute(@Nullable Event event, ResourceKey<Level> dimension) {
        if (dimension == null) {
            return;
        }
        if (dimension == ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("unseen_world:the_darkness"))) {
            TheDarknessCustomSkyProcedure.renderWeather(RAIN, "unseen_world", "textures/dark_rain.png", true, false);
            customVanillaSky = true;
            TheDarknessCustomSkyProcedure.renderVanillaElements(true, true, true, false, false, false, true, true, false);
            TheDarknessCustomSkyProcedure.renderStar(750.0, 10842.0, 15.0, 15.0, 200.0, 75.0, RGBA);
        }
    }
}

