/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.unseenworld.entity;

import java.util.EnumSet;
import net.mcreator.unseenworld.UnseenWorldModCommonConfigs;
import net.mcreator.unseenworld.init.UnseenWorldModEntities;
import net.mcreator.unseenworld.procedures.DarkGolemEntityDiesProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class DarkGolemEntity
extends Monster {
    private float hurtBack;
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState attackBlockingAnimationState = new AnimationState();
    public final AnimationState walkAnimationState = new AnimationState();
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.NOTCHED_6);

    public DarkGolemEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<DarkGolemEntity>)((EntityType)UnseenWorldModEntities.DARK_GOLEM.get()), world);
    }

    public DarkGolemEntity(EntityType<DarkGolemEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 25;
        this.m_21557_(false);
        this.m_6593_((Component)Component.m_237113_((String)"Warrior of the Chimeric Darkness"));
        this.m_20340_(true);
        this.m_21530_();
    }

    static boolean hurtAndThrowTarget(LivingEntity p_34643_, LivingEntity p_34644_) {
        float f = (float)p_34643_.m_21133_(Attributes.f_22281_);
        boolean flag = p_34644_.m_6469_(p_34643_.m_269291_().m_269333_(p_34643_), f);
        if (flag) {
            p_34643_.m_19970_(p_34643_, (Entity)p_34644_);
            DarkGolemEntity.throwTarget(p_34643_, p_34644_);
        }
        return flag;
    }

    static void throwTarget(LivingEntity p_34646_, LivingEntity p_34647_) {
        double d1;
        double d0 = p_34646_.m_21133_(Attributes.f_22282_);
        double d2 = 0.5 + d0 - (d1 = p_34647_.m_21133_(Attributes.f_22278_));
        if (!(d2 <= 0.0)) {
            double d3 = p_34647_.m_20185_() - p_34646_.m_20185_();
            double d4 = p_34647_.m_20189_() - p_34646_.m_20189_();
            float f = p_34646_.f_19853_.f_46441_.m_188503_(21) - 8;
            double d5 = d2 * (double)(p_34646_.f_19853_.f_46441_.m_188501_() * 0.75f + 0.25f);
            Vec3 vec3 = new Vec3(d3, 0.0, d4).m_82541_().m_82490_(d5).m_82524_(f);
            double d6 = d2 * (double)p_34646_.f_19853_.f_46441_.m_188501_() * 0.5;
            p_34647_.m_5997_(vec3.f_82479_, d6, vec3.f_82481_);
            p_34647_.f_19864_ = true;
        }
    }

    private boolean isMovingOnLand() {
        return this.f_19861_ && this.m_20184_().m_165925_() > 1.0E-6;
    }

    public void m_8119_() {
        if (this.f_19853_.m_5776_()) {
            if (this.isMovingOnLand()) {
                this.walkAnimationState.m_216982_(this.f_19797_);
            } else {
                this.walkAnimationState.m_216973_();
            }
        }
        super.m_8119_();
    }

    public boolean m_7327_(Entity p_34491_) {
        if (!(p_34491_ instanceof LivingEntity)) {
            return false;
        }
        this.f_19853_.m_7605_((Entity)this, (byte)4);
        this.m_5496_(SoundEvents.f_12057_, 1.0f, this.m_6100_());
        return DarkGolemEntity.hurtAndThrowTarget((LivingEntity)this, (LivingEntity)p_34491_);
    }

    public void m_7822_(byte p_219360_) {
        if (p_219360_ >= 4 && p_219360_ <= 20) {
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else {
            super.m_7822_(p_219360_);
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.5, false){

            protected double m_6639_(LivingEntity entity) {
                return (double)(this.f_25540_.m_20205_() * this.f_25540_.m_20205_() + entity.m_20205_()) + 1.0;
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new GolemLeapAtTargetGoal((Mob)this, 0.5f));
        this.f_21346_.m_25352_(6, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, true));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.elder_guardian.ambient"));
    }

    public void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.iron_golem.step")), 0.15f, 1.0f);
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.iron_golem.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.iron_golem.death"));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        this.hurtBack = Math.round(Math.random());
        if (source.m_276093_(DamageTypes.f_268585_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268565_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268493_)) {
            return false;
        }
        if (source.m_19385_().equals("witherSkull")) {
            return false;
        }
        if (source.m_7639_() instanceof Player && (double)this.hurtBack < 0.15 && amount > 6.0f) {
            this.attackBlockingAnimationState.m_216977_(this.f_19797_);
            source.m_7639_().m_6469_(new DamageSource((Holder)source.m_7639_().f_19853_.m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268515_)), amount - 6.0f);
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        DarkGolemEntityDiesProcedure.execute((LevelAccessor)this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), source.m_7639_());
    }

    public boolean m_6072_() {
        return false;
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public void m_8024_() {
        super.m_8024_();
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, ((Double)UnseenWorldModCommonConfigs.DARK_GOLEM_SPEED.get()).doubleValue());
        builder = builder.m_22268_(Attributes.f_22276_, ((Double)UnseenWorldModCommonConfigs.DARK_GOLEM_HEALTH_POINTS.get()).doubleValue());
        builder = builder.m_22268_(Attributes.f_22284_, 5.0);
        builder = builder.m_22268_(Attributes.f_22281_, ((Double)UnseenWorldModCommonConfigs.DARK_GOLEM_DAMAGE.get()).doubleValue());
        builder = builder.m_22268_(Attributes.f_22277_, 24.0);
        builder = builder.m_22268_(Attributes.f_22278_, 2.0);
        builder = builder.m_22268_(Attributes.f_22282_, 2.5);
        return builder;
    }

    class GolemLeapAtTargetGoal
    extends Goal {
        private final Mob mob;
        private LivingEntity target;
        private final float yd;

        public GolemLeapAtTargetGoal(Mob p_25492_, float p_25493_) {
            this.mob = p_25492_;
            this.yd = p_25493_;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.mob.m_20160_()) {
                return false;
            }
            this.target = this.mob.m_5448_();
            if (this.target == null) {
                return false;
            }
            double d0 = this.mob.m_20280_((Entity)this.target);
            if (!(d0 < 4.0) && !(d0 > 16.0)) {
                if (!this.mob.m_20096_()) {
                    return false;
                }
                return this.mob.m_217043_().m_188503_(GolemLeapAtTargetGoal.m_186073_((int)8)) == 0;
            }
            return false;
        }

        public boolean m_8045_() {
            return !this.mob.m_20096_();
        }

        public void m_8056_() {
            Vec3 vec3 = this.mob.m_20184_();
            Vec3 vec31 = new Vec3(this.target.m_20185_() - this.mob.m_20185_(), 0.0, this.target.m_20189_() - this.mob.m_20189_());
            if (vec31.m_82556_() > 1.0E-7) {
                vec31 = vec31.m_82541_().m_82490_(0.4).m_82549_(vec3.m_82490_(0.2));
            }
            this.mob.m_20334_(vec31.f_82479_, (double)this.yd, vec31.f_82481_);
        }
    }
}

