/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.unseenworld.entity;

import java.util.List;
import net.mcreator.unseenworld.init.UnseenWorldModEntities;
import net.mcreator.unseenworld.init.UnseenWorldModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.RiderShieldingMount;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class RedRavengerEntity
extends TamableAnimal
implements RiderShieldingMount,
Saddleable {
    private static final EntityDataAccessor<Boolean> DATA_IS_SADDLED = SynchedEntityData.m_135353_(RedRavengerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public RedRavengerEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<RedRavengerEntity>)((EntityType)UnseenWorldModEntities.RED_RAVENGER.get()), world);
    }

    public RedRavengerEntity(EntityType<RedRavengerEntity> type, Level world) {
        super(type, world);
        this.f_19793_ = 1.5f;
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_21530_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_SADDLED, (Object)false);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21346_.m_25352_(3, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 0.8));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected double m_6639_(LivingEntity entity) {
                return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() + entity.m_20205_();
            }
        });
        this.f_21346_.m_25352_(7, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new FloatGoal((Mob)this));
    }

    public MobType m_6336_() {
        return MobType.f_21643_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.ravager.ambient"));
    }

    public void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.ravager.step")), 0.15f, 1.0f);
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.ravager.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.ravager.death"));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268631_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268565_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268493_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268641_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public InteractionResult m_6071_(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.m_21120_(hand);
        InteractionResult retval = InteractionResult.m_19078_((boolean)this.f_19853_.m_5776_());
        Item item = itemstack.m_41720_();
        if (itemstack.m_41720_() instanceof SpawnEggItem) {
            retval = super.m_6071_(sourceentity, hand);
        } else if (this.f_19853_.m_5776_()) {
            retval = this.m_21824_() && this.m_21830_((LivingEntity)sourceentity) || this.m_6898_(itemstack) ? InteractionResult.m_19078_((boolean)this.f_19853_.m_5776_()) : InteractionResult.PASS;
        } else if (this.m_21824_()) {
            if (this.isSaddle(itemstack)) {
                this.setSaddled(true);
                sourceentity.m_150109_().m_36022_(p -> itemstack.m_41720_() == p.m_41720_(), 1, (Container)sourceentity.f_36095_.m_39730_());
            }
            if (this.m_20197_().size() < 2 && !this.m_6162_() && this.m_6254_()) {
                sourceentity.m_20329_((Entity)this);
            }
            if (this.m_21830_((LivingEntity)sourceentity)) {
                if (item.m_41472_() && this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                    this.m_142075_(sourceentity, hand, itemstack);
                    this.m_5634_(item.m_41473_().m_38744_());
                    retval = InteractionResult.m_19078_((boolean)this.f_19853_.m_5776_());
                } else if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                    this.m_142075_(sourceentity, hand, itemstack);
                    this.m_5634_(4.0f);
                    retval = InteractionResult.m_19078_((boolean)this.f_19853_.m_5776_());
                } else {
                    retval = super.m_6071_(sourceentity, hand);
                }
            }
        } else if (this.m_6898_(itemstack)) {
            this.m_142075_(sourceentity, hand, itemstack);
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)sourceentity)) {
                this.m_21828_(sourceentity);
                this.f_19853_.m_7605_((Entity)this, (byte)7);
            } else {
                this.f_19853_.m_7605_((Entity)this, (byte)6);
            }
            this.m_21530_();
            retval = InteractionResult.m_19078_((boolean)this.f_19853_.m_5776_());
        } else {
            retval = super.m_6071_(sourceentity, hand);
            if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                this.m_21530_();
            }
        }
        return retval;
    }

    private void clampRotation(Entity p_252070_) {
        p_252070_.m_5618_(this.m_146908_());
        float f = p_252070_.m_146908_();
        float f1 = Mth.m_14177_((float)(f - this.m_146908_()));
        float f2 = Mth.m_14036_((float)f1, (float)-160.0f, (float)160.0f);
        p_252070_.f_19859_ += f2 - f1;
        float f3 = f + f2 - f1;
        p_252070_.m_146922_(f3);
        p_252070_.m_5616_(f3);
    }

    protected boolean m_7310_(Entity p_248594_) {
        return this.m_20197_().size() <= 2;
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageable) {
        RedRavengerEntity retval = (RedRavengerEntity)((EntityType)UnseenWorldModEntities.RED_RAVENGER.get()).m_20615_((Level)serverWorld);
        retval.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(retval.m_20183_()), MobSpawnType.BREEDING, null, null);
        return retval;
    }

    protected float getSinglePassengerXOffset() {
        return 0.0f;
    }

    public void m_7332_(Entity p_38379_) {
        if (this.m_20363_(p_38379_)) {
            float f = this.getSinglePassengerXOffset();
            float f1 = (float)((this.m_213877_() ? (double)0.01f : this.m_6048_()) + p_38379_.m_6049_());
            if (this.m_20197_().size() > 1) {
                int i = this.m_20197_().indexOf(p_38379_);
                f = i == 0 ? 0.2f : -0.6f;
                if (p_38379_ instanceof Animal) {
                    f += 0.2f;
                }
            }
            Vec3 vec3 = new Vec3((double)f, 0.0, 0.0).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
            p_38379_.m_6034_(this.m_20185_() + vec3.f_82479_, this.m_20186_() + (double)f1 + 0.5, this.m_20189_() + vec3.f_82481_);
            this.clampRotation(p_38379_);
            if (p_38379_ instanceof Animal && this.m_20197_().size() == 2) {
                int j = p_38379_.m_19879_() % 2 == 0 ? 90 : 270;
                p_38379_.m_5618_(((Animal)p_38379_).f_20883_ + (float)j);
                p_38379_.m_5616_(p_38379_.m_6080_() + (float)j);
            }
        }
    }

    public boolean m_6898_(ItemStack stack) {
        return List.of((Item)UnseenWorldModItems.LUMINOUSPORKCHOP.get(), Items.f_42579_, Items.f_42658_, Items.f_42485_).contains(stack.m_41720_());
    }

    public boolean isSaddle(ItemStack stack) {
        return List.of(Items.f_42450_).contains(stack.m_41720_());
    }

    public void m_7023_(Vec3 dir) {
        Entity entity;
        Entity entity2 = entity = this.m_20197_().isEmpty() ? null : (Entity)this.m_20197_().get(0);
        if (this.m_20160_()) {
            double d0;
            double d1;
            float f1;
            this.m_146922_(entity.m_146908_());
            this.f_19859_ = this.m_146908_();
            this.m_146926_(entity.m_146909_() * 0.5f);
            this.m_19915_(this.m_146908_(), this.m_146909_());
            this.f_20883_ = entity.m_146908_();
            this.f_20885_ = entity.m_146908_();
            if (entity instanceof LivingEntity) {
                LivingEntity passenger = (LivingEntity)entity;
                this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
                float forward = passenger.f_20902_;
                float strafe = passenger.f_20900_;
                super.m_7023_(new Vec3((double)strafe, 0.0, (double)forward));
            }
            if ((f1 = (float)Math.sqrt((d1 = this.m_20185_() - this.f_19854_) * d1 + (d0 = this.m_20189_() - this.f_19856_) * d0) * 4.0f) > 1.0f) {
                f1 = 1.0f;
            }
            return;
        }
        super.m_7023_(dir);
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.15);
        builder = builder.m_22268_(Attributes.f_22276_, 36.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 5.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        builder = builder.m_22268_(Attributes.f_22278_, 1.0);
        return builder;
    }

    public double m_262813_() {
        return 0.5;
    }

    public boolean m_6741_() {
        return this.m_6084_() && !this.m_6162_();
    }

    public void m_5853_(@Nullable SoundSource p_21748_) {
        this.setSaddled(true);
        if (p_21748_ != null) {
            this.f_19853_.m_6269_((Player)null, (Entity)this, SoundEvents.f_12100_, p_21748_, 0.5f, 1.0f);
        }
    }

    public boolean m_6254_() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_SADDLED);
    }

    public void setSaddled(boolean b) {
        if (this.m_6741_()) {
            this.f_19804_.m_135381_(DATA_IS_SADDLED, (Object)b);
        }
    }
}

