/*
 * Decompiled with CFR 0.152.
 */
package net.the_forgotten_dimensions.item;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.the_forgotten_dimensions.client.model.Modelazurite_armor;
import net.the_forgotten_dimensions.procedures.AzuriteBootsTickEventProcedure;
import net.the_forgotten_dimensions.procedures.AzuriteChestplateOnTickProcedure;

public abstract class AzuriteItem
extends ArmorItem {
    public AzuriteItem(ArmorItem.Type type, Item.Properties properties) {
        super(new ArmorMaterial(){

            public int m_266425_(ArmorItem.Type type) {
                return (new int[]{13, 15, 16, 11})[type.m_266308_().m_20749_()] * 75;
            }

            public int m_7366_(ArmorItem.Type type) {
                return (new int[]{3, 5, 8, 3})[type.m_266308_().m_20749_()];
            }

            public int m_6646_() {
                return 20;
            }

            public SoundEvent m_7344_() {
                return SoundEvents.f_271165_;
            }

            public Ingredient m_6230_() {
                return Ingredient.m_151265_();
            }

            public String m_6082_() {
                return "azurite";
            }

            public float m_6651_() {
                return 2.25f;
            }

            public float m_6649_() {
                return 0.05f;
            }
        }, type, properties);
    }

    public static class Boots
    extends AzuriteItem {
        public Boots() {
            super(ArmorItem.Type.BOOTS, new Item.Properties());
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                @OnlyIn(value=Dist.CLIENT)
                public HumanoidModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                    HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("left_leg", new Modelazurite_armor<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelazurite_armor.LAYER_LOCATION)).LeftBoot, "right_leg", new Modelazurite_armor<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelazurite_armor.LAYER_LOCATION)).RightBoot, "head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "body", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                    armorModel.f_102817_ = living.m_6144_();
                    armorModel.f_102609_ = defaultModel.f_102609_;
                    armorModel.f_102610_ = living.m_6162_();
                    return armorModel;
                }
            });
        }

        public void m_7373_(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.m_7373_(itemstack, level, list, flag);
            list.add((Component)Component.m_237113_((String)"\u00a7b- Ice -"));
            list.add((Component)Component.m_237113_((String)"\u00a7b\ud83d\udee1 + 1.3"));
            list.add((Component)Component.m_237113_((String)"\u00a74\ud83d\udee1 + 0.325"));
            list.add((Component)Component.m_237113_((String)"\u00a76\ud83d\udee1 + 0.45"));
            list.add((Component)Component.m_237113_((String)"\u00a72\ud83d\udee1 + 0.85"));
            list.add((Component)Component.m_237113_((String)"\u00a79\ud83d\udee1 + 1.1"));
            list.add((Component)Component.m_237113_((String)"\u00a7b\u2694 + 5%"));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "the_forgotten_dimensions:textures/entities/azurite_armor.png";
        }

        public void m_6883_(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
            Player player;
            super.m_6883_(itemstack, world, entity, slot, selected);
            if (entity instanceof Player && Iterables.contains((Iterable)(player = (Player)entity).m_6168_(), (Object)itemstack)) {
                AzuriteBootsTickEventProcedure.execute((LevelAccessor)world, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), entity);
            }
        }
    }

    public static class Leggings
    extends AzuriteItem {
        public Leggings() {
            super(ArmorItem.Type.LEGGINGS, new Item.Properties());
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                @OnlyIn(value=Dist.CLIENT)
                public HumanoidModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                    HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("left_leg", new Modelazurite_armor<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelazurite_armor.LAYER_LOCATION)).LeftLeg, "right_leg", new Modelazurite_armor<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelazurite_armor.LAYER_LOCATION)).RightLeg, "head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "body", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                    armorModel.f_102817_ = living.m_6144_();
                    armorModel.f_102609_ = defaultModel.f_102609_;
                    armorModel.f_102610_ = living.m_6162_();
                    return armorModel;
                }
            });
        }

        public void m_7373_(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.m_7373_(itemstack, level, list, flag);
            list.add((Component)Component.m_237113_((String)"\u00a7b- Ice -"));
            list.add((Component)Component.m_237113_((String)"\u00a7b\ud83d\udee1 + 2.3"));
            list.add((Component)Component.m_237113_((String)"\u00a74\ud83d\udee1 + 0.575"));
            list.add((Component)Component.m_237113_((String)"\u00a76\ud83d\udee1 + 0.75"));
            list.add((Component)Component.m_237113_((String)"\u00a72\ud83d\udee1 + 1.5"));
            list.add((Component)Component.m_237113_((String)"\u00a79\ud83d\udee1 + 1.85"));
            list.add((Component)Component.m_237113_((String)"\u00a7b\u2694 + 5%"));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "the_forgotten_dimensions:textures/entities/azurite_armor.png";
        }
    }

    public static class Chestplate
    extends AzuriteItem {
        public Chestplate() {
            super(ArmorItem.Type.CHESTPLATE, new Item.Properties());
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                @OnlyIn(value=Dist.CLIENT)
                public HumanoidModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                    HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("body", new Modelazurite_armor<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelazurite_armor.LAYER_LOCATION)).Body, "left_arm", new Modelazurite_armor<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelazurite_armor.LAYER_LOCATION)).LeftArm, "right_arm", new Modelazurite_armor<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelazurite_armor.LAYER_LOCATION)).RightArm, "head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                    armorModel.f_102817_ = living.m_6144_();
                    armorModel.f_102609_ = defaultModel.f_102609_;
                    armorModel.f_102610_ = living.m_6162_();
                    return armorModel;
                }
            });
        }

        public void m_7373_(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.m_7373_(itemstack, level, list, flag);
            list.add((Component)Component.m_237113_((String)"\u00a7b- Ice -"));
            list.add((Component)Component.m_237113_((String)"\u00a7b\ud83d\udee1 + 2.9"));
            list.add((Component)Component.m_237113_((String)"\u00a74\ud83d\udee1 + 0.725"));
            list.add((Component)Component.m_237113_((String)"\u00a76\ud83d\udee1 + 1"));
            list.add((Component)Component.m_237113_((String)"\u00a72\ud83d\udee1 + 1.75"));
            list.add((Component)Component.m_237113_((String)"\u00a79\ud83d\udee1 + 2"));
            list.add((Component)Component.m_237113_((String)"\u00a7b\u2694 + 5%"));
            list.add((Component)Component.m_237113_((String)"full set:"));
            list.add((Component)Component.m_237113_((String)"\u00a77every 3rd attack increases \u00a7b\u2694 + 20%"));
            list.add((Component)Component.m_237113_((String)"\u00a77sending the enemy flying back"));
            list.add((Component)Component.m_237113_((String)"\u00a78Projectiles count as an attack"));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "the_forgotten_dimensions:textures/entities/azurite_armor.png";
        }

        public void m_6883_(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
            Player player;
            super.m_6883_(itemstack, world, entity, slot, selected);
            if (entity instanceof Player && Iterables.contains((Iterable)(player = (Player)entity).m_6168_(), (Object)itemstack)) {
                AzuriteChestplateOnTickProcedure.execute(entity);
            }
        }
    }

    public static class Helmet
    extends AzuriteItem {
        public Helmet() {
            super(ArmorItem.Type.HELMET, new Item.Properties());
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                public HumanoidModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                    HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("head", new Modelazurite_armor<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelazurite_armor.LAYER_LOCATION)).Head, "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "body", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                    armorModel.f_102817_ = living.m_6144_();
                    armorModel.f_102609_ = defaultModel.f_102609_;
                    armorModel.f_102610_ = living.m_6162_();
                    return armorModel;
                }
            });
        }

        public void m_7373_(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.m_7373_(itemstack, level, list, flag);
            list.add((Component)Component.m_237113_((String)"\u00a7b- Ice -"));
            list.add((Component)Component.m_237113_((String)"\u00a7b\ud83d\udee1 + 1.5"));
            list.add((Component)Component.m_237113_((String)"\u00a74\ud83d\udee1 + 0.375"));
            list.add((Component)Component.m_237113_((String)"\u00a76\ud83d\udee1 + 0.5"));
            list.add((Component)Component.m_237113_((String)"\u00a72\ud83d\udee1 + 1"));
            list.add((Component)Component.m_237113_((String)"\u00a79\ud83d\udee1 + 1.25"));
            list.add((Component)Component.m_237113_((String)"\u00a7b\u2694 + 5%"));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "the_forgotten_dimensions:textures/entities/azurite_armor.png";
        }
    }
}

