/*
 * Decompiled with CFR 0.152.
 */
package net.the_forgotten_dimensions.item;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.the_forgotten_dimensions.client.model.ModelSkyliteBlueArmor;

public abstract class HeavySkyliteArmorItem
extends ArmorItem {
    public HeavySkyliteArmorItem(ArmorItem.Type type, Item.Properties properties) {
        super(new ArmorMaterial(){

            public int m_266425_(ArmorItem.Type type) {
                return (new int[]{13, 15, 16, 11})[type.m_266308_().m_20749_()] * 18;
            }

            public int m_7366_(ArmorItem.Type type) {
                return (new int[]{3, 6, 7, 3})[type.m_266308_().m_20749_()];
            }

            public int m_6646_() {
                return 9;
            }

            public SoundEvent m_7344_() {
                return SoundEvents.f_271165_;
            }

            public Ingredient m_6230_() {
                return Ingredient.m_151265_();
            }

            public String m_6082_() {
                return "heavy_skylite_armor";
            }

            public float m_6651_() {
                return 1.0f;
            }

            public float m_6649_() {
                return 0.0f;
            }
        }, type, properties);
    }

    public static class Boots
    extends HeavySkyliteArmorItem {
        public Boots() {
            super(ArmorItem.Type.BOOTS, new Item.Properties());
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                @OnlyIn(value=Dist.CLIENT)
                public HumanoidModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                    HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("left_leg", new ModelSkyliteBlueArmor<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)ModelSkyliteBlueArmor.LAYER_LOCATION)).left_boot, "right_leg", new ModelSkyliteBlueArmor<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)ModelSkyliteBlueArmor.LAYER_LOCATION)).right_boot, "head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "body", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                    armorModel.f_102817_ = living.m_6144_();
                    armorModel.f_102609_ = defaultModel.f_102609_;
                    armorModel.f_102610_ = living.m_6162_();
                    return armorModel;
                }
            });
        }

        public void m_7373_(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.m_7373_(itemstack, level, list, flag);
            list.add((Component)Component.m_237113_((String)"\u00a76- Electrical -"));
            list.add((Component)Component.m_237113_((String)"\u00a7b\ud83d\udee1 + 0.6"));
            list.add((Component)Component.m_237113_((String)"\u00a74\ud83d\udee1 + 0.75"));
            list.add((Component)Component.m_237113_((String)"\u00a76\ud83d\udee1 + 0.85"));
            list.add((Component)Component.m_237113_((String)"\u00a72\ud83d\udee1 + 0.5"));
            list.add((Component)Component.m_237113_((String)"\u00a79\ud83d\udee1 + 0.35"));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "the_forgotten_dimensions:textures/entities/blue_skylite_armor.png";
        }
    }

    public static class Leggings
    extends HeavySkyliteArmorItem {
        public Leggings() {
            super(ArmorItem.Type.LEGGINGS, new Item.Properties());
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                @OnlyIn(value=Dist.CLIENT)
                public HumanoidModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                    HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("left_leg", new ModelSkyliteBlueArmor<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)ModelSkyliteBlueArmor.LAYER_LOCATION)).LeftLegging, "right_leg", new ModelSkyliteBlueArmor<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)ModelSkyliteBlueArmor.LAYER_LOCATION)).RightLegging, "head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "body", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                    armorModel.f_102817_ = living.m_6144_();
                    armorModel.f_102609_ = defaultModel.f_102609_;
                    armorModel.f_102610_ = living.m_6162_();
                    return armorModel;
                }
            });
        }

        public void m_7373_(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.m_7373_(itemstack, level, list, flag);
            list.add((Component)Component.m_237113_((String)"\u00a76- Electrical -"));
            list.add((Component)Component.m_237113_((String)"\u00a7b\ud83d\udee1 + 1.15"));
            list.add((Component)Component.m_237113_((String)"\u00a74\ud83d\udee1 + 1.35"));
            list.add((Component)Component.m_237113_((String)"\u00a76\ud83d\udee1 + 1.5"));
            list.add((Component)Component.m_237113_((String)"\u00a72\ud83d\udee1 + 0.95"));
            list.add((Component)Component.m_237113_((String)"\u00a79\ud83d\udee1 + 0.75"));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "the_forgotten_dimensions:textures/entities/blue_skylite_armor.png";
        }
    }

    public static class Chestplate
    extends HeavySkyliteArmorItem {
        public Chestplate() {
            super(ArmorItem.Type.CHESTPLATE, new Item.Properties());
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                @OnlyIn(value=Dist.CLIENT)
                public HumanoidModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                    HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("body", new ModelSkyliteBlueArmor<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)ModelSkyliteBlueArmor.LAYER_LOCATION)).Chesplate, "left_arm", new ModelSkyliteBlueArmor<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)ModelSkyliteBlueArmor.LAYER_LOCATION)).LeftArm, "right_arm", new ModelSkyliteBlueArmor<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)ModelSkyliteBlueArmor.LAYER_LOCATION)).RightArm, "head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                    armorModel.f_102817_ = living.m_6144_();
                    armorModel.f_102609_ = defaultModel.f_102609_;
                    armorModel.f_102610_ = living.m_6162_();
                    return armorModel;
                }
            });
        }

        public void m_7373_(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.m_7373_(itemstack, level, list, flag);
            list.add((Component)Component.m_237113_((String)"\u00a76- Electrical -"));
            list.add((Component)Component.m_237113_((String)"\u00a7b\ud83d\udee1 + 1.35"));
            list.add((Component)Component.m_237113_((String)"\u00a74\ud83d\udee1 + 1.5"));
            list.add((Component)Component.m_237113_((String)"\u00a76\ud83d\udee1 + 1.75"));
            list.add((Component)Component.m_237113_((String)"\u00a72\ud83d\udee1 + 1.15"));
            list.add((Component)Component.m_237113_((String)"\u00a79\ud83d\udee1 + 0.95"));
            list.add((Component)Component.m_237113_((String)"\u00a75Full set:"));
            list.add((Component)Component.m_237113_((String)"\u00a77Attackers takes \u00a761 \u2694"));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "the_forgotten_dimensions:textures/entities/blue_skylite_armor.png";
        }
    }

    public static class Helmet
    extends HeavySkyliteArmorItem {
        public Helmet() {
            super(ArmorItem.Type.HELMET, new Item.Properties());
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                public HumanoidModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                    HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("head", new ModelSkyliteBlueArmor<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)ModelSkyliteBlueArmor.LAYER_LOCATION)).Helmet, "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "body", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                    armorModel.f_102817_ = living.m_6144_();
                    armorModel.f_102609_ = defaultModel.f_102609_;
                    armorModel.f_102610_ = living.m_6162_();
                    return armorModel;
                }
            });
        }

        public void m_7373_(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.m_7373_(itemstack, level, list, flag);
            list.add((Component)Component.m_237113_((String)"\u00a76- Electrical -"));
            list.add((Component)Component.m_237113_((String)"\u00a7b\ud83d\udee1 + 1"));
            list.add((Component)Component.m_237113_((String)"\u00a74\ud83d\udee1 + 1.15"));
            list.add((Component)Component.m_237113_((String)"\u00a76\ud83d\udee1 + 1.25"));
            list.add((Component)Component.m_237113_((String)"\u00a72\ud83d\udee1 + 0.85"));
            list.add((Component)Component.m_237113_((String)"\u00a79\ud83d\udee1 + 0.5"));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "the_forgotten_dimensions:textures/entities/blue_skylite_armor.png";
        }
    }
}

