/*
 * Decompiled with CFR 0.152.
 */
package net.the_forgotten_dimensions.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.the_forgotten_dimensions.TheForgottenDimensionsMod;
import net.the_forgotten_dimensions.procedures.Question0AnswerProcedure;
import net.the_forgotten_dimensions.procedures.Question1AnswerProcedure;
import net.the_forgotten_dimensions.procedures.Question2AnswerProcedure;
import net.the_forgotten_dimensions.procedures.Question3AnswerProcedure;
import net.the_forgotten_dimensions.procedures.Question4AnswerProcedure;
import net.the_forgotten_dimensions.procedures.Question5AnswerProcedure;
import net.the_forgotten_dimensions.world.inventory.CommunicationChatMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CommunicationChatButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public CommunicationChatButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public CommunicationChatButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(CommunicationChatButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(CommunicationChatButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            CommunicationChatButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = CommunicationChatMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            Question0AnswerProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            Question1AnswerProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            Question2AnswerProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            Question3AnswerProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            Question4AnswerProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            Question5AnswerProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        TheForgottenDimensionsMod.addNetworkMessage(CommunicationChatButtonMessage.class, CommunicationChatButtonMessage::buffer, CommunicationChatButtonMessage::new, CommunicationChatButtonMessage::handler);
    }
}

