/*
 * Decompiled with CFR 0.152.
 */
package net.the_forgotten_dimensions.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.the_forgotten_dimensions.TheForgottenDimensionsMod;
import net.the_forgotten_dimensions.procedures.DimensionHubOpenProcedure;
import net.the_forgotten_dimensions.procedures.ElementsOpenProcedure;
import net.the_forgotten_dimensions.procedures.GuideOpenHubProcedure;
import net.the_forgotten_dimensions.procedures.PermafrostBosses00OpenProcedure;
import net.the_forgotten_dimensions.procedures.PermafrostHubOpenProcedure;
import net.the_forgotten_dimensions.procedures.PermafrostInfo0OpenProcedure;
import net.the_forgotten_dimensions.procedures.PermafrostInfo1OpenProcedure;
import net.the_forgotten_dimensions.procedures.PermafrostInfo2OpenProcedure;
import net.the_forgotten_dimensions.procedures.PermafrostInfo3OpenProcedure;
import net.the_forgotten_dimensions.procedures.PermafrostProgression0OpenProcedure;
import net.the_forgotten_dimensions.procedures.Stats0OpenProcedure;
import net.the_forgotten_dimensions.world.inventory.PermafrostInfo3Menu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class PermafrostInfo3ButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public PermafrostInfo3ButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public PermafrostInfo3ButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(PermafrostInfo3ButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(PermafrostInfo3ButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            PermafrostInfo3ButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = PermafrostInfo3Menu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            GuideOpenHubProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            PermafrostInfo2OpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            PermafrostHubOpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            DimensionHubOpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            ElementsOpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 5) {
            DimensionHubOpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 6) {
            PermafrostInfo0OpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 7) {
            PermafrostInfo1OpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 8) {
            PermafrostInfo2OpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 9) {
            PermafrostInfo3OpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 10) {
            PermafrostHubOpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 11) {
            PermafrostProgression0OpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 12) {
            PermafrostBosses00OpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 13) {
            Stats0OpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        TheForgottenDimensionsMod.addNetworkMessage(PermafrostInfo3ButtonMessage.class, PermafrostInfo3ButtonMessage::buffer, PermafrostInfo3ButtonMessage::new, PermafrostInfo3ButtonMessage::handler);
    }
}

