/*
 * Decompiled with CFR 0.152.
 */
package net.the_forgotten_dimensions.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.the_forgotten_dimensions.TheForgottenDimensionsMod;
import net.the_forgotten_dimensions.procedures.DimensionHubOpenProcedure;
import net.the_forgotten_dimensions.procedures.ElementsOpenProcedure;
import net.the_forgotten_dimensions.procedures.GuideOpenHubProcedure;
import net.the_forgotten_dimensions.procedures.PermafrostBosses00OpenProcedure;
import net.the_forgotten_dimensions.procedures.PermafrostHubOpenProcedure;
import net.the_forgotten_dimensions.procedures.PermafrostInfo0OpenProcedure;
import net.the_forgotten_dimensions.procedures.PermafrostProgression0OpenProcedure;
import net.the_forgotten_dimensions.procedures.PermafrostProgression1OpenProcedure;
import net.the_forgotten_dimensions.procedures.PermafrostProgression2OpenProcedure;
import net.the_forgotten_dimensions.procedures.PermafrostProgression3OpenProcedure;
import net.the_forgotten_dimensions.procedures.PermafrostProgression4OpenProcedure;
import net.the_forgotten_dimensions.procedures.Stats0OpenProcedure;
import net.the_forgotten_dimensions.world.inventory.PermafrostProgression4Menu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class PermafrostProgression4ButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public PermafrostProgression4ButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public PermafrostProgression4ButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(PermafrostProgression4ButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(PermafrostProgression4ButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            PermafrostProgression4ButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = PermafrostProgression4Menu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            GuideOpenHubProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            PermafrostProgression3OpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            PermafrostHubOpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            DimensionHubOpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            ElementsOpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 5) {
            DimensionHubOpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 6) {
            PermafrostHubOpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 7) {
            PermafrostInfo0OpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 8) {
            PermafrostProgression0OpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 9) {
            PermafrostProgression1OpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 10) {
            PermafrostProgression2OpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 11) {
            PermafrostProgression3OpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 12) {
            PermafrostProgression4OpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 13) {
            PermafrostProgression0OpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 14) {
            PermafrostBosses00OpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 15) {
            Stats0OpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        TheForgottenDimensionsMod.addNetworkMessage(PermafrostProgression4ButtonMessage.class, PermafrostProgression4ButtonMessage::buffer, PermafrostProgression4ButtonMessage::new, PermafrostProgression4ButtonMessage::handler);
    }
}

