/*
 * Decompiled with CFR 0.152.
 */
package net.the_forgotten_dimensions.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.the_forgotten_dimensions.TheForgottenDimensionsMod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TheForgottenDimensionsModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        TheForgottenDimensionsMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        TheForgottenDimensionsMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.amethyst_spear_range = message.data.amethyst_spear_range;
                    variables.avariel_necklace = message.data.avariel_necklace;
                    variables.BlessingAnimation = message.data.BlessingAnimation;
                    variables.FroslogRanceReach = message.data.FroslogRanceReach;
                    variables.LightSkyriumSpeed = message.data.LightSkyriumSpeed;
                    variables.Frost = message.data.Frost;
                    variables.Frost_Temperature = message.data.Frost_Temperature;
                    variables.PigmySlayCount = message.data.PigmySlayCount;
                    variables.TeleportTempo = message.data.TeleportTempo;
                    variables.YTeleport = message.data.YTeleport;
                    variables.AvarielDefeated = message.data.AvarielDefeated;
                    variables.frozen_hearth = message.data.frozen_hearth;
                    variables.PermaFrost = message.data.PermaFrost;
                    variables.PermafrostGuide = message.data.PermafrostGuide;
                    variables.PhoenixFirstSummon = message.data.PhoenixFirstSummon;
                    variables.TFDMusicLock = message.data.TFDMusicLock;
                    variables.TFDMusicReplace = message.data.TFDMusicReplace;
                    variables.Max_Frost = message.data.Max_Frost;
                    variables.TFDMusicTime = message.data.TFDMusicTime;
                    variables.TFDMusicWait = message.data.TFDMusicWait;
                    variables.Xteleport = message.data.Xteleport;
                    variables.Zteleport = message.data.Zteleport;
                    variables.Blessing = message.data.Blessing;
                    variables.TFDMusic = message.data.TFDMusic;
                    variables.PigmyQuest = message.data.PigmyQuest;
                    variables.ZacarielDefeated = message.data.ZacarielDefeated;
                    variables.emerald_spear = message.data.emerald_spear;
                    variables.RangeTrueIceSpear = message.data.RangeTrueIceSpear;
                    variables.PigmyGolem = message.data.PigmyGolem;
                    variables.PigmyBeast = message.data.PigmyBeast;
                    variables.PigmyAvariel = message.data.PigmyAvariel;
                    variables.OverworldChampionNecklace = message.data.OverworldChampionNecklace;
                    variables.Dialogue = message.data.Dialogue;
                    variables.Communication = message.data.Communication;
                    variables.Him = message.data.Him;
                    variables.DialoguePoint = message.data.DialoguePoint;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public boolean amethyst_spear_range = false;
        public boolean avariel_necklace = false;
        public boolean BlessingAnimation = false;
        public boolean FroslogRanceReach = false;
        public boolean LightSkyriumSpeed = false;
        public double Frost = 1500.0;
        public double Frost_Temperature = 0.0;
        public double PigmySlayCount = 0.0;
        public double TeleportTempo = 0.0;
        public double YTeleport = 0.0;
        public boolean AvarielDefeated = false;
        public boolean frozen_hearth = false;
        public boolean PermaFrost = false;
        public boolean PermafrostGuide = false;
        public boolean PhoenixFirstSummon = false;
        public boolean TFDMusicLock = false;
        public boolean TFDMusicReplace = false;
        public double Max_Frost = 1500.0;
        public double TFDMusicTime = 0.0;
        public double TFDMusicWait = 0.0;
        public double Xteleport = 0.0;
        public double Zteleport = 0.0;
        public String Blessing = "Empty";
        public String TFDMusic = "\"\"";
        public boolean PigmyQuest = false;
        public boolean ZacarielDefeated = false;
        public boolean emerald_spear = false;
        public boolean RangeTrueIceSpear = false;
        public boolean PigmyGolem = false;
        public boolean PigmyBeast = false;
        public boolean PigmyAvariel = false;
        public boolean OverworldChampionNecklace = false;
        public String Dialogue = "\"\"";
        public String Communication = "\"\"";
        public String Him = "";
        public double DialoguePoint = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                TheForgottenDimensionsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("amethyst_spear_range", this.amethyst_spear_range);
            nbt.m_128379_("avariel_necklace", this.avariel_necklace);
            nbt.m_128379_("BlessingAnimation", this.BlessingAnimation);
            nbt.m_128379_("FroslogRanceReach", this.FroslogRanceReach);
            nbt.m_128379_("LightSkyriumSpeed", this.LightSkyriumSpeed);
            nbt.m_128347_("Frost", this.Frost);
            nbt.m_128347_("Frost_Temperature", this.Frost_Temperature);
            nbt.m_128347_("PigmySlayCount", this.PigmySlayCount);
            nbt.m_128347_("TeleportTempo", this.TeleportTempo);
            nbt.m_128347_("YTeleport", this.YTeleport);
            nbt.m_128379_("AvarielDefeated", this.AvarielDefeated);
            nbt.m_128379_("frozen_hearth", this.frozen_hearth);
            nbt.m_128379_("PermaFrost", this.PermaFrost);
            nbt.m_128379_("PermafrostGuide", this.PermafrostGuide);
            nbt.m_128379_("PhoenixFirstSummon", this.PhoenixFirstSummon);
            nbt.m_128379_("TFDMusicLock", this.TFDMusicLock);
            nbt.m_128379_("TFDMusicReplace", this.TFDMusicReplace);
            nbt.m_128347_("Max_Frost", this.Max_Frost);
            nbt.m_128347_("TFDMusicTime", this.TFDMusicTime);
            nbt.m_128347_("TFDMusicWait", this.TFDMusicWait);
            nbt.m_128347_("Xteleport", this.Xteleport);
            nbt.m_128347_("Zteleport", this.Zteleport);
            nbt.m_128359_("Blessing", this.Blessing);
            nbt.m_128359_("TFDMusic", this.TFDMusic);
            nbt.m_128379_("PigmyQuest", this.PigmyQuest);
            nbt.m_128379_("ZacarielDefeated", this.ZacarielDefeated);
            nbt.m_128379_("emerald_spear", this.emerald_spear);
            nbt.m_128379_("RangeTrueIceSpear", this.RangeTrueIceSpear);
            nbt.m_128379_("PigmyGolem", this.PigmyGolem);
            nbt.m_128379_("PigmyBeast", this.PigmyBeast);
            nbt.m_128379_("PigmyAvariel", this.PigmyAvariel);
            nbt.m_128379_("OverworldChampionNecklace", this.OverworldChampionNecklace);
            nbt.m_128359_("Dialogue", this.Dialogue);
            nbt.m_128359_("Communication", this.Communication);
            nbt.m_128359_("Him", this.Him);
            nbt.m_128347_("DialoguePoint", this.DialoguePoint);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.amethyst_spear_range = nbt.m_128471_("amethyst_spear_range");
            this.avariel_necklace = nbt.m_128471_("avariel_necklace");
            this.BlessingAnimation = nbt.m_128471_("BlessingAnimation");
            this.FroslogRanceReach = nbt.m_128471_("FroslogRanceReach");
            this.LightSkyriumSpeed = nbt.m_128471_("LightSkyriumSpeed");
            this.Frost = nbt.m_128459_("Frost");
            this.Frost_Temperature = nbt.m_128459_("Frost_Temperature");
            this.PigmySlayCount = nbt.m_128459_("PigmySlayCount");
            this.TeleportTempo = nbt.m_128459_("TeleportTempo");
            this.YTeleport = nbt.m_128459_("YTeleport");
            this.AvarielDefeated = nbt.m_128471_("AvarielDefeated");
            this.frozen_hearth = nbt.m_128471_("frozen_hearth");
            this.PermaFrost = nbt.m_128471_("PermaFrost");
            this.PermafrostGuide = nbt.m_128471_("PermafrostGuide");
            this.PhoenixFirstSummon = nbt.m_128471_("PhoenixFirstSummon");
            this.TFDMusicLock = nbt.m_128471_("TFDMusicLock");
            this.TFDMusicReplace = nbt.m_128471_("TFDMusicReplace");
            this.Max_Frost = nbt.m_128459_("Max_Frost");
            this.TFDMusicTime = nbt.m_128459_("TFDMusicTime");
            this.TFDMusicWait = nbt.m_128459_("TFDMusicWait");
            this.Xteleport = nbt.m_128459_("Xteleport");
            this.Zteleport = nbt.m_128459_("Zteleport");
            this.Blessing = nbt.m_128461_("Blessing");
            this.TFDMusic = nbt.m_128461_("TFDMusic");
            this.PigmyQuest = nbt.m_128471_("PigmyQuest");
            this.ZacarielDefeated = nbt.m_128471_("ZacarielDefeated");
            this.emerald_spear = nbt.m_128471_("emerald_spear");
            this.RangeTrueIceSpear = nbt.m_128471_("RangeTrueIceSpear");
            this.PigmyGolem = nbt.m_128471_("PigmyGolem");
            this.PigmyBeast = nbt.m_128471_("PigmyBeast");
            this.PigmyAvariel = nbt.m_128471_("PigmyAvariel");
            this.OverworldChampionNecklace = nbt.m_128471_("OverworldChampionNecklace");
            this.Dialogue = nbt.m_128461_("Dialogue");
            this.Communication = nbt.m_128461_("Communication");
            this.Him = nbt.m_128461_("Him");
            this.DialoguePoint = nbt.m_128459_("DialoguePoint");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("the_forgotten_dimensions", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "the_forgotten_dimensions_mapvars";
        public boolean DebugMode = false;
        public boolean ice_phoenix_brutally_defeated = false;
        public boolean ice_phoenix_defeated = false;
        public boolean Permafrost_temples = false;
        public double blizzard_max_time = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.DebugMode = nbt.m_128471_("DebugMode");
            this.ice_phoenix_brutally_defeated = nbt.m_128471_("ice_phoenix_brutally_defeated");
            this.ice_phoenix_defeated = nbt.m_128471_("ice_phoenix_defeated");
            this.Permafrost_temples = nbt.m_128471_("Permafrost_temples");
            this.blizzard_max_time = nbt.m_128459_("blizzard_max_time");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("DebugMode", this.DebugMode);
            nbt.m_128379_("ice_phoenix_brutally_defeated", this.ice_phoenix_brutally_defeated);
            nbt.m_128379_("ice_phoenix_defeated", this.ice_phoenix_defeated);
            nbt.m_128379_("Permafrost_temples", this.Permafrost_temples);
            nbt.m_128347_("blizzard_max_time", this.blizzard_max_time);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                TheForgottenDimensionsMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "the_forgotten_dimensions_worldvars";
        public boolean Perma_Frost_Snowing = false;
        public boolean SkyriumPortalGenerated = false;
        public boolean SlayerOfThepIgmyGodSlayer = false;
        public double blizzard_max_strength = 0.0;
        public double blizzard_Start = 0.0;
        public double blizzard_strength = 0.0;
        public double blizzard_time = 0.0;
        public double PermafrostPrisionY = 64.0;
        public double SkyriumPortalY = 0.0;
        public double blizzard_start_max = 0.0;
        public double blizzard_wind = 0.0;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.Perma_Frost_Snowing = nbt.m_128471_("Perma_Frost_Snowing");
            this.SkyriumPortalGenerated = nbt.m_128471_("SkyriumPortalGenerated");
            this.SlayerOfThepIgmyGodSlayer = nbt.m_128471_("SlayerOfThepIgmyGodSlayer");
            this.blizzard_max_strength = nbt.m_128459_("blizzard_max_strength");
            this.blizzard_Start = nbt.m_128459_("blizzard_Start");
            this.blizzard_strength = nbt.m_128459_("blizzard_strength");
            this.blizzard_time = nbt.m_128459_("blizzard_time");
            this.PermafrostPrisionY = nbt.m_128459_("PermafrostPrisionY");
            this.SkyriumPortalY = nbt.m_128459_("SkyriumPortalY");
            this.blizzard_start_max = nbt.m_128459_("blizzard_start_max");
            this.blizzard_wind = nbt.m_128459_("blizzard_wind");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("Perma_Frost_Snowing", this.Perma_Frost_Snowing);
            nbt.m_128379_("SkyriumPortalGenerated", this.SkyriumPortalGenerated);
            nbt.m_128379_("SlayerOfThepIgmyGodSlayer", this.SlayerOfThepIgmyGodSlayer);
            nbt.m_128347_("blizzard_max_strength", this.blizzard_max_strength);
            nbt.m_128347_("blizzard_Start", this.blizzard_Start);
            nbt.m_128347_("blizzard_strength", this.blizzard_strength);
            nbt.m_128347_("blizzard_time", this.blizzard_time);
            nbt.m_128347_("PermafrostPrisionY", this.PermafrostPrisionY);
            nbt.m_128347_("SkyriumPortalY", this.SkyriumPortalY);
            nbt.m_128347_("blizzard_start_max", this.blizzard_start_max);
            nbt.m_128347_("blizzard_wind", this.blizzard_wind);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                TheForgottenDimensionsMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.AvarielDefeated = original.AvarielDefeated;
            clone.frozen_hearth = original.frozen_hearth;
            clone.PermaFrost = original.PermaFrost;
            clone.PermafrostGuide = original.PermafrostGuide;
            clone.PhoenixFirstSummon = original.PhoenixFirstSummon;
            clone.TFDMusicLock = original.TFDMusicLock;
            clone.TFDMusicReplace = original.TFDMusicReplace;
            clone.Max_Frost = original.Max_Frost;
            clone.TFDMusicTime = original.TFDMusicTime;
            clone.TFDMusicWait = original.TFDMusicWait;
            clone.Xteleport = original.Xteleport;
            clone.Zteleport = original.Zteleport;
            clone.Blessing = original.Blessing;
            clone.TFDMusic = original.TFDMusic;
            clone.PigmyQuest = original.PigmyQuest;
            clone.ZacarielDefeated = original.ZacarielDefeated;
            clone.PigmyGolem = original.PigmyGolem;
            clone.PigmyBeast = original.PigmyBeast;
            clone.PigmyAvariel = original.PigmyAvariel;
            clone.Him = original.Him;
            if (!event.isWasDeath()) {
                clone.amethyst_spear_range = original.amethyst_spear_range;
                clone.avariel_necklace = original.avariel_necklace;
                clone.BlessingAnimation = original.BlessingAnimation;
                clone.FroslogRanceReach = original.FroslogRanceReach;
                clone.LightSkyriumSpeed = original.LightSkyriumSpeed;
                clone.Frost = original.Frost;
                clone.Frost_Temperature = original.Frost_Temperature;
                clone.PigmySlayCount = original.PigmySlayCount;
                clone.TeleportTempo = original.TeleportTempo;
                clone.YTeleport = original.YTeleport;
                clone.emerald_spear = original.emerald_spear;
                clone.RangeTrueIceSpear = original.RangeTrueIceSpear;
                clone.OverworldChampionNecklace = original.OverworldChampionNecklace;
                clone.Dialogue = original.Dialogue;
                clone.Communication = original.Communication;
                clone.DialoguePoint = original.DialoguePoint;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    TheForgottenDimensionsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    TheForgottenDimensionsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                TheForgottenDimensionsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

