/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.harryshostileexpansion.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.mcreator.harryshostileexpansion.world.features.GraveyardFeature;
import net.mcreator.harryshostileexpansion.world.features.NinjaArenaFeature;
import net.mcreator.harryshostileexpansion.world.features.UFOFeature;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber
public class HarrysHostileExpansionModFeatures {
    public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"harrys_hostile_expansion");
    private static final List<FeatureRegistration> FEATURE_REGISTRATIONS = new ArrayList<FeatureRegistration>();
    public static final RegistryObject<Feature<?>> GRAVEYARD = HarrysHostileExpansionModFeatures.register("graveyard", GraveyardFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, GraveyardFeature.GENERATE_BIOMES, GraveyardFeature::placedFeature));
    public static final RegistryObject<Feature<?>> UFO = HarrysHostileExpansionModFeatures.register("ufo", UFOFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, UFOFeature.GENERATE_BIOMES, UFOFeature::placedFeature));
    public static final RegistryObject<Feature<?>> NINJA_ARENA = HarrysHostileExpansionModFeatures.register("ninja_arena", NinjaArenaFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, NinjaArenaFeature.GENERATE_BIOMES, NinjaArenaFeature::placedFeature));

    private static RegistryObject<Feature<?>> register(String registryname, Supplier<Feature<?>> feature, FeatureRegistration featureRegistration) {
        FEATURE_REGISTRATIONS.add(featureRegistration);
        return REGISTRY.register(registryname, feature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        for (FeatureRegistration registration : FEATURE_REGISTRATIONS) {
            if (registration.biomes() != null && !registration.biomes().contains(event.getName())) continue;
            event.getGeneration().getFeatures(registration.stage()).add(registration.placedFeature().get());
        }
    }

    private record FeatureRegistration(GenerationStep.Decoration stage, Set<ResourceLocation> biomes, Supplier<Holder<PlacedFeature>> placedFeature) {
    }
}

