/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.xenocraft.init;

import net.mcreator.xenocraft.entity.ChestBursterEntity;
import net.mcreator.xenocraft.entity.FacehuggerEntity;
import net.mcreator.xenocraft.entity.PredatorEntity;
import net.mcreator.xenocraft.entity.XenomorphRunnerEntity;
import net.mcreator.xenocraft.entity.XenomorphWarriorEntity;
import net.mcreator.xenocraft.entity.XenomorpheDroneEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class XenocraftModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"xenocraft");
    public static final RegistryObject<EntityType<XenomorphWarriorEntity>> XENOMORPH_WARRIOR = XenocraftModEntities.register("xenomorph_warrior", EntityType.Builder.m_20704_(XenomorphWarriorEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(XenomorphWarriorEntity::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<XenomorpheDroneEntity>> XENOMORPHE_DRONE = XenocraftModEntities.register("xenomorphe_drone", EntityType.Builder.m_20704_(XenomorpheDroneEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(XenomorpheDroneEntity::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<XenomorphRunnerEntity>> XENOMORPH_RUNNER = XenocraftModEntities.register("xenomorph_runner", EntityType.Builder.m_20704_(XenomorphRunnerEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(XenomorphRunnerEntity::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<PredatorEntity>> PREDATOR = XenocraftModEntities.register("predator", EntityType.Builder.m_20704_(PredatorEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(PredatorEntity::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<FacehuggerEntity>> FACEHUGGER = XenocraftModEntities.register("facehugger", EntityType.Builder.m_20704_(FacehuggerEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(FacehuggerEntity::new).m_20699_(1.4f, 0.9f));
    public static final RegistryObject<EntityType<ChestBursterEntity>> CHEST_BURSTER = XenocraftModEntities.register("chest_burster", EntityType.Builder.m_20704_(ChestBursterEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(ChestBursterEntity::new).m_20699_(0.4f, 0.3f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            XenomorphWarriorEntity.init();
            XenomorpheDroneEntity.init();
            XenomorphRunnerEntity.init();
            PredatorEntity.init();
            FacehuggerEntity.init();
            ChestBursterEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)XENOMORPH_WARRIOR.get(), XenomorphWarriorEntity.createAttributes().m_22265_());
        event.put((EntityType)XENOMORPHE_DRONE.get(), XenomorpheDroneEntity.createAttributes().m_22265_());
        event.put((EntityType)XENOMORPH_RUNNER.get(), XenomorphRunnerEntity.createAttributes().m_22265_());
        event.put((EntityType)PREDATOR.get(), PredatorEntity.createAttributes().m_22265_());
        event.put((EntityType)FACEHUGGER.get(), FacehuggerEntity.createAttributes().m_22265_());
        event.put((EntityType)CHEST_BURSTER.get(), ChestBursterEntity.createAttributes().m_22265_());
    }
}

