/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.netherupdateplus.init;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Map;
import net.mcreator.netherupdateplus.init.NetherUpdatePlusModBlocks;
import net.mcreator.netherupdateplus.world.biome.BlazeNetherWastesBiome;
import net.mcreator.netherupdateplus.world.biome.CrimsonPlainsBiome;
import net.mcreator.netherupdateplus.world.biome.FrozenNetherWastesBiome;
import net.mcreator.netherupdateplus.world.biome.GravelLandBiome;
import net.mcreator.netherupdateplus.world.biome.LushNetherBiome;
import net.mcreator.netherupdateplus.world.biome.MossyNetherWastesBiome;
import net.mcreator.netherupdateplus.world.biome.NetherDesertBiome;
import net.mcreator.netherupdateplus.world.biome.NetherGrassLandBiome;
import net.mcreator.netherupdateplus.world.biome.NetherWastelandBiome;
import net.mcreator.netherupdateplus.world.biome.ShadowNetherWastesBiome;
import net.mcreator.netherupdateplus.world.biome.SoulStoneVallyBiome;
import net.mcreator.netherupdateplus.world.biome.TaintedNetherWastesBiome;
import net.mcreator.netherupdateplus.world.biome.UndeadNetherWastesBiome;
import net.mcreator.netherupdateplus.world.biome.WarpedPlainsBiome;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class NetherUpdatePlusModBiomes {
    public static final DeferredRegister<Biome> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)"nether_update_plus");
    public static final RegistryObject<Biome> SOUL_STONE_VALLY = REGISTRY.register("soul_stone_vally", () -> SoulStoneVallyBiome.createBiome());
    public static final RegistryObject<Biome> NETHER_WASTELAND = REGISTRY.register("nether_wasteland", () -> NetherWastelandBiome.createBiome());
    public static final RegistryObject<Biome> NETHER_DESERT = REGISTRY.register("nether_desert", () -> NetherDesertBiome.createBiome());
    public static final RegistryObject<Biome> FROZEN_NETHER_WASTES = REGISTRY.register("frozen_nether_wastes", () -> FrozenNetherWastesBiome.createBiome());
    public static final RegistryObject<Biome> LUSH_NETHER = REGISTRY.register("lush_nether", () -> LushNetherBiome.createBiome());
    public static final RegistryObject<Biome> UNDEAD_NETHER_WASTES = REGISTRY.register("undead_nether_wastes", () -> UndeadNetherWastesBiome.createBiome());
    public static final RegistryObject<Biome> SHADOW_NETHER_WASTES = REGISTRY.register("shadow_nether_wastes", () -> ShadowNetherWastesBiome.createBiome());
    public static final RegistryObject<Biome> BLAZE_NETHER_WASTES = REGISTRY.register("blaze_nether_wastes", () -> BlazeNetherWastesBiome.createBiome());
    public static final RegistryObject<Biome> GRAVEL_LAND = REGISTRY.register("gravel_land", () -> GravelLandBiome.createBiome());
    public static final RegistryObject<Biome> WARPED_PLAINS = REGISTRY.register("warped_plains", () -> WarpedPlainsBiome.createBiome());
    public static final RegistryObject<Biome> CRIMSON_PLAINS = REGISTRY.register("crimson_plains", () -> CrimsonPlainsBiome.createBiome());
    public static final RegistryObject<Biome> TAINTED_NETHER_WASTES = REGISTRY.register("tainted_nether_wastes", () -> TaintedNetherWastesBiome.createBiome());
    public static final RegistryObject<Biome> MOSSY_NETHER_WASTES = REGISTRY.register("mossy_nether_wastes", () -> MossyNetherWastesBiome.createBiome());
    public static final RegistryObject<Biome> NETHER_GRASS_LAND = REGISTRY.register("nether_grass_land", () -> NetherGrassLandBiome.createBiome());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            SoulStoneVallyBiome.init();
            NetherWastelandBiome.init();
            NetherDesertBiome.init();
            FrozenNetherWastesBiome.init();
            LushNetherBiome.init();
            UndeadNetherWastesBiome.init();
            ShadowNetherWastesBiome.init();
            BlazeNetherWastesBiome.init();
            GravelLandBiome.init();
            WarpedPlainsBiome.init();
            CrimsonPlainsBiome.init();
            TaintedNetherWastesBiome.init();
            MossyNetherWastesBiome.init();
            NetherGrassLandBiome.init();
        });
    }

    @Mod.EventBusSubscriber
    public static class BiomeInjector {
        @SubscribeEvent
        public static void onServerAboutToStart(ServerAboutToStartEvent event) {
            MinecraftServer server = event.getServer();
            Registry dimensionTypeRegistry = server.m_206579_().m_175515_(Registry.f_122818_);
            Registry biomeRegistry = server.m_206579_().m_175515_(Registry.f_122885_);
            WorldGenSettings worldGenSettings = server.m_129910_().m_5961_();
            for (Map.Entry entry : worldGenSettings.m_204655_().m_6579_()) {
                DimensionType dimensionType = (DimensionType)((LevelStem)entry.getValue()).m_204521_().m_203334_();
                if (dimensionType != dimensionTypeRegistry.m_123013_(DimensionType.f_63846_)) continue;
                ChunkGenerator chunkGenerator = ((LevelStem)entry.getValue()).m_63990_();
                BiomeSource biomeSource = chunkGenerator.m_62218_();
                if (biomeSource instanceof MultiNoiseBiomeSource) {
                    MultiNoiseBiomeSource noiseSource = (MultiNoiseBiomeSource)biomeSource;
                    ArrayList<Pair> parameters = new ArrayList<Pair>(noiseSource.f_48435_.m_186850_());
                    parameters.add(new Pair((Object)SoulStoneVallyBiome.PARAMETER_POINT, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)SOUL_STONE_VALLY.getId()))));
                    parameters.add(new Pair((Object)NetherWastelandBiome.PARAMETER_POINT, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)NETHER_WASTELAND.getId()))));
                    parameters.add(new Pair((Object)NetherDesertBiome.PARAMETER_POINT, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)NETHER_DESERT.getId()))));
                    parameters.add(new Pair((Object)FrozenNetherWastesBiome.PARAMETER_POINT, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)FROZEN_NETHER_WASTES.getId()))));
                    parameters.add(new Pair((Object)LushNetherBiome.PARAMETER_POINT, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)LUSH_NETHER.getId()))));
                    parameters.add(new Pair((Object)UndeadNetherWastesBiome.PARAMETER_POINT, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)UNDEAD_NETHER_WASTES.getId()))));
                    parameters.add(new Pair((Object)ShadowNetherWastesBiome.PARAMETER_POINT, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)SHADOW_NETHER_WASTES.getId()))));
                    parameters.add(new Pair((Object)BlazeNetherWastesBiome.PARAMETER_POINT, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)BLAZE_NETHER_WASTES.getId()))));
                    parameters.add(new Pair((Object)GravelLandBiome.PARAMETER_POINT, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)GRAVEL_LAND.getId()))));
                    parameters.add(new Pair((Object)WarpedPlainsBiome.PARAMETER_POINT, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)WARPED_PLAINS.getId()))));
                    parameters.add(new Pair((Object)CrimsonPlainsBiome.PARAMETER_POINT, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)CRIMSON_PLAINS.getId()))));
                    parameters.add(new Pair((Object)TaintedNetherWastesBiome.PARAMETER_POINT, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)TAINTED_NETHER_WASTES.getId()))));
                    parameters.add(new Pair((Object)MossyNetherWastesBiome.PARAMETER_POINT, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)MOSSY_NETHER_WASTES.getId()))));
                    parameters.add(new Pair((Object)NetherGrassLandBiome.PARAMETER_POINT, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)NETHER_GRASS_LAND.getId()))));
                    MultiNoiseBiomeSource moddedNoiseSource = new MultiNoiseBiomeSource(new Climate.ParameterList(parameters), noiseSource.f_48438_);
                    chunkGenerator.f_62137_ = moddedNoiseSource;
                    chunkGenerator.f_62138_ = moddedNoiseSource;
                }
                if (!(chunkGenerator instanceof NoiseBasedChunkGenerator)) continue;
                NoiseBasedChunkGenerator noiseGenerator = (NoiseBasedChunkGenerator)chunkGenerator;
                NoiseGeneratorSettings noiseGeneratorSettings = (NoiseGeneratorSettings)noiseGenerator.f_64318_.m_203334_();
                SurfaceRules.RuleSource currentRuleSource = noiseGeneratorSettings.f_188871_();
                if (!(currentRuleSource instanceof SurfaceRules.SequenceRuleSource)) continue;
                SurfaceRules.SequenceRuleSource sequenceRuleSource = (SurfaceRules.SequenceRuleSource)currentRuleSource;
                ArrayList<SurfaceRules.RuleSource> surfaceRules = new ArrayList<SurfaceRules.RuleSource>(sequenceRuleSource.f_189697_());
                surfaceRules.add(2, BiomeInjector.anySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)SOUL_STONE_VALLY.getId()), ((Block)NetherUpdatePlusModBlocks.SOUL_STONE.get()).m_49966_(), ((Block)NetherUpdatePlusModBlocks.SOUL_STONE.get()).m_49966_(), ((Block)NetherUpdatePlusModBlocks.SOUL_STONE.get()).m_49966_()));
                surfaceRules.add(2, BiomeInjector.anySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)NETHER_WASTELAND.getId()), ((Block)NetherUpdatePlusModBlocks.NETHER_DIRT.get()).m_49966_(), ((Block)NetherUpdatePlusModBlocks.NETHER_DIRT.get()).m_49966_(), ((Block)NetherUpdatePlusModBlocks.NETHER_DIRT.get()).m_49966_()));
                surfaceRules.add(2, BiomeInjector.anySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)NETHER_DESERT.getId()), ((Block)NetherUpdatePlusModBlocks.NETHER_SAND.get()).m_49966_(), ((Block)NetherUpdatePlusModBlocks.NETHER_SAND.get()).m_49966_(), ((Block)NetherUpdatePlusModBlocks.NETHER_SAND.get()).m_49966_()));
                surfaceRules.add(2, BiomeInjector.anySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)FROZEN_NETHER_WASTES.getId()), ((Block)NetherUpdatePlusModBlocks.FROZEN_NETHERRACK.get()).m_49966_(), ((Block)NetherUpdatePlusModBlocks.FROZEN_NETHERRACK.get()).m_49966_(), ((Block)NetherUpdatePlusModBlocks.FROZEN_NETHERRACK.get()).m_49966_()));
                surfaceRules.add(2, BiomeInjector.anySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)LUSH_NETHER.getId()), Blocks.f_152544_.m_49966_(), Blocks.f_152544_.m_49966_(), Blocks.f_152544_.m_49966_()));
                surfaceRules.add(2, BiomeInjector.anySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)UNDEAD_NETHER_WASTES.getId()), ((Block)NetherUpdatePlusModBlocks.UNDEAD_NETHERRACK.get()).m_49966_(), ((Block)NetherUpdatePlusModBlocks.UNDEAD_NETHERRACK.get()).m_49966_(), ((Block)NetherUpdatePlusModBlocks.UNDEAD_NETHERRACK.get()).m_49966_()));
                surfaceRules.add(2, BiomeInjector.anySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)SHADOW_NETHER_WASTES.getId()), ((Block)NetherUpdatePlusModBlocks.SHADOW_NETHERRACK.get()).m_49966_(), ((Block)NetherUpdatePlusModBlocks.SHADOW_NETHERRACK.get()).m_49966_(), ((Block)NetherUpdatePlusModBlocks.SHADOW_NETHERRACK.get()).m_49966_()));
                surfaceRules.add(2, BiomeInjector.anySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)BLAZE_NETHER_WASTES.getId()), ((Block)NetherUpdatePlusModBlocks.BLAZE_NETHERRACK.get()).m_49966_(), ((Block)NetherUpdatePlusModBlocks.BLAZE_NETHERRACK.get()).m_49966_(), ((Block)NetherUpdatePlusModBlocks.BLAZE_NETHERRACK.get()).m_49966_()));
                surfaceRules.add(2, BiomeInjector.anySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)GRAVEL_LAND.getId()), Blocks.f_49994_.m_49966_(), Blocks.f_49994_.m_49966_(), Blocks.f_49994_.m_49966_()));
                surfaceRules.add(2, BiomeInjector.anySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)WARPED_PLAINS.getId()), Blocks.f_50690_.m_49966_(), Blocks.f_50134_.m_49966_(), Blocks.f_50134_.m_49966_()));
                surfaceRules.add(2, BiomeInjector.anySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)CRIMSON_PLAINS.getId()), Blocks.f_50699_.m_49966_(), Blocks.f_50134_.m_49966_(), Blocks.f_50134_.m_49966_()));
                surfaceRules.add(2, BiomeInjector.anySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)TAINTED_NETHER_WASTES.getId()), ((Block)NetherUpdatePlusModBlocks.TAINTED_NETHERRACK.get()).m_49966_(), ((Block)NetherUpdatePlusModBlocks.TAINTED_NETHERRACK.get()).m_49966_(), ((Block)NetherUpdatePlusModBlocks.TAINTED_NETHERRACK.get()).m_49966_()));
                surfaceRules.add(2, BiomeInjector.anySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)MOSSY_NETHER_WASTES.getId()), ((Block)NetherUpdatePlusModBlocks.MOSSY_NETHERRACK.get()).m_49966_(), ((Block)NetherUpdatePlusModBlocks.MOSSY_NETHERRACK.get()).m_49966_(), ((Block)NetherUpdatePlusModBlocks.MOSSY_NETHERRACK.get()).m_49966_()));
                surfaceRules.add(2, BiomeInjector.anySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)NETHER_GRASS_LAND.getId()), ((Block)NetherUpdatePlusModBlocks.NETHER_GRASS_BLOCK.get()).m_49966_(), Blocks.f_50134_.m_49966_(), ((Block)NetherUpdatePlusModBlocks.NETHER_GRASS_BLOCK.get()).m_49966_()));
                NoiseGeneratorSettings moddedNoiseGeneratorSettings = new NoiseGeneratorSettings(noiseGeneratorSettings.f_64439_(), noiseGeneratorSettings.f_64440_(), noiseGeneratorSettings.f_64441_(), noiseGeneratorSettings.f_209353_(), SurfaceRules.m_198272_((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])surfaceRules.toArray(SurfaceRules.RuleSource[]::new))), noiseGeneratorSettings.f_64444_(), noiseGeneratorSettings.f_64445_(), noiseGeneratorSettings.f_158533_(), noiseGeneratorSettings.m_209369_(), noiseGeneratorSettings.f_209354_());
                noiseGenerator.f_64318_ = new Holder.Direct((Object)moddedNoiseGeneratorSettings);
            }
        }

        private static SurfaceRules.RuleSource anySurfaceRule(ResourceKey<Biome> biomeKey, BlockState groundBlock, BlockState undergroundBlock, BlockState underwaterBlock) {
            return SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{biomeKey}), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)false, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189382_((int)-1, (int)0), (SurfaceRules.RuleSource)SurfaceRules.m_189390_((BlockState)groundBlock)), SurfaceRules.m_189390_((BlockState)underwaterBlock)})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)true, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.m_189390_((BlockState)undergroundBlock))}));
        }
    }
}

