/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.littlefireflies.entity;

import java.util.Random;
import java.util.Set;
import net.mcreator.littlefireflies.init.LittleFirefliesModBlocks;
import net.mcreator.littlefireflies.init.LittleFirefliesModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class FirefliesEntity
extends PathfinderMob {
    private static final Set<ResourceLocation> SPAWN_BIOMES = Set.of(new ResourceLocation("swamp"));

    @SubscribeEvent
    public static void addLivingEntityToBiomes(BiomeLoadingEvent event) {
        if (SPAWN_BIOMES.contains(event.getName())) {
            event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)LittleFirefliesModEntities.FIREFLIES.get(), 100, 600, 800));
        }
    }

    public FirefliesEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<FirefliesEntity>)((EntityType)LittleFirefliesModEntities.FIREFLIES.get()), world);
    }

    public FirefliesEntity(EntityType<FirefliesEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, true);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected PathNavigation m_6037_(Level world) {
        return new FlyingPathNavigation((Mob)this, world);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new RandomStrollGoal(this, 0.8, 20){

            protected Vec3 m_7037_() {
                Random random = FirefliesEntity.this.m_21187_();
                double dir_x = FirefliesEntity.this.m_20185_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_y = FirefliesEntity.this.m_20186_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_z = FirefliesEntity.this.m_20189_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                return new Vec3(dir_x, dir_y, dir_z);
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.5f));
        this.f_21345_.m_25352_(5, (Goal)new TemptGoal((PathfinderMob)this, 2.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{((Block)LittleFirefliesModBlocks.LUMINESCENCE.get()).m_5456_()}), false));
        this.f_21345_.m_25352_(6, (Goal)new TemptGoal((PathfinderMob)this, 2.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{((Block)LittleFirefliesModBlocks.LUMINESCENCE_BLOCK.get()).m_5456_()}), false));
        this.f_21345_.m_25352_(7, (Goal)new TemptGoal((PathfinderMob)this, 2.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50081_.m_5456_()}), false));
        this.f_21345_.m_25352_(8, (Goal)new TemptGoal((PathfinderMob)this, 2.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50139_.m_5456_()}), false));
        this.f_21345_.m_25352_(9, (Goal)new TemptGoal((PathfinderMob)this, 2.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50681_.m_5456_()}), false));
        this.f_21345_.m_25352_(10, (Goal)new TemptGoal((PathfinderMob)this, 2.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50682_.m_5456_()}), false));
        this.f_21345_.m_25352_(11, (Goal)new TemptGoal((PathfinderMob)this, 2.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50141_.m_5456_()}), false));
        this.f_21345_.m_25352_(12, (Goal)new TemptGoal((PathfinderMob)this, 2.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42525_}), false));
        this.f_21345_.m_25352_(13, (Goal)new TemptGoal((PathfinderMob)this, 2.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_151079_}), false));
        this.f_21345_.m_25352_(14, (Goal)new TemptGoal((PathfinderMob)this, 2.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_151056_}), false));
        this.f_21345_.m_25352_(15, (Goal)new TemptGoal((PathfinderMob)this, 2.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_151063_}), false));
        this.f_21345_.m_25352_(16, (Goal)new TemptGoal((PathfinderMob)this, 2.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_152475_.m_5456_()}), false));
        this.f_21345_.m_25352_(17, (Goal)new TemptGoal((PathfinderMob)this, 2.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50386_.m_5456_()}), false));
        this.f_21345_.m_25352_(18, (Goal)new TemptGoal((PathfinderMob)this, 2.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50144_.m_5456_()}), false));
        this.f_21345_.m_25352_(19, (Goal)new TemptGoal((PathfinderMob)this, 2.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50701_.m_5456_()}), false));
        this.f_21345_.m_25352_(20, (Goal)new TemptGoal((PathfinderMob)this, 2.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50174_.m_5456_()}), false));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
        super.m_7472_(source, looting, recentlyHitIn);
        this.m_19983_(new ItemStack((ItemLike)LittleFirefliesModBlocks.LUMINESCENCE.get()));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
    }

    public boolean m_142535_(float l, float d, DamageSource source) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void m_20242_(boolean ignored) {
        super.m_20242_(true);
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_20242_(true);
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)LittleFirefliesModEntities.FIREFLIES.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.m_46791_() != Difficulty.PEACEFUL && Monster.m_33008_((ServerLevelAccessor)world, (BlockPos)pos, (Random)random) && Mob.m_21400_((EntityType)entityType, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (Random)random));
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 4.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22268_(Attributes.f_22280_, 0.3);
        return builder;
    }
}

