
package net.mcreator.mites.client.renderer;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.client.renderer.entity.layers.EyesLayer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.SilverfishModel;

import net.mcreator.mites.entity.MiteEntity;

public class MiteRenderer extends MobRenderer<MiteEntity, SilverfishModel<MiteEntity>> {
	public MiteRenderer(EntityRendererProvider.Context context) {
		super(context, new SilverfishModel(context.bakeLayer(ModelLayers.SILVERFISH)), 0.5f);
		this.addLayer(new EyesLayer<MiteEntity, SilverfishModel<MiteEntity>>(this) {
			@Override
			public RenderType renderType() {
				return RenderType.eyes(new ResourceLocation("mites:textures/miteglowingeye.png"));
			}
		});
	}

	@Override
	public ResourceLocation getTextureLocation(MiteEntity entity) {
		return new ResourceLocation("mites:textures/mite.png");
	}
}
