
package net.mcreator.modification.potion;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffect;

import net.mcreator.modification.procedures.NoFlyActiveTickConditionProcedure;

public class NoFlyMobEffect extends MobEffect {
	public NoFlyMobEffect() {
		super(MobEffectCategory.HARMFUL, 16777215);
	}

	@Override
	public String getDescriptionId() {
		return "effect.modification.no_fly";
	}

	@Override
	public void applyEffectTick(LivingEntity entity, int amplifier) {
		NoFlyActiveTickConditionProcedure.execute(entity);
	}

	@Override
	public boolean isDurationEffectTick(int duration, int amplifier) {
		return true;
	}
}
