/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.spectralium.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.spectralium.SpMod;
import net.mcreator.spectralium.procedures.EmeraldBankEject1Procedure;
import net.mcreator.spectralium.procedures.EmeraldBankEjectProcedure;
import net.mcreator.spectralium.procedures.EmeraldBankInsertProcedure;
import net.mcreator.spectralium.world.inventory.EmeraldBankGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class EmeraldBankGUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public EmeraldBankGUIButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public EmeraldBankGUIButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(EmeraldBankGUIButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(EmeraldBankGUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            EmeraldBankGUIButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = EmeraldBankGUIMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            EmeraldBankInsertProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            EmeraldBankEjectProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 2) {
            EmeraldBankEject1Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        SpMod.addNetworkMessage(EmeraldBankGUIButtonMessage.class, EmeraldBankGUIButtonMessage::buffer, EmeraldBankGUIButtonMessage::new, EmeraldBankGUIButtonMessage::handler);
    }
}

