/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.spectralium.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.spectralium.SpMod;
import net.mcreator.spectralium.procedures.Ironflesh1Procedure;
import net.mcreator.spectralium.procedures.Ironflesh3Procedure;
import net.mcreator.spectralium.procedures.Itonflesh2Procedure;
import net.mcreator.spectralium.procedures.SkillsopenProcedure;
import net.mcreator.spectralium.world.inventory.IronfleshguiMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class IronfleshguiButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public IronfleshguiButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public IronfleshguiButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(IronfleshguiButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(IronfleshguiButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            IronfleshguiButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = IronfleshguiMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            Ironflesh1Procedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            Itonflesh2Procedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            Ironflesh3Procedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            SkillsopenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        SpMod.addNetworkMessage(IronfleshguiButtonMessage.class, IronfleshguiButtonMessage::buffer, IronfleshguiButtonMessage::new, IronfleshguiButtonMessage::handler);
    }
}

