/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.spectralium.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.spectralium.SpMod;
import net.mcreator.spectralium.procedures.Buy10spProcedure;
import net.mcreator.spectralium.procedures.Buy1spProcedure;
import net.mcreator.spectralium.procedures.OpenironfleshProcedure;
import net.mcreator.spectralium.procedures.OpenmoreskillsProcedure;
import net.mcreator.spectralium.procedures.PoweredopenProcedure;
import net.mcreator.spectralium.world.inventory.SkillsmenuMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SkillsmenuButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public SkillsmenuButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public SkillsmenuButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(SkillsmenuButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(SkillsmenuButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            SkillsmenuButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = SkillsmenuMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            Buy1spProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            Buy10spProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            PoweredopenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            OpenironfleshProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            OpenmoreskillsProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        SpMod.addNetworkMessage(SkillsmenuButtonMessage.class, SkillsmenuButtonMessage::buffer, SkillsmenuButtonMessage::new, SkillsmenuButtonMessage::handler);
    }
}

