/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.spectralium.network;

import java.util.function.Supplier;
import net.mcreator.spectralium.SpMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SpModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        SpMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        SpMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        public int type;
        public SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            SavedData savedData = this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
            if (savedData instanceof MapVariables) {
                MapVariables _mapvars = (MapVariables)savedData;
                _mapvars.read(buffer.m_130260_());
            } else {
                savedData = this.data;
                if (savedData instanceof WorldVariables) {
                    WorldVariables _worldvars = (WorldVariables)savedData;
                    _worldvars.read(buffer.m_130260_());
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        public PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.money = message.data.money;
                    variables.up1 = message.data.up1;
                    variables.up2 = message.data.up2;
                    variables.up3 = message.data.up3;
                    variables.up4 = message.data.up4;
                    variables.up5 = message.data.up5;
                    variables.up6 = message.data.up6;
                    variables.up7 = message.data.up7;
                    variables.up8 = message.data.up8;
                    variables.up9 = message.data.up9;
                    variables.up10 = message.data.up10;
                    variables.up11 = message.data.up11;
                    variables.up12 = message.data.up12;
                    variables.up13 = message.data.up13;
                    variables.up14 = message.data.up14;
                    variables.sp = message.data.sp;
                    variables.coalnumber = message.data.coalnumber;
                    variables.ironnumber = message.data.ironnumber;
                    variables.diamondnumber = message.data.diamondnumber;
                    variables.goldnumber = message.data.goldnumber;
                    variables.emeraldnumber = message.data.emeraldnumber;
                    variables.souls = message.data.souls;
                    variables.redstonenumber = message.data.redstonenumber;
                    variables.lapisnumber = message.data.lapisnumber;
                    variables.iradiumnumber = message.data.iradiumnumber;
                    variables.altannumber = message.data.altannumber;
                    variables.spectraliumnumber = message.data.spectraliumnumber;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double money = 500.0;
        public double up1 = 0.0;
        public double up2 = 0.0;
        public double up3 = 0.0;
        public double up4 = 0.0;
        public double up5 = 0.0;
        public double up6 = 0.0;
        public double up7 = 0.0;
        public double up8 = 0.0;
        public double up9 = 0.0;
        public double up10 = 0.0;
        public double up11 = 0.0;
        public double up12 = 0.0;
        public double up13 = 0.0;
        public double up14 = 0.0;
        public double sp = 5.0;
        public double coalnumber = 0.0;
        public double ironnumber = 0.0;
        public double diamondnumber = 0.0;
        public double goldnumber = 0.0;
        public double emeraldnumber = 0.0;
        public double souls = 0.0;
        public double redstonenumber = 0.0;
        public double lapisnumber = 0.0;
        public double iradiumnumber = 0.0;
        public double altannumber = 0.0;
        public double spectraliumnumber = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                SpMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("money", this.money);
            nbt.m_128347_("up1", this.up1);
            nbt.m_128347_("up2", this.up2);
            nbt.m_128347_("up3", this.up3);
            nbt.m_128347_("up4", this.up4);
            nbt.m_128347_("up5", this.up5);
            nbt.m_128347_("up6", this.up6);
            nbt.m_128347_("up7", this.up7);
            nbt.m_128347_("up8", this.up8);
            nbt.m_128347_("up9", this.up9);
            nbt.m_128347_("up10", this.up10);
            nbt.m_128347_("up11", this.up11);
            nbt.m_128347_("up12", this.up12);
            nbt.m_128347_("up13", this.up13);
            nbt.m_128347_("up14", this.up14);
            nbt.m_128347_("sp", this.sp);
            nbt.m_128347_("coalnumber", this.coalnumber);
            nbt.m_128347_("ironnumber", this.ironnumber);
            nbt.m_128347_("diamondnumber", this.diamondnumber);
            nbt.m_128347_("goldnumber", this.goldnumber);
            nbt.m_128347_("emeraldnumber", this.emeraldnumber);
            nbt.m_128347_("souls", this.souls);
            nbt.m_128347_("redstonenumber", this.redstonenumber);
            nbt.m_128347_("lapisnumber", this.lapisnumber);
            nbt.m_128347_("iradiumnumber", this.iradiumnumber);
            nbt.m_128347_("altannumber", this.altannumber);
            nbt.m_128347_("spectraliumnumber", this.spectraliumnumber);
            return nbt;
        }

        public void readNBT(Tag Tag2) {
            CompoundTag nbt = (CompoundTag)Tag2;
            this.money = nbt.m_128459_("money");
            this.up1 = nbt.m_128459_("up1");
            this.up2 = nbt.m_128459_("up2");
            this.up3 = nbt.m_128459_("up3");
            this.up4 = nbt.m_128459_("up4");
            this.up5 = nbt.m_128459_("up5");
            this.up6 = nbt.m_128459_("up6");
            this.up7 = nbt.m_128459_("up7");
            this.up8 = nbt.m_128459_("up8");
            this.up9 = nbt.m_128459_("up9");
            this.up10 = nbt.m_128459_("up10");
            this.up11 = nbt.m_128459_("up11");
            this.up12 = nbt.m_128459_("up12");
            this.up13 = nbt.m_128459_("up13");
            this.up14 = nbt.m_128459_("up14");
            this.sp = nbt.m_128459_("sp");
            this.coalnumber = nbt.m_128459_("coalnumber");
            this.ironnumber = nbt.m_128459_("ironnumber");
            this.diamondnumber = nbt.m_128459_("diamondnumber");
            this.goldnumber = nbt.m_128459_("goldnumber");
            this.emeraldnumber = nbt.m_128459_("emeraldnumber");
            this.souls = nbt.m_128459_("souls");
            this.redstonenumber = nbt.m_128459_("redstonenumber");
            this.lapisnumber = nbt.m_128459_("lapisnumber");
            this.iradiumnumber = nbt.m_128459_("iradiumnumber");
            this.altannumber = nbt.m_128459_("altannumber");
            this.spectraliumnumber = nbt.m_128459_("spectraliumnumber");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("sp", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "sp_mapvars";
        public double farmerlevel = 0.0;
        public double farmerxp = 0.0;
        public double minerlevel = 20.0;
        public double minerxp = 0.0;
        public double hunterlevel = 0.0;
        public double hunterxp = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.farmerlevel = nbt.m_128459_("farmerlevel");
            this.farmerxp = nbt.m_128459_("farmerxp");
            this.minerlevel = nbt.m_128459_("minerlevel");
            this.minerxp = nbt.m_128459_("minerxp");
            this.hunterlevel = nbt.m_128459_("hunterlevel");
            this.hunterxp = nbt.m_128459_("hunterxp");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("farmerlevel", this.farmerlevel);
            nbt.m_128347_("farmerxp", this.farmerxp);
            nbt.m_128347_("minerlevel", this.minerlevel);
            nbt.m_128347_("minerxp", this.minerxp);
            nbt.m_128347_("hunterlevel", this.hunterlevel);
            nbt.m_128347_("hunterxp", this.hunterxp);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                SpMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "sp_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                SpMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.money = original.money;
            clone.up1 = original.up1;
            clone.up2 = original.up2;
            clone.up3 = original.up3;
            clone.up4 = original.up4;
            clone.up5 = original.up5;
            clone.up6 = original.up6;
            clone.up7 = original.up7;
            clone.up8 = original.up8;
            clone.up9 = original.up9;
            clone.up10 = original.up10;
            clone.up11 = original.up11;
            clone.up12 = original.up12;
            clone.up13 = original.up13;
            clone.up14 = original.up14;
            clone.sp = original.sp;
            clone.coalnumber = original.coalnumber;
            clone.ironnumber = original.ironnumber;
            clone.diamondnumber = original.diamondnumber;
            clone.goldnumber = original.goldnumber;
            clone.emeraldnumber = original.emeraldnumber;
            clone.souls = original.souls;
            clone.redstonenumber = original.redstonenumber;
            clone.lapisnumber = original.lapisnumber;
            clone.iradiumnumber = original.iradiumnumber;
            clone.altannumber = original.altannumber;
            clone.spectraliumnumber = original.spectraliumnumber;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().f_19853_);
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().f_19853_);
                if (mapdata != null) {
                    SpMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    SpMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().f_19853_.m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().f_19853_)) != null) {
                SpMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

