/*
 * Decompiled with CFR 0.152.
 */
package com.thecat.platinumcraft.init;

import com.thecat.platinumcraft.world.features.ores.CaliciumOreFeature;
import com.thecat.platinumcraft.world.features.ores.CelestialBronzeOreFeature;
import com.thecat.platinumcraft.world.features.ores.JalinerumOreFeature;
import com.thecat.platinumcraft.world.features.ores.KilikiumOreFeature;
import com.thecat.platinumcraft.world.features.ores.PlatinumOreFeature;
import com.thecat.platinumcraft.world.features.ores.PlenoliumOreFeature;
import com.thecat.platinumcraft.world.features.ores.RainOreFeature;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber
public class PlatinumcraftModFeatures {
    public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"platinumcraft");
    private static final List<FeatureRegistration> FEATURE_REGISTRATIONS = new ArrayList<FeatureRegistration>();
    public static final RegistryObject<Feature<?>> PLENOLIUM_ORE = PlatinumcraftModFeatures.register("plenolium_ore", PlenoliumOreFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, PlenoliumOreFeature.GENERATE_BIOMES, PlenoliumOreFeature::placedFeature));
    public static final RegistryObject<Feature<?>> PLATINUM_ORE = PlatinumcraftModFeatures.register("platinum_ore", PlatinumOreFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, PlatinumOreFeature.GENERATE_BIOMES, PlatinumOreFeature::placedFeature));
    public static final RegistryObject<Feature<?>> CALICIUM_ORE = PlatinumcraftModFeatures.register("calicium_ore", CaliciumOreFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, CaliciumOreFeature.GENERATE_BIOMES, CaliciumOreFeature::placedFeature));
    public static final RegistryObject<Feature<?>> JALINERUM_ORE = PlatinumcraftModFeatures.register("jalinerum_ore", JalinerumOreFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, JalinerumOreFeature.GENERATE_BIOMES, JalinerumOreFeature::placedFeature));
    public static final RegistryObject<Feature<?>> KILIKIUM_ORE = PlatinumcraftModFeatures.register("kilikium_ore", KilikiumOreFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, KilikiumOreFeature.GENERATE_BIOMES, KilikiumOreFeature::placedFeature));
    public static final RegistryObject<Feature<?>> RAIN_ORE = PlatinumcraftModFeatures.register("rain_ore", RainOreFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, RainOreFeature.GENERATE_BIOMES, RainOreFeature::placedFeature));
    public static final RegistryObject<Feature<?>> CELESTIAL_BRONZE_ORE = PlatinumcraftModFeatures.register("celestial_bronze_ore", CelestialBronzeOreFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, CelestialBronzeOreFeature.GENERATE_BIOMES, CelestialBronzeOreFeature::placedFeature));

    private static RegistryObject<Feature<?>> register(String registryname, Supplier<Feature<?>> feature, FeatureRegistration featureRegistration) {
        FEATURE_REGISTRATIONS.add(featureRegistration);
        return REGISTRY.register(registryname, feature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        for (FeatureRegistration registration : FEATURE_REGISTRATIONS) {
            if (registration.biomes() != null && !registration.biomes().contains(event.getName())) continue;
            event.getGeneration().getFeatures(registration.stage()).add(registration.placedFeature().get());
        }
    }

    private record FeatureRegistration(GenerationStep.Decoration stage, Set<ResourceLocation> biomes, Supplier<Holder<PlacedFeature>> placedFeature) {
    }
}

