/*
 * Decompiled with CFR 0.152.
 */
package com.thecat.platinumcraft.init;

import com.thecat.platinumcraft.entity.AntEntity;
import com.thecat.platinumcraft.entity.AssaultRifleEntity;
import com.thecat.platinumcraft.entity.PistolEntity;
import com.thecat.platinumcraft.entity.QueenSpiderEntity;
import com.thecat.platinumcraft.entity.RubberbandEntity;
import com.thecat.platinumcraft.entity.RubberbandGunEntity;
import com.thecat.platinumcraft.entity.StoneGloveEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class PlatinumcraftModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"platinumcraft");
    public static final RegistryObject<EntityType<StoneGloveEntity>> STONE_GLOVE = PlatinumcraftModEntities.register("projectile_stone_glove", EntityType.Builder.m_20704_(StoneGloveEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(StoneGloveEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<AntEntity>> ANT = PlatinumcraftModEntities.register("ant", EntityType.Builder.m_20704_(AntEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(AntEntity::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<QueenSpiderEntity>> QUEEN_SPIDER = PlatinumcraftModEntities.register("queen_spider", EntityType.Builder.m_20704_(QueenSpiderEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(86).setUpdateInterval(3).setCustomClientFactory(QueenSpiderEntity::new).m_20699_(2.0f, 1.0f));
    public static final RegistryObject<EntityType<RubberbandGunEntity>> RUBBERBAND_GUN = PlatinumcraftModEntities.register("projectile_rubberband_gun", EntityType.Builder.m_20704_(RubberbandGunEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(RubberbandGunEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<PistolEntity>> PISTOL = PlatinumcraftModEntities.register("projectile_pistol", EntityType.Builder.m_20704_(PistolEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(PistolEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<AssaultRifleEntity>> ASSAULT_RIFLE = PlatinumcraftModEntities.register("projectile_assault_rifle", EntityType.Builder.m_20704_(AssaultRifleEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(AssaultRifleEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<RubberbandEntity>> RUBBERBAND = PlatinumcraftModEntities.register("projectile_rubberband", EntityType.Builder.m_20704_(RubberbandEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(RubberbandEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            AntEntity.init();
            QueenSpiderEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)ANT.get(), AntEntity.createAttributes().m_22265_());
        event.put((EntityType)QUEEN_SPIDER.get(), QueenSpiderEntity.createAttributes().m_22265_());
    }
}

