/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.wingsoffiremod.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.mcreator.wingsoffiremod.world.features.HivewingHiveFeature;
import net.mcreator.wingsoffiremod.world.features.LostKingdomFeature;
import net.mcreator.wingsoffiremod.world.features.ores.MoonstoneOreFeature;
import net.mcreator.wingsoffiremod.world.features.ores.OnyxOreFeature;
import net.mcreator.wingsoffiremod.world.features.ores.RubyOreFeature;
import net.mcreator.wingsoffiremod.world.features.ores.VenusDragonTrapFeature;
import net.mcreator.wingsoffiremod.world.features.plants.PitcherPlantFeature;
import net.mcreator.wingsoffiremod.world.features.plants.SundewFeature;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber
public class WofmModFeatures {
    public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"wofm");
    private static final List<FeatureRegistration> FEATURE_REGISTRATIONS = new ArrayList<FeatureRegistration>();
    public static final RegistryObject<Feature<?>> MOONSTONE_ORE = WofmModFeatures.register("moonstone_ore", MoonstoneOreFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, MoonstoneOreFeature.GENERATE_BIOMES, MoonstoneOreFeature::placedFeature));
    public static final RegistryObject<Feature<?>> ONYX_ORE = WofmModFeatures.register("onyx_ore", OnyxOreFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, OnyxOreFeature.GENERATE_BIOMES, OnyxOreFeature::placedFeature));
    public static final RegistryObject<Feature<?>> RUBY_ORE = WofmModFeatures.register("ruby_ore", RubyOreFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, RubyOreFeature.GENERATE_BIOMES, RubyOreFeature::placedFeature));
    public static final RegistryObject<Feature<?>> SUNDEW = WofmModFeatures.register("sundew", SundewFeature::feature, new FeatureRegistration(GenerationStep.Decoration.VEGETAL_DECORATION, SundewFeature.GENERATE_BIOMES, SundewFeature::placedFeature));
    public static final RegistryObject<Feature<?>> PITCHER_PLANT = WofmModFeatures.register("pitcher_plant", PitcherPlantFeature::feature, new FeatureRegistration(GenerationStep.Decoration.VEGETAL_DECORATION, PitcherPlantFeature.GENERATE_BIOMES, PitcherPlantFeature::placedFeature));
    public static final RegistryObject<Feature<?>> VENUS_DRAGON_TRAP = WofmModFeatures.register("venus_dragon_trap", VenusDragonTrapFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, VenusDragonTrapFeature.GENERATE_BIOMES, VenusDragonTrapFeature::placedFeature));
    public static final RegistryObject<Feature<?>> HIVEWING_HIVE = WofmModFeatures.register("hivewing_hive", HivewingHiveFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, HivewingHiveFeature.GENERATE_BIOMES, HivewingHiveFeature::placedFeature));
    public static final RegistryObject<Feature<?>> LOST_KINGDOM = WofmModFeatures.register("lost_kingdom", LostKingdomFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, LostKingdomFeature.GENERATE_BIOMES, LostKingdomFeature::placedFeature));

    private static RegistryObject<Feature<?>> register(String registryname, Supplier<Feature<?>> feature, FeatureRegistration featureRegistration) {
        FEATURE_REGISTRATIONS.add(featureRegistration);
        return REGISTRY.register(registryname, feature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        for (FeatureRegistration registration : FEATURE_REGISTRATIONS) {
            if (registration.biomes() != null && !registration.biomes().contains(event.getName())) continue;
            event.getGeneration().getFeatures(registration.stage()).add(registration.placedFeature().get());
        }
    }

    private record FeatureRegistration(GenerationStep.Decoration stage, Set<ResourceLocation> biomes, Supplier<Holder<PlacedFeature>> placedFeature) {
    }
}

