/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.netherrebirth.init;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Map;
import net.mcreator.netherrebirth.init.NetherRebirthModBlocks;
import net.mcreator.netherrebirth.world.biome.AmethystValleyBiome;
import net.mcreator.netherrebirth.world.biome.IcePlainsBiome;
import net.mcreator.netherrebirth.world.biome.MushroomWastesBiome;
import net.mcreator.netherrebirth.world.biome.SharenJungleBiome;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class NetherRebirthModBiomes {
    public static final DeferredRegister<Biome> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)"nether_rebirth");
    public static final RegistryObject<Biome> MUSHROOM_WASTES = REGISTRY.register("mushroom_wastes", () -> MushroomWastesBiome.createBiome());
    public static final RegistryObject<Biome> ICE_PLAINS = REGISTRY.register("ice_plains", () -> IcePlainsBiome.createBiome());
    public static final RegistryObject<Biome> SHAREN_JUNGLE = REGISTRY.register("sharen_jungle", () -> SharenJungleBiome.createBiome());
    public static final RegistryObject<Biome> AMETHYST_VALLEY = REGISTRY.register("amethyst_valley", () -> AmethystValleyBiome.createBiome());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            MushroomWastesBiome.init();
            IcePlainsBiome.init();
            SharenJungleBiome.init();
            AmethystValleyBiome.init();
        });
    }

    @Mod.EventBusSubscriber
    public static class BiomeInjector {
        @SubscribeEvent
        public static void onServerAboutToStart(ServerAboutToStartEvent event) {
            MinecraftServer server = event.getServer();
            Registry dimensionTypeRegistry = server.m_206579_().m_175515_(Registry.f_122818_);
            Registry biomeRegistry = server.m_206579_().m_175515_(Registry.f_122885_);
            WorldGenSettings worldGenSettings = server.m_129910_().m_5961_();
            for (Map.Entry entry : worldGenSettings.m_204655_().m_6579_()) {
                DimensionType dimensionType = (DimensionType)((LevelStem)entry.getValue()).m_204521_().m_203334_();
                if (dimensionType != dimensionTypeRegistry.m_123013_(DimensionType.f_63846_)) continue;
                ChunkGenerator chunkGenerator = ((LevelStem)entry.getValue()).m_63990_();
                BiomeSource biomeSource = chunkGenerator.m_62218_();
                if (biomeSource instanceof MultiNoiseBiomeSource) {
                    MultiNoiseBiomeSource noiseSource = (MultiNoiseBiomeSource)biomeSource;
                    ArrayList<Pair> parameters = new ArrayList<Pair>(noiseSource.f_48435_.m_186850_());
                    parameters.add(new Pair((Object)MushroomWastesBiome.PARAMETER_POINT, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)MUSHROOM_WASTES.getId()))));
                    parameters.add(new Pair((Object)IcePlainsBiome.PARAMETER_POINT, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)ICE_PLAINS.getId()))));
                    parameters.add(new Pair((Object)SharenJungleBiome.PARAMETER_POINT, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)SHAREN_JUNGLE.getId()))));
                    parameters.add(new Pair((Object)AmethystValleyBiome.PARAMETER_POINT, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)AMETHYST_VALLEY.getId()))));
                    MultiNoiseBiomeSource moddedNoiseSource = new MultiNoiseBiomeSource(new Climate.ParameterList(parameters), noiseSource.f_48438_);
                    chunkGenerator.f_62137_ = moddedNoiseSource;
                    chunkGenerator.f_62138_ = moddedNoiseSource;
                }
                if (!(chunkGenerator instanceof NoiseBasedChunkGenerator)) continue;
                NoiseBasedChunkGenerator noiseGenerator = (NoiseBasedChunkGenerator)chunkGenerator;
                NoiseGeneratorSettings noiseGeneratorSettings = (NoiseGeneratorSettings)noiseGenerator.f_64318_.m_203334_();
                SurfaceRules.RuleSource currentRuleSource = noiseGeneratorSettings.f_188871_();
                if (!(currentRuleSource instanceof SurfaceRules.SequenceRuleSource)) continue;
                SurfaceRules.SequenceRuleSource sequenceRuleSource = (SurfaceRules.SequenceRuleSource)currentRuleSource;
                ArrayList<SurfaceRules.RuleSource> surfaceRules = new ArrayList<SurfaceRules.RuleSource>(sequenceRuleSource.f_189697_());
                surfaceRules.add(2, BiomeInjector.anySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)MUSHROOM_WASTES.getId()), Blocks.f_50195_.m_49966_(), Blocks.f_50493_.m_49966_(), Blocks.f_50493_.m_49966_()));
                surfaceRules.add(2, BiomeInjector.anySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)ICE_PLAINS.getId()), Blocks.f_50126_.m_49966_(), Blocks.f_50127_.m_49966_(), Blocks.f_50127_.m_49966_()));
                surfaceRules.add(2, BiomeInjector.anySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)SHAREN_JUNGLE.getId()), Blocks.f_152544_.m_49966_(), ((Block)NetherRebirthModBlocks.SHARAN_NYLIUM.get()).m_49966_(), Blocks.f_49990_.m_49966_()));
                surfaceRules.add(2, BiomeInjector.anySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)AMETHYST_VALLEY.getId()), Blocks.f_152490_.m_49966_(), Blocks.f_152490_.m_49966_(), Blocks.f_152490_.m_49966_()));
                NoiseGeneratorSettings moddedNoiseGeneratorSettings = new NoiseGeneratorSettings(noiseGeneratorSettings.f_64439_(), noiseGeneratorSettings.f_64440_(), noiseGeneratorSettings.f_64441_(), noiseGeneratorSettings.f_209353_(), SurfaceRules.m_198272_((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])surfaceRules.toArray(SurfaceRules.RuleSource[]::new))), noiseGeneratorSettings.f_64444_(), noiseGeneratorSettings.f_64445_(), noiseGeneratorSettings.f_158533_(), noiseGeneratorSettings.m_209369_(), noiseGeneratorSettings.f_209354_());
                noiseGenerator.f_64318_ = new Holder.Direct((Object)moddedNoiseGeneratorSettings);
            }
        }

        private static SurfaceRules.RuleSource anySurfaceRule(ResourceKey<Biome> biomeKey, BlockState groundBlock, BlockState undergroundBlock, BlockState underwaterBlock) {
            return SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{biomeKey}), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)false, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189382_((int)-1, (int)0), (SurfaceRules.RuleSource)SurfaceRules.m_189390_((BlockState)groundBlock)), SurfaceRules.m_189390_((BlockState)underwaterBlock)})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)true, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.m_189390_((BlockState)undergroundBlock))}));
        }
    }
}

