/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.netherrebirth.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.mcreator.netherrebirth.world.features.ores.NetherSharaniteOreFeature;
import net.mcreator.netherrebirth.world.features.ores.SathiumOreFeature;
import net.mcreator.netherrebirth.world.features.ores.TitaniumOreFeature;
import net.mcreator.netherrebirth.world.features.plants.SharanGrassFeature;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber
public class NetherRebirthModFeatures {
    public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"nether_rebirth");
    private static final List<FeatureRegistration> FEATURE_REGISTRATIONS = new ArrayList<FeatureRegistration>();
    public static final RegistryObject<Feature<?>> TITANIUM_ORE = NetherRebirthModFeatures.register("titanium_ore", TitaniumOreFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, TitaniumOreFeature.GENERATE_BIOMES, TitaniumOreFeature::placedFeature));
    public static final RegistryObject<Feature<?>> SATHIUM_ORE = NetherRebirthModFeatures.register("sathium_ore", SathiumOreFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, SathiumOreFeature.GENERATE_BIOMES, SathiumOreFeature::placedFeature));
    public static final RegistryObject<Feature<?>> SHARAN_GRASS = NetherRebirthModFeatures.register("sharan_grass", SharanGrassFeature::feature, new FeatureRegistration(GenerationStep.Decoration.VEGETAL_DECORATION, SharanGrassFeature.GENERATE_BIOMES, SharanGrassFeature::placedFeature));
    public static final RegistryObject<Feature<?>> NETHER_SHARANITE_ORE = NetherRebirthModFeatures.register("nether_sharanite_ore", NetherSharaniteOreFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, NetherSharaniteOreFeature.GENERATE_BIOMES, NetherSharaniteOreFeature::placedFeature));

    private static RegistryObject<Feature<?>> register(String registryname, Supplier<Feature<?>> feature, FeatureRegistration featureRegistration) {
        FEATURE_REGISTRATIONS.add(featureRegistration);
        return REGISTRY.register(registryname, feature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        for (FeatureRegistration registration : FEATURE_REGISTRATIONS) {
            if (registration.biomes() != null && !registration.biomes().contains(event.getName())) continue;
            event.getGeneration().getFeatures(registration.stage()).add(registration.placedFeature().get());
        }
    }

    private record FeatureRegistration(GenerationStep.Decoration stage, Set<ResourceLocation> biomes, Supplier<Holder<PlacedFeature>> placedFeature) {
    }
}

