/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.johnmodremake.entity;

import net.mcreator.johnmodremake.init.JohnModRemakeModEntities;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

@Mod.EventBusSubscriber
public class WarjohnEntity
extends Monster
implements IAnimatable {
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private boolean swinging;
    private long lastSwing;

    @SubscribeEvent
    public static void addLivingEntityToBiomes(BiomeLoadingEvent event) {
        event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)JohnModRemakeModEntities.WARJOHN.get(), 2, 1, 1));
    }

    public WarjohnEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<WarjohnEntity>)((EntityType)JohnModRemakeModEntities.WARJOHN.get()), world);
    }

    public WarjohnEntity(EntityType<WarjohnEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 1;
        this.m_21557_(false);
        this.m_21530_();
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, true){

            protected double m_6639_(LivingEntity entity) {
                return 4.0 + (double)(entity.m_20205_() * entity.m_20205_());
            }
        });
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, true));
        this.f_21346_.m_25352_(6, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, true, true));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("ambient.cave"));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.enderman.death"));
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)JohnModRemakeModEntities.WARJOHN.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.m_8055_(pos.m_7495_()).m_60767_() == Material.f_76315_ && world.m_45524_(pos, 0) > 8);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.28);
        builder = builder.m_22268_(Attributes.f_22276_, 30.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 10.0);
        builder = builder.m_22268_(Attributes.f_22277_, 100.0);
        builder = builder.m_22268_(Attributes.f_22282_, 1.0);
        return builder;
    }

    private <E extends IAnimatable> PlayState movementPredicate(AnimationEvent<E> event) {
        event.getController().animationSpeed = 1.25;
        event.getController().transitionLengthTicks = 5.0;
        double d1 = this.m_20185_() - this.f_19790_;
        double d0 = this.m_20189_() - this.f_19792_;
        float velocity = (float)Math.sqrt(d1 * d1 + d0 * d0);
        if (this.m_21324_(event.getPartialTick()) > 0.0f && !this.swinging) {
            this.swinging = true;
            this.lastSwing = this.f_19853_.m_46467_();
        }
        if (this.swinging && this.lastSwing + 15L <= this.f_19853_.m_46467_()) {
            this.swinging = false;
        }
        if (this.swinging) {
            event.getController().transitionLengthTicks = 0.0;
            event.getController().animationSpeed = 0.8;
            event.getController().setAnimation(new AnimationBuilder().addAnimation("attack"));
            return PlayState.CONTINUE;
        }
        if (event.isMoving() && !this.swinging && !this.m_20142_() && !this.m_6144_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("walk", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (this.m_21224_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("death", Boolean.valueOf(false)));
            return PlayState.CONTINUE;
        }
        if (this.m_20072_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("swim", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (this.m_20142_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("sprint", Boolean.valueOf(false)));
            return PlayState.CONTINUE;
        }
        if (this.m_6144_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("sneak", Boolean.valueOf(false)));
            return PlayState.CONTINUE;
        }
        if (!(this.swinging || this.m_20142_() || this.m_6144_())) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        return PlayState.CONTINUE;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "movement", 4.0f, this::movementPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

