/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.desertbones.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.mcreator.desertbones.world.features.Coral1Feature;
import net.mcreator.desertbones.world.features.Coral2Feature;
import net.mcreator.desertbones.world.features.Hueso1Feature;
import net.mcreator.desertbones.world.features.Hueso2Feature;
import net.mcreator.desertbones.world.features.Hueso3Feature;
import net.mcreator.desertbones.world.features.Hueso4Feature;
import net.mcreator.desertbones.world.features.Hueso5Feature;
import net.mcreator.desertbones.world.features.HuesoEspecialFeature;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber
public class DesertBonesModFeatures {
    public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"desert_bones");
    private static final List<FeatureRegistration> FEATURE_REGISTRATIONS = new ArrayList<FeatureRegistration>();
    public static final RegistryObject<Feature<?>> HUESO_1 = DesertBonesModFeatures.register("hueso_1", Hueso1Feature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, Hueso1Feature.GENERATE_BIOMES, Hueso1Feature::placedFeature));
    public static final RegistryObject<Feature<?>> HUESO_2 = DesertBonesModFeatures.register("hueso_2", Hueso2Feature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, Hueso2Feature.GENERATE_BIOMES, Hueso2Feature::placedFeature));
    public static final RegistryObject<Feature<?>> HUESO_3 = DesertBonesModFeatures.register("hueso_3", Hueso3Feature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, Hueso3Feature.GENERATE_BIOMES, Hueso3Feature::placedFeature));
    public static final RegistryObject<Feature<?>> HUESO_4 = DesertBonesModFeatures.register("hueso_4", Hueso4Feature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, Hueso4Feature.GENERATE_BIOMES, Hueso4Feature::placedFeature));
    public static final RegistryObject<Feature<?>> HUESO_5 = DesertBonesModFeatures.register("hueso_5", Hueso5Feature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, Hueso5Feature.GENERATE_BIOMES, Hueso5Feature::placedFeature));
    public static final RegistryObject<Feature<?>> CORAL_1 = DesertBonesModFeatures.register("coral_1", Coral1Feature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, Coral1Feature.GENERATE_BIOMES, Coral1Feature::placedFeature));
    public static final RegistryObject<Feature<?>> CORAL_2 = DesertBonesModFeatures.register("coral_2", Coral2Feature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, Coral2Feature.GENERATE_BIOMES, Coral2Feature::placedFeature));
    public static final RegistryObject<Feature<?>> HUESO_ESPECIAL = DesertBonesModFeatures.register("hueso_especial", HuesoEspecialFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, HuesoEspecialFeature.GENERATE_BIOMES, HuesoEspecialFeature::placedFeature));

    private static RegistryObject<Feature<?>> register(String registryname, Supplier<Feature<?>> feature, FeatureRegistration featureRegistration) {
        FEATURE_REGISTRATIONS.add(featureRegistration);
        return REGISTRY.register(registryname, feature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        for (FeatureRegistration registration : FEATURE_REGISTRATIONS) {
            if (registration.biomes() != null && !registration.biomes().contains(event.getName())) continue;
            event.getGeneration().getFeatures(registration.stage()).add(registration.placedFeature().get());
        }
    }

    private record FeatureRegistration(GenerationStep.Decoration stage, Set<ResourceLocation> biomes, Supplier<Holder<PlacedFeature>> placedFeature) {
    }
}

