/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.walkingsystem.network;

import java.util.function.Supplier;
import net.mcreator.walkingsystem.WalkingSystemMod;
import net.mcreator.walkingsystem.procedures.WalkOnKeyPressedProcedure;
import net.mcreator.walkingsystem.procedures.WalkOnKeyReleasedProcedure;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class WalkMessage {
    int type;
    int pressedms;

    public WalkMessage(int type, int pressedms) {
        this.type = type;
        this.pressedms = pressedms;
    }

    public WalkMessage(FriendlyByteBuf buffer) {
        this.type = buffer.readInt();
        this.pressedms = buffer.readInt();
    }

    public static void buffer(WalkMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.type);
        buffer.writeInt(message.pressedms);
    }

    public static void handler(WalkMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> WalkMessage.pressAction((Player)context.getSender(), message.type, message.pressedms));
        context.setPacketHandled(true);
    }

    public static void pressAction(Player entity, int type, int pressedms) {
        Level world = entity.f_19853_;
        double x = entity.m_20185_();
        double y = entity.m_20186_();
        double z = entity.m_20189_();
        if (!world.m_46805_(entity.m_142538_())) {
            return;
        }
        if (type == 0) {
            WalkOnKeyPressedProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (type == 1) {
            WalkOnKeyReleasedProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        WalkingSystemMod.addNetworkMessage(WalkMessage.class, WalkMessage::buffer, WalkMessage::new, WalkMessage::handler);
    }
}

