/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.tribulation.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.tribulation.TribulationMod;
import net.mcreator.tribulation.procedures.HunterStatSelectionConfirmProcedure;
import net.mcreator.tribulation.procedures.HunterStatSelectionDecreaseBalanceProcedure;
import net.mcreator.tribulation.procedures.HunterStatSelectionDecreaseRageProcedure;
import net.mcreator.tribulation.procedures.HunterStatSelectionDecreaseVigorProcedure;
import net.mcreator.tribulation.procedures.HunterStatSelectionIncreaseBalanceProcedure;
import net.mcreator.tribulation.procedures.HunterStatSelectionIncreaseRageProcedure;
import net.mcreator.tribulation.procedures.HunterStatSelectionIncreaseVigorProcedure;
import net.mcreator.tribulation.world.inventory.HunterStatSelectionMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class HunterStatSelectionButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public HunterStatSelectionButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public HunterStatSelectionButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(HunterStatSelectionButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(HunterStatSelectionButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            HunterStatSelectionButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = HunterStatSelectionMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            HunterStatSelectionConfirmProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            HunterStatSelectionDecreaseRageProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 2) {
            HunterStatSelectionIncreaseRageProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 3) {
            HunterStatSelectionDecreaseBalanceProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 4) {
            HunterStatSelectionIncreaseBalanceProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 5) {
            HunterStatSelectionDecreaseVigorProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 6) {
            HunterStatSelectionIncreaseVigorProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        TribulationMod.addNetworkMessage(HunterStatSelectionButtonMessage.class, HunterStatSelectionButtonMessage::buffer, HunterStatSelectionButtonMessage::new, HunterStatSelectionButtonMessage::handler);
    }
}

