/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.tribulation.network;

import java.util.function.Supplier;
import net.mcreator.tribulation.TribulationMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TribulationModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        TribulationMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        TribulationMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        public int type;
        public SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            SavedData savedData = this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
            if (savedData instanceof MapVariables) {
                MapVariables _mapvars = (MapVariables)savedData;
                _mapvars.read(buffer.m_130260_());
            } else {
                savedData = this.data;
                if (savedData instanceof WorldVariables) {
                    WorldVariables _worldvars = (WorldVariables)savedData;
                    _worldvars.read(buffer.m_130260_());
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        public PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.max_rage = message.data.max_rage;
                    variables.max_balance = message.data.max_balance;
                    variables.max_vigor = message.data.max_vigor;
                    variables.max_mana = message.data.max_mana;
                    variables.mana = message.data.mana;
                    variables.walk = message.data.walk;
                    variables.mageTierReq = message.data.mageTierReq;
                    variables.max_stamina = message.data.max_stamina;
                    variables.stamina = message.data.stamina;
                    variables.current_keybind = message.data.current_keybind;
                    variables.ActiveSkill = message.data.ActiveSkill;
                    variables.ActiveCast = message.data.ActiveCast;
                    variables.CastDrain = message.data.CastDrain;
                    variables.playerPitch = message.data.playerPitch;
                    variables.playerYaw = message.data.playerYaw;
                    variables.maxHealthRespawn = message.data.maxHealthRespawn;
                    variables.cult = message.data.cult;
                    variables.skill1 = message.data.skill1;
                    variables.skill2 = message.data.skill2;
                    variables.skill3 = message.data.skill3;
                    variables.skill4 = message.data.skill4;
                    variables.bossParticipation = message.data.bossParticipation;
                    variables.cooldown = message.data.cooldown;
                    variables.pointsLeft = message.data.pointsLeft;
                    variables.ragePoints = message.data.ragePoints;
                    variables.balancePoints = message.data.balancePoints;
                    variables.vigorPoints = message.data.vigorPoints;
                    variables.bonusManaRegen = message.data.bonusManaRegen;
                    variables.potentialTier = message.data.potentialTier;
                    variables.rage = message.data.rage;
                    variables.balance = message.data.balance;
                    variables.vigor = message.data.vigor;
                    variables.hunter = message.data.hunter;
                    variables.mage = message.data.mage;
                    variables.managen = message.data.managen;
                    variables.manadam = message.data.manadam;
                    variables.managard = message.data.managard;
                    variables.school = message.data.school;
                    variables.vengeanceRevive = message.data.vengeanceRevive;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double max_rage = 0.0;
        public double max_balance = 0.0;
        public double max_vigor = 0.0;
        public double max_mana = 0.0;
        public double mana = 0.0;
        public boolean walk = false;
        public double mageTierReq = 0.0;
        public double max_stamina = 0.0;
        public double stamina = 0.0;
        public double current_keybind = 0.0;
        public ItemStack ActiveSkill = ItemStack.f_41583_;
        public boolean ActiveCast = false;
        public double CastDrain = 0.0;
        public double playerPitch = 0.0;
        public double playerYaw = 0.0;
        public double maxHealthRespawn = 0.0;
        public double cult = 0.0;
        public ItemStack skill1 = ItemStack.f_41583_;
        public ItemStack skill2 = ItemStack.f_41583_;
        public ItemStack skill3 = ItemStack.f_41583_;
        public ItemStack skill4 = ItemStack.f_41583_;
        public boolean bossParticipation = false;
        public double cooldown = 0.0;
        public double pointsLeft = 0.0;
        public double ragePoints = 0.0;
        public double balancePoints = 0.0;
        public double vigorPoints = 0.0;
        public double bonusManaRegen = 0.0;
        public double potentialTier = 1.0;
        public double rage = 0.0;
        public double balance = 0.0;
        public double vigor = 0.0;
        public double hunter = 0.0;
        public double mage = 0.0;
        public double managen = 0.0;
        public double manadam = 0.0;
        public double managard = 0.0;
        public double school = 0.0;
        public boolean vengeanceRevive = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                TribulationMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("max_rage", this.max_rage);
            nbt.m_128347_("max_balance", this.max_balance);
            nbt.m_128347_("max_vigor", this.max_vigor);
            nbt.m_128347_("max_mana", this.max_mana);
            nbt.m_128347_("mana", this.mana);
            nbt.m_128379_("walk", this.walk);
            nbt.m_128347_("mageTierReq", this.mageTierReq);
            nbt.m_128347_("max_stamina", this.max_stamina);
            nbt.m_128347_("stamina", this.stamina);
            nbt.m_128347_("current_keybind", this.current_keybind);
            nbt.m_128365_("ActiveSkill", (Tag)this.ActiveSkill.m_41739_(new CompoundTag()));
            nbt.m_128379_("ActiveCast", this.ActiveCast);
            nbt.m_128347_("CastDrain", this.CastDrain);
            nbt.m_128347_("playerPitch", this.playerPitch);
            nbt.m_128347_("playerYaw", this.playerYaw);
            nbt.m_128347_("maxHealthRespawn", this.maxHealthRespawn);
            nbt.m_128347_("cult", this.cult);
            nbt.m_128365_("skill1", (Tag)this.skill1.m_41739_(new CompoundTag()));
            nbt.m_128365_("skill2", (Tag)this.skill2.m_41739_(new CompoundTag()));
            nbt.m_128365_("skill3", (Tag)this.skill3.m_41739_(new CompoundTag()));
            nbt.m_128365_("skill4", (Tag)this.skill4.m_41739_(new CompoundTag()));
            nbt.m_128379_("bossParticipation", this.bossParticipation);
            nbt.m_128347_("cooldown", this.cooldown);
            nbt.m_128347_("pointsLeft", this.pointsLeft);
            nbt.m_128347_("ragePoints", this.ragePoints);
            nbt.m_128347_("balancePoints", this.balancePoints);
            nbt.m_128347_("vigorPoints", this.vigorPoints);
            nbt.m_128347_("bonusManaRegen", this.bonusManaRegen);
            nbt.m_128347_("potentialTier", this.potentialTier);
            nbt.m_128347_("rage", this.rage);
            nbt.m_128347_("balance", this.balance);
            nbt.m_128347_("vigor", this.vigor);
            nbt.m_128347_("hunter", this.hunter);
            nbt.m_128347_("mage", this.mage);
            nbt.m_128347_("managen", this.managen);
            nbt.m_128347_("manadam", this.manadam);
            nbt.m_128347_("managard", this.managard);
            nbt.m_128347_("school", this.school);
            nbt.m_128379_("vengeanceRevive", this.vengeanceRevive);
            return nbt;
        }

        public void readNBT(Tag Tag2) {
            CompoundTag nbt = (CompoundTag)Tag2;
            this.max_rage = nbt.m_128459_("max_rage");
            this.max_balance = nbt.m_128459_("max_balance");
            this.max_vigor = nbt.m_128459_("max_vigor");
            this.max_mana = nbt.m_128459_("max_mana");
            this.mana = nbt.m_128459_("mana");
            this.walk = nbt.m_128471_("walk");
            this.mageTierReq = nbt.m_128459_("mageTierReq");
            this.max_stamina = nbt.m_128459_("max_stamina");
            this.stamina = nbt.m_128459_("stamina");
            this.current_keybind = nbt.m_128459_("current_keybind");
            this.ActiveSkill = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("ActiveSkill"));
            this.ActiveCast = nbt.m_128471_("ActiveCast");
            this.CastDrain = nbt.m_128459_("CastDrain");
            this.playerPitch = nbt.m_128459_("playerPitch");
            this.playerYaw = nbt.m_128459_("playerYaw");
            this.maxHealthRespawn = nbt.m_128459_("maxHealthRespawn");
            this.cult = nbt.m_128459_("cult");
            this.skill1 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("skill1"));
            this.skill2 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("skill2"));
            this.skill3 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("skill3"));
            this.skill4 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("skill4"));
            this.bossParticipation = nbt.m_128471_("bossParticipation");
            this.cooldown = nbt.m_128459_("cooldown");
            this.pointsLeft = nbt.m_128459_("pointsLeft");
            this.ragePoints = nbt.m_128459_("ragePoints");
            this.balancePoints = nbt.m_128459_("balancePoints");
            this.vigorPoints = nbt.m_128459_("vigorPoints");
            this.bonusManaRegen = nbt.m_128459_("bonusManaRegen");
            this.potentialTier = nbt.m_128459_("potentialTier");
            this.rage = nbt.m_128459_("rage");
            this.balance = nbt.m_128459_("balance");
            this.vigor = nbt.m_128459_("vigor");
            this.hunter = nbt.m_128459_("hunter");
            this.mage = nbt.m_128459_("mage");
            this.managen = nbt.m_128459_("managen");
            this.manadam = nbt.m_128459_("manadam");
            this.managard = nbt.m_128459_("managard");
            this.school = nbt.m_128459_("school");
            this.vengeanceRevive = nbt.m_128471_("vengeanceRevive");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("tribulation", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "tribulation_mapvars";
        public double temporalKnightMusic = 6000.0;
        public double carnageMusic = 3500.0;
        public double houyllaMusic = 3200.0;
        public boolean spiritSpawning = false;
        public boolean veilBlessing = false;
        public boolean fleshSpawn = false;
        public boolean earlygameSpawning = false;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.temporalKnightMusic = nbt.m_128459_("temporalKnightMusic");
            this.carnageMusic = nbt.m_128459_("carnageMusic");
            this.houyllaMusic = nbt.m_128459_("houyllaMusic");
            this.spiritSpawning = nbt.m_128471_("spiritSpawning");
            this.veilBlessing = nbt.m_128471_("veilBlessing");
            this.fleshSpawn = nbt.m_128471_("fleshSpawn");
            this.earlygameSpawning = nbt.m_128471_("earlygameSpawning");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("temporalKnightMusic", this.temporalKnightMusic);
            nbt.m_128347_("carnageMusic", this.carnageMusic);
            nbt.m_128347_("houyllaMusic", this.houyllaMusic);
            nbt.m_128379_("spiritSpawning", this.spiritSpawning);
            nbt.m_128379_("veilBlessing", this.veilBlessing);
            nbt.m_128379_("fleshSpawn", this.fleshSpawn);
            nbt.m_128379_("earlygameSpawning", this.earlygameSpawning);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                TribulationMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "tribulation_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                TribulationMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.max_rage = original.max_rage;
            clone.max_balance = original.max_balance;
            clone.max_vigor = original.max_vigor;
            clone.max_mana = original.max_mana;
            clone.mageTierReq = original.mageTierReq;
            clone.max_stamina = original.max_stamina;
            clone.cult = original.cult;
            clone.skill1 = original.skill1;
            clone.skill2 = original.skill2;
            clone.skill3 = original.skill3;
            clone.skill4 = original.skill4;
            clone.bossParticipation = original.bossParticipation;
            clone.potentialTier = original.potentialTier;
            clone.rage = original.rage;
            clone.balance = original.balance;
            clone.vigor = original.vigor;
            clone.hunter = original.hunter;
            clone.mage = original.mage;
            clone.managen = original.managen;
            clone.manadam = original.manadam;
            clone.managard = original.managard;
            clone.school = original.school;
            if (!event.isWasDeath()) {
                clone.mana = original.mana;
                clone.walk = original.walk;
                clone.stamina = original.stamina;
                clone.current_keybind = original.current_keybind;
                clone.ActiveSkill = original.ActiveSkill;
                clone.ActiveCast = original.ActiveCast;
                clone.CastDrain = original.CastDrain;
                clone.playerPitch = original.playerPitch;
                clone.playerYaw = original.playerYaw;
                clone.maxHealthRespawn = original.maxHealthRespawn;
                clone.cooldown = original.cooldown;
                clone.pointsLeft = original.pointsLeft;
                clone.ragePoints = original.ragePoints;
                clone.balancePoints = original.balancePoints;
                clone.vigorPoints = original.vigorPoints;
                clone.bonusManaRegen = original.bonusManaRegen;
                clone.vengeanceRevive = original.vengeanceRevive;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().f_19853_);
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().f_19853_);
                if (mapdata != null) {
                    TribulationMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    TribulationMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().f_19853_.m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().f_19853_)) != null) {
                TribulationMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

