/*
 * Decompiled with CFR 0.152.
 */
package net.limett.moneymod.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.limett.moneymod.MoneymodMod;
import net.limett.moneymod.procedures.FarmerMarketBuyCarrotProcedure;
import net.limett.moneymod.procedures.FarmerMarketBuyMelonProcedure;
import net.limett.moneymod.procedures.FarmerMarketBuyPotatoProcedure;
import net.limett.moneymod.procedures.FarmerMarketSellCarrotProcedure;
import net.limett.moneymod.procedures.FarmerMarketSellMelonProcedure;
import net.limett.moneymod.procedures.FarmerMarketSellPotatoProcedure;
import net.limett.moneymod.world.inventory.FarmerMarketGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class FarmerMarketGUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public FarmerMarketGUIButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public FarmerMarketGUIButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(FarmerMarketGUIButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(FarmerMarketGUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            FarmerMarketGUIButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = FarmerMarketGUIMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            FarmerMarketBuyCarrotProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            FarmerMarketBuyMelonProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            FarmerMarketBuyPotatoProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            FarmerMarketSellCarrotProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            FarmerMarketSellMelonProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            FarmerMarketSellPotatoProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        MoneymodMod.addNetworkMessage(FarmerMarketGUIButtonMessage.class, FarmerMarketGUIButtonMessage::buffer, FarmerMarketGUIButtonMessage::new, FarmerMarketGUIButtonMessage::handler);
    }
}

