/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.cmdblockascension.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.cmdblockascension.CmdblockascensionMod;
import net.mcreator.cmdblockascension.procedures.ExitPresetsProcedure;
import net.mcreator.cmdblockascension.procedures.GamemodeAProcedure;
import net.mcreator.cmdblockascension.procedures.GamemodeCProcedure;
import net.mcreator.cmdblockascension.procedures.GamemodeSPProcedure;
import net.mcreator.cmdblockascension.procedures.GamemodeSProcedure;
import net.mcreator.cmdblockascension.procedures.OpenPresets2GUIProcedure;
import net.mcreator.cmdblockascension.procedures.OpenWitherStormPresetsProcedure;
import net.mcreator.cmdblockascension.procedures.PresetClearItemsOnGroundProcedure;
import net.mcreator.cmdblockascension.procedures.PresetKillUselessEntitiesProcedure;
import net.mcreator.cmdblockascension.procedures.PresetWeatherProcedure;
import net.mcreator.cmdblockascension.world.inventory.PresetsGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class PresetsGUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public PresetsGUIButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public PresetsGUIButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(PresetsGUIButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(PresetsGUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            PresetsGUIButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = PresetsGUIMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            PresetClearItemsOnGroundProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 1) {
            OpenPresets2GUIProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            PresetKillUselessEntitiesProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 3) {
            ExitPresetsProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            PresetWeatherProcedure.execute((LevelAccessor)world, x, y, z, guistate);
        }
        if (buttonID == 5) {
            GamemodeCProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 6) {
            GamemodeSProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 7) {
            GamemodeAProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 8) {
            GamemodeSPProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 9) {
            OpenWitherStormPresetsProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CmdblockascensionMod.addNetworkMessage(PresetsGUIButtonMessage.class, PresetsGUIButtonMessage::buffer, PresetsGUIButtonMessage::new, PresetsGUIButtonMessage::handler);
    }
}

