/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.warcraft.init;

import net.mcreator.warcraft.entity.ArcherEntity;
import net.mcreator.warcraft.entity.AssasinEntity;
import net.mcreator.warcraft.entity.FirerifleEntity;
import net.mcreator.warcraft.entity.FuturemagnumEntity;
import net.mcreator.warcraft.entity.GrenadeEntity;
import net.mcreator.warcraft.entity.RocketlauncherEntity;
import net.mcreator.warcraft.entity.SniperEntity;
import net.mcreator.warcraft.entity.SoldierEntity;
import net.mcreator.warcraft.entity.SoulkEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class WarcraftModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"warcraft");
    public static final RegistryObject<EntityType<SniperEntity>> SNIPER = WarcraftModEntities.register("projectile_sniper", EntityType.Builder.m_20704_(SniperEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(SniperEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<RocketlauncherEntity>> ROCKETLAUNCHER = WarcraftModEntities.register("projectile_rocketlauncher", EntityType.Builder.m_20704_(RocketlauncherEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(RocketlauncherEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<SoulkEntity>> SOULK = WarcraftModEntities.register("soulk", EntityType.Builder.m_20704_(SoulkEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(SoulkEntity::new).m_20719_().m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<FirerifleEntity>> FIRERIFLE = WarcraftModEntities.register("projectile_firerifle", EntityType.Builder.m_20704_(FirerifleEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(FirerifleEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<FuturemagnumEntity>> FUTUREMAGNUM = WarcraftModEntities.register("projectile_futuremagnum", EntityType.Builder.m_20704_(FuturemagnumEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(FuturemagnumEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<ArcherEntity>> ARCHER = WarcraftModEntities.register("archer", EntityType.Builder.m_20704_(ArcherEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(ArcherEntity::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<GrenadeEntity>> GRENADE = WarcraftModEntities.register("projectile_grenade", EntityType.Builder.m_20704_(GrenadeEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(GrenadeEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<SoldierEntity>> SOLDIER = WarcraftModEntities.register("soldier", EntityType.Builder.m_20704_(SoldierEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(SoldierEntity::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<AssasinEntity>> ASSASIN = WarcraftModEntities.register("assasin", EntityType.Builder.m_20704_(AssasinEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(AssasinEntity::new).m_20719_().m_20699_(0.6f, 1.8f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            SoulkEntity.init();
            ArcherEntity.init();
            SoldierEntity.init();
            AssasinEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)SOULK.get(), SoulkEntity.createAttributes().m_22265_());
        event.put((EntityType)ARCHER.get(), ArcherEntity.createAttributes().m_22265_());
        event.put((EntityType)SOLDIER.get(), SoldierEntity.createAttributes().m_22265_());
        event.put((EntityType)ASSASIN.get(), AssasinEntity.createAttributes().m_22265_());
    }
}

