/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.rpgmod.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.mcreator.rpgmod.world.features.GoblinFortressFeature;
import net.mcreator.rpgmod.world.features.GoblincampFeature;
import net.mcreator.rpgmod.world.features.YetiCaveFeature;
import net.mcreator.rpgmod.world.features.plants.WhisperBerryBushFeature;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber
public class RpgmodModFeatures {
    public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"rpgmod");
    private static final List<FeatureRegistration> FEATURE_REGISTRATIONS = new ArrayList<FeatureRegistration>();
    public static final RegistryObject<Feature<?>> GOBLINCAMP = RpgmodModFeatures.register("goblincamp", GoblincampFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, GoblincampFeature.GENERATE_BIOMES, GoblincampFeature::placedFeature));
    public static final RegistryObject<Feature<?>> GOBLIN_FORTRESS = RpgmodModFeatures.register("goblin_fortress", GoblinFortressFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, GoblinFortressFeature.GENERATE_BIOMES, GoblinFortressFeature::placedFeature));
    public static final RegistryObject<Feature<?>> WHISPER_BERRY_BUSH = RpgmodModFeatures.register("whisper_berry_bush", WhisperBerryBushFeature::feature, new FeatureRegistration(GenerationStep.Decoration.VEGETAL_DECORATION, WhisperBerryBushFeature.GENERATE_BIOMES, WhisperBerryBushFeature::placedFeature));
    public static final RegistryObject<Feature<?>> YETI_CAVE = RpgmodModFeatures.register("yeti_cave", YetiCaveFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, YetiCaveFeature.GENERATE_BIOMES, YetiCaveFeature::placedFeature));

    private static RegistryObject<Feature<?>> register(String registryname, Supplier<Feature<?>> feature, FeatureRegistration featureRegistration) {
        FEATURE_REGISTRATIONS.add(featureRegistration);
        return REGISTRY.register(registryname, feature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        for (FeatureRegistration registration : FEATURE_REGISTRATIONS) {
            if (registration.biomes() != null && !registration.biomes().contains(event.getName())) continue;
            event.getGeneration().getFeatures(registration.stage()).add(registration.placedFeature().get());
        }
    }

    private record FeatureRegistration(GenerationStep.Decoration stage, Set<ResourceLocation> biomes, Supplier<Holder<PlacedFeature>> placedFeature) {
    }
}

