/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.adventurecontent.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.adventurecontent.AdventurecontentMod;
import net.mcreator.adventurecontent.procedures.AntorioritemProcedure;
import net.mcreator.adventurecontent.procedures.ProximoitenProcedure;
import net.mcreator.adventurecontent.world.inventory.GoblinTradeMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class GoblinTradeButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public GoblinTradeButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public GoblinTradeButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(GoblinTradeButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(GoblinTradeButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            GoblinTradeButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = GoblinTradeMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            ProximoitenProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            AntorioritemProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        AdventurecontentMod.addNetworkMessage(GoblinTradeButtonMessage.class, GoblinTradeButtonMessage::buffer, GoblinTradeButtonMessage::new, GoblinTradeButtonMessage::handler);
    }
}

