/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.adventurecontent.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.adventurecontent.AdventurecontentMod;
import net.mcreator.adventurecontent.procedures.RemoveProcedure;
import net.mcreator.adventurecontent.procedures.TradeProcedure;
import net.mcreator.adventurecontent.world.inventory.GoblinTradeMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class GoblinTradeSlotMessage {
    private final int slotID;
    private final int x;
    private final int y;
    private final int z;
    private final int changeType;
    private final int meta;

    public GoblinTradeSlotMessage(int slotID, int x, int y, int z, int changeType, int meta) {
        this.slotID = slotID;
        this.x = x;
        this.y = y;
        this.z = z;
        this.changeType = changeType;
        this.meta = meta;
    }

    public GoblinTradeSlotMessage(FriendlyByteBuf buffer) {
        this.slotID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.changeType = buffer.readInt();
        this.meta = buffer.readInt();
    }

    public static void buffer(GoblinTradeSlotMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.slotID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        buffer.writeInt(message.changeType);
        buffer.writeInt(message.meta);
    }

    public static void handler(GoblinTradeSlotMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int slotID = message.slotID;
            int changeType = message.changeType;
            int meta = message.meta;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            GoblinTradeSlotMessage.handleSlotAction((Player)entity, slotID, changeType, meta, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleSlotAction(Player entity, int slotID, int changeType, int meta, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = GoblinTradeMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (slotID == 0 && changeType == 0) {
            TradeProcedure.execute((Entity)entity);
        }
        if (slotID == 1 && changeType == 1) {
            RemoveProcedure.execute((Entity)entity);
        }
        if (slotID == 1 && changeType == 2) {
            int amount = meta;
            RemoveProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        AdventurecontentMod.addNetworkMessage(GoblinTradeSlotMessage.class, GoblinTradeSlotMessage::buffer, GoblinTradeSlotMessage::new, GoblinTradeSlotMessage::handler);
    }
}

