/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.craftnoyaiba.network;

import java.util.function.Supplier;
import net.mcreator.craftnoyaiba.CraftNoYaibaMod;
import net.mcreator.craftnoyaiba.procedures.BreathOnKeyPressedProcedure;
import net.mcreator.craftnoyaiba.procedures.BreathOnKeyReleasedProcedure;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class BreathMessage {
    int type;
    int pressedms;

    public BreathMessage(int type, int pressedms) {
        this.type = type;
        this.pressedms = pressedms;
    }

    public BreathMessage(FriendlyByteBuf buffer) {
        this.type = buffer.readInt();
        this.pressedms = buffer.readInt();
    }

    public static void buffer(BreathMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.type);
        buffer.writeInt(message.pressedms);
    }

    public static void handler(BreathMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> BreathMessage.pressAction((Player)context.getSender(), message.type, message.pressedms));
        context.setPacketHandled(true);
    }

    public static void pressAction(Player entity, int type, int pressedms) {
        Level world = entity.f_19853_;
        double x = entity.m_20185_();
        double y = entity.m_20186_();
        double z = entity.m_20189_();
        if (!world.m_46805_(entity.m_20183_())) {
            return;
        }
        if (type == 0) {
            BreathOnKeyPressedProcedure.execute((Entity)entity);
        }
        if (type == 1) {
            BreathOnKeyReleasedProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CraftNoYaibaMod.addNetworkMessage(BreathMessage.class, BreathMessage::buffer, BreathMessage::new, BreathMessage::handler);
    }
}

