
package net.mcreator.iamsuspectsmod.fluid;

import net.minecraftforge.fluids.ForgeFlowingFluid;

import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.ParticleOptions;

import net.mcreator.iamsuspectsmod.init.IamsuspectsModModItems;
import net.mcreator.iamsuspectsmod.init.IamsuspectsModModFluids;
import net.mcreator.iamsuspectsmod.init.IamsuspectsModModFluidTypes;
import net.mcreator.iamsuspectsmod.init.IamsuspectsModModBlocks;

public abstract class DarkwaterFluid extends ForgeFlowingFluid {
	public static final ForgeFlowingFluid.Properties PROPERTIES = new ForgeFlowingFluid.Properties(() -> IamsuspectsModModFluidTypes.DARKWATER_TYPE.get(), () -> IamsuspectsModModFluids.DARKWATER.get(),
			() -> IamsuspectsModModFluids.FLOWING_DARKWATER.get()).explosionResistance(100f).tickRate(4).bucket(() -> IamsuspectsModModItems.DARKWATER_BUCKET.get()).block(() -> (LiquidBlock) IamsuspectsModModBlocks.DARKWATER.get());

	private DarkwaterFluid() {
		super(PROPERTIES);
	}

	@Override
	public ParticleOptions getDripParticle() {
		return ParticleTypes.WHITE_ASH;
	}

	public static class Source extends DarkwaterFluid {
		public int getAmount(FluidState state) {
			return 8;
		}

		public boolean isSource(FluidState state) {
			return true;
		}
	}

	public static class Flowing extends DarkwaterFluid {
		protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
			super.createFluidStateDefinition(builder);
			builder.add(LEVEL);
		}

		public int getAmount(FluidState state) {
			return state.getValue(LEVEL);
		}

		public boolean isSource(FluidState state) {
			return false;
		}
	}
}
