/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.decodesignfunctionsandblocks.block;

import java.util.List;
import net.mcreator.decodesignfunctionsandblocks.procedures.InfoAddonsSupplementariesProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.IPlantable;

public class CeramicPlanterBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public CeramicPlanterBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.DECORATED_POT).strength(21.0f, 2.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void appendHoverText(ItemStack itemstack, BlockGetter level, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, level, list, flag);
        Entity entity = itemstack.getEntityRepresentation();
        list.add((Component)Component.literal((String)InfoAddonsSupplementariesProcedure.execute()));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return state.getFluidState().isEmpty();
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.or((VoxelShape)CeramicPlanterBlock.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), (VoxelShape[])new VoxelShape[]{CeramicPlanterBlock.box((double)0.0, (double)12.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0), CeramicPlanterBlock.box((double)2.0, (double)8.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0), CeramicPlanterBlock.box((double)12.0, (double)8.0, (double)4.0, (double)14.0, (double)12.0, (double)12.0), CeramicPlanterBlock.box((double)14.0, (double)12.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0), CeramicPlanterBlock.box((double)0.0, (double)12.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), CeramicPlanterBlock.box((double)2.0, (double)8.0, (double)12.0, (double)14.0, (double)12.0, (double)14.0), CeramicPlanterBlock.box((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)12.0, (double)4.0), CeramicPlanterBlock.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0), CeramicPlanterBlock.box((double)6.0, (double)2.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0), CeramicPlanterBlock.box((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), CeramicPlanterBlock.box((double)2.0, (double)12.5, (double)2.0, (double)14.0, (double)15.5, (double)14.0)});
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean flag = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return super.updateShape(state, facing, facingState, world, currentPos, facingPos);
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction direction, IPlantable plantable) {
        return true;
    }
}

