/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.decodesignfunctionsandblocks.item;

import java.util.List;
import net.mcreator.decodesignfunctionsandblocks.init.DecodesignFunctionsAndBlocksModItems;
import net.mcreator.decodesignfunctionsandblocks.procedures.InfoAddonsSupplementariesProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public abstract class FlaxArmorItem
extends ArmorItem {
    public FlaxArmorItem(ArmorItem.Type type, Item.Properties properties) {
        super(new ArmorMaterial(){

            public int getDurabilityForType(ArmorItem.Type type) {
                return (new int[]{13, 15, 16, 11})[type.getSlot().getIndex()] * 15;
            }

            public int getDefenseForType(ArmorItem.Type type) {
                return (new int[]{2, 6, 5, 2})[type.getSlot().getIndex()];
            }

            public int getEnchantmentValue() {
                return 9;
            }

            public SoundEvent getEquipSound() {
                return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("item.armor.equip_leather"));
            }

            public Ingredient getRepairIngredient() {
                return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)DecodesignFunctionsAndBlocksModItems.FLAX_FABRIC.get())});
            }

            public String getName() {
                return "flax_armor";
            }

            public float getToughness() {
                return 0.0f;
            }

            public float getKnockbackResistance() {
                return 0.0f;
            }
        }, type, properties);
    }

    public static class Boots
    extends FlaxArmorItem {
        public Boots() {
            super(ArmorItem.Type.BOOTS, new Item.Properties());
        }

        public void appendHoverText(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.appendHoverText(itemstack, level, list, flag);
            Entity entity = itemstack.getEntityRepresentation();
            list.add((Component)Component.literal((String)InfoAddonsSupplementariesProcedure.execute()));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "decodesign_functions_and_blocks:textures/models/armor/flax_layer_1.png";
        }
    }

    public static class Leggings
    extends FlaxArmorItem {
        public Leggings() {
            super(ArmorItem.Type.LEGGINGS, new Item.Properties());
        }

        public void appendHoverText(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.appendHoverText(itemstack, level, list, flag);
            Entity entity = itemstack.getEntityRepresentation();
            list.add((Component)Component.literal((String)InfoAddonsSupplementariesProcedure.execute()));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "decodesign_functions_and_blocks:textures/models/armor/flax_layer_2.png";
        }
    }

    public static class Chestplate
    extends FlaxArmorItem {
        public Chestplate() {
            super(ArmorItem.Type.CHESTPLATE, new Item.Properties());
        }

        public void appendHoverText(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.appendHoverText(itemstack, level, list, flag);
            Entity entity = itemstack.getEntityRepresentation();
            list.add((Component)Component.literal((String)InfoAddonsSupplementariesProcedure.execute()));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "decodesign_functions_and_blocks:textures/models/armor/flax_layer_1.png";
        }
    }

    public static class Helmet
    extends FlaxArmorItem {
        public Helmet() {
            super(ArmorItem.Type.HELMET, new Item.Properties());
        }

        public void appendHoverText(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.appendHoverText(itemstack, level, list, flag);
            Entity entity = itemstack.getEntityRepresentation();
            list.add((Component)Component.literal((String)InfoAddonsSupplementariesProcedure.execute()));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "decodesign_functions_and_blocks:textures/models/armor/flax_layer_1.png";
        }
    }
}

